/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.fraud;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.queue.DiskErrorListener;
import ru.softlogic.srv.queue.QueueData;
import ru.softlogic.srv.queue.QueueStatus;
import ru.softlogic.system.util.ObjectReadWriteStream;

public class FraudQueue {
    private QueueData queueData;
    private Logger log;
    private boolean diskError;
    private ObjectReadWriteStream mainFile;
    private ObjectReadWriteStream tmpFile;
    private DiskErrorListener listener;

    public FraudQueue(String fileName, DiskErrorListener listener) {
        this.listener = listener;
        this.log = Logger.getLogger((String)"net");
        this.log.setAdditivity(false);
        this.printFileSize(fileName);
        this.printFileSize(fileName + ".tmp");
        try {
            this.mainFile = new ObjectReadWriteStream(fileName);
            this.tmpFile = new ObjectReadWriteStream(fileName + ".tmp");
            this.diskError = false;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430", (Throwable)ex);
            this.diskError = true;
        }
        this.readData();
    }

    public synchronized QueueStatus getStatus() {
        QueueStatus qs = new QueueStatus(this.queueData.getAge() / 60000L, this.queueData.getSize(), this.diskError, this.queueData.isRemoteLock());
        if (qs.getSize() > 0 || qs.getTimeout() > 0L) {
            this.log.debug((Object)("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + qs));
        }
        return qs;
    }

    public synchronized ProcessingResult putOperation(Operation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + operation));
            this.queueData.getFinancialQueue().add(operation);
            this.saveData();
        }
        return new ProcessingResult(ProcessingResultType.Ok);
    }

    public synchronized Operation[] getOperations() {
        LinkedList<Operation> op = null;
        if (!this.queueData.getFinancialQueue().isEmpty()) {
            op = new LinkedList<Operation>();
            for (Object obj : this.queueData.getFinancialQueue()) {
                if (!(obj instanceof Operation) || obj instanceof GroupOperation) break;
                op.add((Operation)obj);
            }
        }
        return op == null || op.isEmpty() ? null : op.toArray(new Operation[op.size()]);
    }

    public synchronized void deleteOperations(Operation[] opers) {
        if (opers != null) {
            for (Operation op : opers) {
                if (this.queueData.getFinancialQueue().remove(op)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
            }
            this.saveData();
        }
    }

    public synchronized ProcessingResult putGroupOperation(GroupOperation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + operation));
            this.queueData.getFinancialQueue().add(operation);
            this.saveData();
        }
        return new ProcessingResult(ProcessingResultType.Ok);
    }

    public synchronized GroupOperation[] getGroupOperations() {
        LinkedList<GroupOperation> op = null;
        if (!this.queueData.getFinancialQueue().isEmpty()) {
            op = new LinkedList<GroupOperation>();
            for (Object obj : this.queueData.getFinancialQueue()) {
                if (!(obj instanceof GroupOperation)) break;
                op.add((GroupOperation)obj);
            }
        }
        return op == null || op.isEmpty() ? null : op.toArray(new GroupOperation[op.size()]);
    }

    public synchronized void deleteGroupOperations(GroupOperation[] opers) {
        if (opers != null) {
            for (GroupOperation op : opers) {
                if (this.queueData.getFinancialQueue().remove(op)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
            }
            this.saveData();
        }
    }

    public synchronized boolean putMoneyCollection(MoneyCollection mc) {
        if (mc != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f: " + mc));
            this.queueData.getFinancialQueue().add(mc);
            return this.saveData();
        }
        return true;
    }

    public synchronized MoneyCollection[] getMoneyCollections() {
        LinkedList<MoneyCollection> mcs = null;
        if (!this.queueData.getFinancialQueue().isEmpty()) {
            mcs = new LinkedList<MoneyCollection>();
            for (Object obj : this.queueData.getFinancialQueue()) {
                if (!(obj instanceof MoneyCollection)) break;
                mcs.add((MoneyCollection)obj);
            }
        }
        return mcs == null || mcs.isEmpty() ? null : mcs.toArray(new MoneyCollection[mcs.size()]);
    }

    public synchronized void deleteMoneyCollections(MoneyCollection[] mcs) {
        if (mcs != null) {
            for (MoneyCollection mc : mcs) {
                if (this.queueData.getFinancialQueue().remove(mc)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + mc));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + mc));
            }
            this.saveData();
        }
    }

    public boolean isRemoteLock() {
        return this.queueData.isRemoteLock();
    }

    public void setRemoteLock(boolean remoteLock) {
        this.queueData.setRemoteLock(remoteLock);
        this.saveData();
    }

    private void readData() {
        try {
            this.log.info((Object)"Read main store");
            this.queueData = (QueueData)this.mainFile.readObject();
            if (this.queueData != null) {
                this.log.info((Object)"Success");
            } else {
                this.log.info((Object)"Store have no data");
            }
        }
        catch (Exception ex) {
            this.log.info((Object)("Error on read main store: " + ex.getMessage()));
        }
        if (this.queueData == null) {
            try {
                this.log.info((Object)"Read secondary store");
                this.queueData = (QueueData)this.tmpFile.readObject();
                if (this.queueData != null) {
                    this.log.info((Object)"Success");
                } else {
                    this.log.info((Object)"Store have no data");
                }
            }
            catch (Exception ex) {
                this.log.info((Object)("Error on read secondary store: " + ex.getMessage()));
            }
        }
        if (this.queueData == null) {
            this.queueData = new QueueData();
        } else {
            this.log.info((Object)"===========================================================");
            this.log.info((Object)("Store contains: " + this.queueData));
            this.log.info((Object)"===========================================================");
        }
    }

    private boolean saveData() {
        try {
            this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
            this.tmpFile.writeObject((Serializable)this.queueData);
            this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
            this.mainFile.writeObject((Serializable)this.queueData);
        }
        catch (Exception ex) {
            this.diskError = true;
            if (this.listener != null) {
                this.listener.onDiskError();
            }
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: ", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.mainFile != null) {
            try {
                this.mainFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printFileSize(String name) {
        File f = new File(name);
        if (f.canRead()) {
            this.log.info((Object)(f.getAbsolutePath() + ", size=" + f.length()));
        } else {
            this.log.info((Object)(f.getAbsolutePath() + ", n/a"));
        }
    }
}

