/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.ServerUser;

public class UsersUtil {
    public static final String TAB_MAIN = "main";
    public static final String TAB_KKM = "kkm";
    public static final String TAB_COLLECTION = "collection";
    public static final String TAB_LOG = "log";
    public static final String TAB_CASH = "cash";
    public static final String TAB_PAYMENTS = "payments";
    public static final String TAB_STATES = "states";
    public static final String TAB_HOPPER = "hopper";
    public static final String BTN_CALIBRATE = "calibrate";
    public static final String BTN_NOTE_COLLECTION = "cashMoneyCollection";
    public static final String BTN_COIN_COLLECTION = "coinMoneyCollection";
    public static final String BTN_COIN_HOPPER_COLLECTION = "coinHopperMoneyCollection";
    public static final String BTN_CHECK_BALANCE = "checkBalance";
    public static final String BTN_CLOSE_SOFTWARE = "closeSoftware";
    public static final String BTN_UPDATE_BUTTON = "update";
    public static final String BTN_LOCAL_UPDATE_BUTTON = "localUpdate";
    public static final String BTN_MINIMIZE_SOFTWARE = "minimizeSoftware";
    public static final String BTN_POWEROFF_TERMINAL = "poweroffTerminal";
    public static final String BTN_REBOOT_TERMINAL = "rebootTerminal";
    public static final String BTN_RESTART_SOFTWARE = "restartSoftware";
    public static final String BTN_START_CONFIG = "startConfig";
    public static final String BTN_TEST_NETWORK = "testNetwork";
    public static final String BTN_TEST_PRINTER = "testPrinter";
    public static final String BTN_OPEN_CTRL_PANEL = "controlPanel";
    public static final String BTN_UNLOAD_PAYMENTS = "unloadPayments";
    public static final String BTN_TEST_SELL = "testSell";
    public static final String BTN_X_REPORT = "xReport";
    public static final String BTN_Z_REPORT = "zReport";
    public static final String BTN_Z_REPORT_MEM = "zReportMem";
    public static final String BTN_Z_DATE_RANGE = "printDateRange";
    public static final String BTN_TEST_FISCAL_CLIENT = "testFiscalClient";

    public static ServerUser authentication(String login, String password) {
        String passwordMd5 = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            byte[] result = md.digest(password.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte bt : result) {
                sb.append(String.format("%02x", bt & 0xFF));
            }
            passwordMd5 = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        ServerUser[] users = null;
        try {
            users = ReferenceManager.getInstance().getServerUsers();
        }
        catch (ReferenceException ex) {
            return null;
        }
        if (users != null && users.length > 0 && !passwordMd5.isEmpty()) {
            for (ServerUser su : users) {
                if (!login.equals(su.getLogin()) || !passwordMd5.equals(su.getPassword())) continue;
                return su;
            }
        }
        return null;
    }

    public static ServerUser authenticationByMD5(String login, String passwordMd5) {
        if (passwordMd5 == null || passwordMd5.isEmpty()) {
            return null;
        }
        ServerUser[] users = null;
        try {
            users = ReferenceManager.getInstance().getServerUsers();
        }
        catch (ReferenceException ex) {
            return null;
        }
        if (users != null && users.length > 0 && !passwordMd5.isEmpty()) {
            for (ServerUser su : users) {
                if (!login.equals(su.getLogin()) || !passwordMd5.equals(su.getPassword())) continue;
                return su;
            }
        }
        return null;
    }

    public static boolean canShowTab(ServerUser user, String tabName) {
        if (user == null || tabName == null) {
            return false;
        }
        if (user.getAccessList() == null || user.getAccessList().isEmpty()) {
            return false;
        }
        return user.getAccessList().contains(tabName + ":");
    }

    public static boolean canShowButton(ServerUser user, String tabName, String buttonName) {
        if (user == null || buttonName == null || tabName == null) {
            return false;
        }
        if (user.getAccessList() == null || user.getAccessList().isEmpty()) {
            return false;
        }
        return user.getAccessList().matches("^.*" + tabName + ":[^:]*" + buttonName + ".*$");
    }
}

