/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.softlogic.system.util.SystemTimeMarker;
import ru.softlogic.system.util.TimeMarker;

public abstract class EventNotifier {
    private static EventNotifier instance;
    private static TimeMarker timeMarker;
    private static final Set<Integer> messages;
    private static final Map<Integer, Long> timeouts;

    public static void init(EventNotifier instance, TimeMarker timeMarker) {
        if (instance == null) {
            throw new NullPointerException("Instance is null");
        }
        if (timeMarker == null) {
            throw new NullPointerException("TimeMarker is null");
        }
        EventNotifier.instance = instance;
        EventNotifier.timeMarker = timeMarker;
    }

    protected abstract void onError(Throwable var1);

    protected abstract void onError(String var1);

    protected abstract void onProblem(String var1);

    protected abstract void onRequestRestart(String var1);

    public static void notifyError(Throwable ex) {
        if (instance != null) {
            instance.onError(ex);
        }
    }

    public static void notifyError(String message) {
        if (instance != null) {
            instance.onError(message);
        }
    }

    public static void notifyProblem(String message) {
        if (instance != null) {
            instance.onProblem(message);
        }
    }

    public static void requestRestart(String cause) {
        if (instance != null) {
            instance.onRequestRestart(cause);
        }
    }

    public static void notifyErrorOnce(String message) {
        if (message == null) {
            return;
        }
        int mHash = message.hashCode();
        if (messages.contains(mHash)) {
            return;
        }
        messages.add(mHash);
        EventNotifier.notifyError(message);
    }

    public static void notifyProblemOnce(String message) {
        if (message == null) {
            return;
        }
        int mHash = message.hashCode();
        if (messages.contains(mHash)) {
            return;
        }
        messages.add(mHash);
        EventNotifier.notifyProblem(message);
    }

    public static void notifyError(String message, int timeout) {
        if (EventNotifier.canNotify(message, timeout)) {
            EventNotifier.notifyError(message);
        }
    }

    public static void notifyProblemOnce(String message, int timeout) {
        if (EventNotifier.canNotify(message, timeout)) {
            EventNotifier.notifyProblem(message);
        }
    }

    private static boolean canNotify(String message, int timeout) {
        if (message == null) {
            return false;
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        long current = timeMarker.getMark();
        int mHash = message.hashCode();
        Long mark = timeouts.get(mHash);
        if (mark != null && current - mark < (long)timeout) {
            return false;
        }
        timeouts.put(mHash, current);
        return true;
    }

    static {
        timeMarker = new SystemTimeMarker();
        messages = new HashSet<Integer>();
        timeouts = new HashMap<Integer, Long>();
    }
}

