/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.provider;

import i18n.B;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.advanced.AdvDialog;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.provider.ForceVerifyListener;
import ru.softlogic.provider.ProviderHelperListener;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.VerifyType;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.api.verify.VerifyResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class ProviderHelper {
    private final ApplicationContext context;
    private final AdvDialog advDialog;
    private static final Logger log = Logger.getLogger((String)"pay");

    public ProviderHelper(ApplicationContext context) {
        this.context = context;
        this.advDialog = new AdvDialog();
        this.advDialog.addListener((DialogListener)new LocalDialogListener());
    }

    public static Commission getPersonalCommission(Map<String, Object> form, int serviceId, Short stid) {
        if (form == null) {
            return null;
        }
        Commission res = null;
        InputElement ieRes = null;
        try {
            PersonalNumber[] numbers = ReferenceManager.getInstance().getPersonalNumbers();
            if (numbers != null) {
                InputElement ie;
                Object obj;
                for (PersonalNumber pn : numbers) {
                    if (pn.getType() != PersonalNumberType.White || serviceId != pn.getService()) continue;
                    for (String key : form.keySet()) {
                        obj = form.get(key);
                        if (!(obj instanceof InputElement)) continue;
                        ie = (InputElement)obj;
                        if (!pn.getNumber().equals(ie.getValue())) continue;
                        ieRes = ie;
                        res = pn.getCommission();
                    }
                }
                if (res == null && stid != null) {
                    for (PersonalNumber pn : numbers) {
                        if (pn.getType() != PersonalNumberType.White || !stid.equals(pn.getServiceTypeId())) continue;
                        for (String key : form.keySet()) {
                            obj = form.get(key);
                            if (!(obj instanceof InputElement)) continue;
                            ie = (InputElement)obj;
                            if (!pn.getNumber().equals(ie.getValue())) continue;
                            ieRes = ie;
                            res = pn.getCommission();
                        }
                    }
                }
                if (res == null) {
                    for (PersonalNumber pn : numbers) {
                        if (pn.getType() != PersonalNumberType.White || pn.getService() != 0 || pn.getServiceTypeId() != null) continue;
                        for (String key : form.keySet()) {
                            obj = form.get(key);
                            if (!(obj instanceof InputElement)) continue;
                            ie = (InputElement)obj;
                            if (!pn.getNumber().equals(ie.getValue())) continue;
                            ieRes = ie;
                            res = pn.getCommission();
                        }
                    }
                }
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        if (res != null && ieRes != null) {
            log.info((Object)("Find personal commission for " + ieRes.getKey() + ":" + ieRes.getKeyTitle()));
        }
        return res;
    }

    public static boolean isUnwantedClient(String number, int serviceId, Short stid) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("id1", number);
        return ProviderHelper.isUnwantedClient(null, form, serviceId, stid);
    }

    public static boolean isUnwantedClient(PersonalNumber[] personalNumbers, Map<String, Object> form, int serviceId, Short stid) {
        if (form == null) {
            return false;
        }
        try {
            PersonalNumber[] numbers = personalNumbers;
            if (numbers == null) {
                numbers = ReferenceManager.getInstance().getPersonalNumbers();
            }
            if (numbers != null) {
                InputElement ie;
                Object obj;
                for (PersonalNumber pn : numbers) {
                    if (pn.getType() != PersonalNumberType.Black || serviceId != pn.getService()) continue;
                    for (String key : form.keySet()) {
                        obj = form.get(key);
                        if (!(obj instanceof InputElement)) continue;
                        ie = (InputElement)obj;
                        if (!pn.getNumber().equals(ie.getValue())) continue;
                        return true;
                    }
                }
                if (stid != null) {
                    for (PersonalNumber pn : numbers) {
                        if (pn.getType() != PersonalNumberType.Black || !stid.equals(pn.getServiceTypeId())) continue;
                        for (String key : form.keySet()) {
                            obj = form.get(key);
                            if (!(obj instanceof InputElement)) continue;
                            ie = (InputElement)obj;
                            if (!pn.getNumber().equals(ie.getValue())) continue;
                            return true;
                        }
                    }
                }
                for (PersonalNumber pn : numbers) {
                    if (pn.getType() != PersonalNumberType.Black || pn.getService() != 0 || pn.getServiceTypeId() != null) continue;
                    for (String key : form.keySet()) {
                        obj = form.get(key);
                        if (!(obj instanceof InputElement)) continue;
                        ie = (InputElement)obj;
                        if (!pn.getNumber().equals(ie.getValue())) continue;
                        return true;
                    }
                }
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        return false;
    }

    public void forceVerify(Service service, String number, ForceVerifyListener listener, Locale locale, boolean ignoreMMC) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("id1", new InputElement("id1", "id1", number));
        this.forceVerify(service, form, listener, locale, ignoreMMC);
    }

    public void forceVerify(Service service, Map<String, Object> data, ForceVerifyListener listener, Locale locale, boolean ignoreMMC) {
        this.context.getTaskExecutor().execute(new ForceVerifyTask(service, data, listener, locale, ignoreMMC));
    }

    public void verify(Service service, Commission commission, boolean verify, String number, ProviderHelperListener listener, Locale locale, boolean ignoreMMC) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("id1", new InputElement("id1", "id1", number));
        this.verify(service, commission, verify, form, listener, locale, ignoreMMC);
    }

    public void verify(Service service, Commission commission, boolean verify, Map<String, Object> data, ProviderHelperListener listener, Locale locale, boolean ignoreMMC) {
        if (service.getVerifyType() == VerifyType.Verify || service.getVerifyType() == VerifyType.HalfOnline || service.getVerifyType() == VerifyType.Optional && verify) {
            this.context.getTaskExecutor().execute(new VerifyTask(service, commission, data, listener, locale, ignoreMMC));
        } else {
            listener.toPayment();
        }
    }

    private Sum getOperationSum(Map<String, Object> data) {
        Object obj = data.get("#sum");
        Sum operationSum = null;
        if (obj != null) {
            if (obj instanceof TransactionSum) {
                TransactionSum ts = (TransactionSum)obj;
                operationSum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
            } else if (obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    operationSum = new Sum(Double.parseDouble(ie.getValue()));
                } else if (ie.hasFlag(2048)) {
                    log.error((Object)("Wrong sum format: " + ie));
                } else {
                    log.error((Object)("Wrong sum format: " + ie.getValue()));
                }
            } else if (obj instanceof Sum) {
                operationSum = (Sum)obj;
            }
        }
        return operationSum;
    }

    private Map<String, InputElement> getVerifyData(Service service, Commission commission, Map<String, Object> form, boolean ignoreMMC) {
        Map data = StoreHelper.convertD(form);
        Sum operSum = this.getOperationSum(form);
        if (operSum != null) {
            Sum reqSum = CommissionCalculator.calculate((Sum)operSum, (Commission)commission, (Commission)service.getCommission(), (Date)new Date(), (String)"CASH", (boolean)ignoreMMC, (FeeSum)Session.getInstance().getPack().getProviderFee());
            Sum comm = reqSum.sub(operSum);
            if (comm.getBasicSum() < 0) {
                comm = new Sum();
            }
            String opr = String.valueOf(operSum.getBasicSum());
            String com = String.valueOf(comm.getBasicSum());
            data.put("Sumpurchase", new InputElement("Sumpurchase", "Sumpurchase", opr));
            data.put("Commission", new InputElement("Commission", "Commission", com));
        }
        return data;
    }

    public void notifyUnknownNumber(MenuItem menuItem, String number) {
        this.context.getServerConnector().sendEvent(new Event(EventType.NumberFault, menuItem.getService().getName() + ": " + number));
    }

    private class LocalDialogListener
    implements DialogListener {
        private LocalDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            ProviderHelper.this.context.toMainMenu();
        }
    }

    private class ForceVerifyTask
    implements Task {
        private final Service service;
        private Commission commission;
        private final Map<String, Object> form;
        private final ForceVerifyListener listener;
        private final Locale locale;
        private final boolean ignoreMMC;

        public ForceVerifyTask(Service service, Map<String, Object> form, ForceVerifyListener listener, Locale locale, boolean ignoreMMC) {
            this.service = service;
            this.form = form;
            this.listener = listener;
            this.locale = locale;
            this.ignoreMMC = ignoreMMC;
        }

        @Override
        public Object execute() {
            try {
                log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u043d\u043e\u043c\u0435\u0440\u0430");
                return ProviderHelper.this.context.getServerConnector().forceVerify(this.service, ProviderHelper.this.getVerifyData(this.service, this.commission, this.form, this.ignoreMMC));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + object));
            if (object instanceof VerifyResult) {
                VerifyResult vr = (VerifyResult)object;
                this.listener.onResult(vr);
            } else {
                this.listener.onException((Exception)object);
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.verify.wait", (Locale)this.locale);
        }
    }

    private class VerifyTask
    implements Task {
        private final Service service;
        private final Commission commission;
        private final Map<String, Object> form;
        private final ProviderHelperListener listener;
        private final Locale locale;
        private final boolean ignoreMMC;

        public VerifyTask(Service service, Commission commission, Map<String, Object> form, ProviderHelperListener listener, Locale locale, boolean ignoreMMC) {
            this.service = service;
            this.commission = commission;
            this.form = form;
            this.listener = listener;
            this.locale = locale;
            this.ignoreMMC = ignoreMMC;
        }

        @Override
        public Object execute() {
            try {
                log.info((Object)"Run online request");
                return ProviderHelper.this.context.getServerConnector().verify(this.service, ProviderHelper.this.getVerifyData(this.service, this.commission, this.form, this.ignoreMMC));
            }
            catch (ConnectorException ex) {
                log.info((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435", (Throwable)ex);
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + object));
            if (this.service.getVerifyType() == VerifyType.HalfOnline) {
                if (object instanceof VerifyResult) {
                    VerifyResult vr = (VerifyResult)object;
                    if (vr.getResultType() != VerifyResultType.NotFound && vr.getResultType() != VerifyResultType.ProviderPermit) {
                        this.listener.onVerifyComplete(vr);
                        return;
                    }
                    String message = vr.getDataItems() != null && vr.getDataItems().length > 0 ? MessageFormat.format(B.get((String)("Request.verify.error.extended." + vr.getResultType()), (Locale)this.locale), vr.getDataItems()[0].getValue()) : B.get((String)("Request.verify.error." + vr.getResultType()), (Locale)this.locale);
                    if (message != null) {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 10, DC.cases((int)1), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                VerifyTask.this.listener.onVerifyError();
                            }
                        });
                        ProviderHelper.this.context.showDialog((DialogInterface)dialog);
                    }
                } else {
                    log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u043d\u043b\u0430\u0439\u043d-\u0437\u0430\u043f\u0440\u043e\u0441\u0435", (Throwable)((Exception)object));
                    String message = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436?";
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, message, 10, DC.cases((int)24), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            if (userCase == UserCase.Ok) {
                                VerifyTask.this.listener.onVerifyComplete(new VerifyResult(VerifyResultType.Ok));
                            } else {
                                VerifyTask.this.listener.onVerifyError();
                            }
                        }
                    });
                    ProviderHelper.this.context.showDialog((DialogInterface)dialog);
                }
            } else {
                String message;
                if (object instanceof VerifyResult) {
                    VerifyResult vr = (VerifyResult)object;
                    if (vr.getResultType() == VerifyResultType.Ok) {
                        this.listener.onVerifyComplete(vr);
                        return;
                    }
                    message = vr.getDataItems() != null && vr.getDataItems().length > 0 ? MessageFormat.format(B.get((String)("Request.verify.error.extended." + vr.getResultType()), (Locale)this.locale), vr.getDataItems()[0].getValue()) : B.get((String)("Request.verify.error." + vr.getResultType()), (Locale)this.locale);
                } else {
                    log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u043d\u043b\u0430\u0439\u043d-\u0437\u0430\u043f\u0440\u043e\u0441\u0435", (Throwable)((Exception)object));
                    message = B.get((String)"Request.verify.error.Failure", (Locale)this.locale);
                }
                if (message != null) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 10, DC.cases((int)1), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            VerifyTask.this.listener.onVerifyError();
                        }
                    });
                    ProviderHelper.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.verify.wait", (Locale)this.locale);
        }
    }
}

