/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.utils.managerpl;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.module.utils.managerpl.ManagerPL;
import ru.softlogic.module.utils.managerpl.PlayList;
import ru.softlogic.module.utils.managerpl.Track;
import ru.softlogic.reference.adv.Movie;

public class PlayListHelper {
    private static final long DAY = 86400000L;

    public static ArrayList<PlayList> createPlayLists(Movie[] movies, Logger log) {
        if (log != null) {
            log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442\u043e\u0432");
        }
        ArrayList<PlayList> pls = new ArrayList<PlayList>();
        if (movies == null) {
            if (log != null) {
                log.info((Object)"\u041c\u0430\u0441\u0441\u0438\u0432 \u043c\u0443\u0432\u0438\u043a\u043e\u0432 \u043f\u0443\u0441\u0442, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u044b\u0439 \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442, \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
            }
            pls.add(PlayListHelper.createDefaultPL());
            return pls;
        }
        ArrayList<Movie> tmp = new ArrayList<Movie>();
        for (Movie m : movies) {
            boolean f = true;
            for (Movie t : tmp) {
                if ((t.getBegin() != null || m.getBegin() != null) && (t.getBegin() == null || !t.getBegin().equals(m.getBegin())) || (t.getEnd() != null || m.getEnd() != null) && (t.getEnd() == null || !t.getEnd().equals(m.getEnd()))) continue;
                f = false;
                break;
            }
            if (!f) continue;
            tmp.add(m);
        }
        for (Movie m : tmp) {
            PlayListHelper.addPlayListsForMovie(m, pls);
        }
        if (log != null) {
            log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u044b\u0439 \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442");
        }
        pls.add(PlayListHelper.createDefaultPL());
        return pls;
    }

    private static void addPlayListsForMovie(Movie movie, ArrayList<PlayList> pls) {
        PlayList pl;
        if (movie == null) {
            return;
        }
        Movie m = new Movie();
        m.setBegin(movie.getBegin());
        m.setEnd(movie.getEnd());
        if (pls.isEmpty()) {
            pls.add(new PlayList(m.getBegin(), m.getEnd(), false));
            return;
        }
        do {
            for (PlayList pl2 : pls) {
                if ((pl2.getdStart() != null || m.getBegin() != null) && (pl2.getdStart() == null || !pl2.getdStart().equals(m.getBegin())) || (pl2.getdEnd() != null || m.getEnd() != null) && (pl2.getdEnd() == null || !pl2.getdEnd().equals(m.getEnd()))) continue;
                return;
            }
            if (!PlayListHelper.sequenceFound(m, pls, 0)) continue;
            return;
        } while (!((pl = pls.get(0)).getdStart() != null && (m.getBegin() == null || pl.getdStart().after(m.getBegin())) ? (m = PlayListHelper.addBefore(m, pls)) == null : ((pl = pls.get(pls.size() - 1)).getdEnd() != null && (m.getBegin() == null || pl.getdEnd().before(m.getBegin())) ? (m = PlayListHelper.addAfter(m, pls)) == null : (m = PlayListHelper.addMiddle(m, pls)) == null)));
    }

    private static boolean sequenceFound(Movie m, ArrayList<PlayList> pls, int index) {
        if (index < pls.size()) {
            PlayList pl = pls.get(index);
            if (pl.getdStart() == null && m.getBegin() == null || pl.getdStart() != null && pl.getdStart().equals(m.getBegin())) {
                if (pl.getdEnd() == null && m.getEnd() == null || pl.getdEnd() != null && pl.getdEnd().equals(m.getEnd())) {
                    return true;
                }
                if (pl.getdEnd() == null || m.getEnd() != null && pl.getdEnd().after(m.getEnd())) {
                    return false;
                }
                m.setBegin(new Date(pl.getdEnd().getTime() + 86400000L));
                return PlayListHelper.sequenceFound(m, pls, index + 1);
            }
            if (pl.getdStart() == null || m.getBegin() != null && pl.getdStart().before(m.getBegin())) {
                return PlayListHelper.sequenceFound(m, pls, index + 1);
            }
            return false;
        }
        return false;
    }

    private static Movie addBefore(Movie m, ArrayList<PlayList> pls) {
        PlayList pl = pls.get(0);
        if (m.getEnd() == null || pl.getdStart().before(m.getEnd()) || pl.getdStart().equals(m.getEnd())) {
            pls.add(0, new PlayList(m.getBegin(), new Date(pl.getdStart().getTime() - 86400000L), false));
            m.setBegin(pl.getdStart());
        } else {
            pls.add(0, new PlayList(m.getBegin(), m.getEnd(), false));
            m = null;
        }
        return m;
    }

    private static Movie addMiddle(Movie m, ArrayList<PlayList> pls) {
        PlayList equalsPL = null;
        PlayList beforePL = null;
        for (PlayList pl : pls) {
            if (pl.getdStart() == null && m.getBegin() == null || pl.getdStart() != null && pl.getdStart().equals(m.getBegin())) {
                equalsPL = pl;
                break;
            }
            if (pl.getdStart() != null && (m.getBegin() == null || !pl.getdStart().before(m.getBegin()))) continue;
            beforePL = pl;
        }
        if (equalsPL != null) {
            if (equalsPL.getdEnd() != null && (m.getEnd() == null || equalsPL.getdEnd().before(m.getEnd()))) {
                m.setBegin(new Date(equalsPL.getdEnd().getTime() + 86400000L));
                return m;
            }
            int index = pls.indexOf(equalsPL);
            pls.remove(equalsPL);
            pls.add(index, new PlayList(equalsPL.getdStart(), m.getEnd(), false));
            pls.add(index + 1, new PlayList(new Date(m.getEnd().getTime() + 86400000L), equalsPL.getdEnd(), false));
            return null;
        }
        if (beforePL != null) {
            int index = pls.indexOf(beforePL);
            if (beforePL.getdEnd() != null && m.getBegin() != null && beforePL.getdEnd().before(m.getBegin())) {
                PlayList nextPL = pls.get(index + 1);
                if (m.getEnd() != null && nextPL.getdStart().after(m.getEnd())) {
                    pls.add(index + 1, new PlayList(m.getBegin(), m.getEnd(), false));
                    return null;
                }
                if (m.getEnd() == null || nextPL.getdStart().equals(m.getEnd()) || nextPL.getdStart().before(m.getEnd())) {
                    pls.remove(nextPL);
                    pls.add(index + 1, new PlayList(m.getBegin(), new Date(nextPL.getdStart().getTime() - 86400000L), false));
                    if (nextPL.getdEnd() == null && m.getEnd() == null || nextPL.getdEnd() != null && nextPL.getdEnd().equals(m.getEnd())) {
                        pls.add(index + 2, new PlayList(nextPL.getdStart(), nextPL.getdEnd(), false));
                        return null;
                    }
                    if (nextPL.getdEnd() == null || m.getEnd() != null && nextPL.getdEnd().after(m.getEnd())) {
                        pls.add(index + 2, new PlayList(nextPL.getdStart(), m.getEnd(), false));
                        pls.add(index + 3, new PlayList(new Date(m.getEnd().getTime() + 86400000L), nextPL.getdEnd(), false));
                        return null;
                    }
                    pls.add(index + 2, new PlayList(nextPL.getdStart(), nextPL.getdEnd(), false));
                    m.setBegin(new Date(nextPL.getdEnd().getTime() + 86400000L));
                    return m;
                }
            } else {
                pls.remove(beforePL);
                if (m.getEnd() != null && (beforePL.getdEnd() == null || m.getEnd().before(beforePL.getdEnd()))) {
                    pls.add(index, new PlayList(beforePL.getdStart(), new Date(m.getBegin().getTime() - 86400000L), false));
                    pls.add(index + 1, new PlayList(m.getBegin(), m.getEnd(), false));
                    pls.add(index + 2, new PlayList(new Date(m.getEnd().getTime() + 86400000L), beforePL.getdEnd(), false));
                    return null;
                }
                if (m.getEnd() == null && beforePL.getdEnd() == null || beforePL.getdEnd() != null && beforePL.getdEnd().equals(m.getEnd())) {
                    pls.add(index, new PlayList(beforePL.getdStart(), new Date(m.getBegin().getTime() - 86400000L), false));
                    pls.add(index + 1, new PlayList(m.getBegin(), m.getEnd(), false));
                    return null;
                }
                pls.add(index, new PlayList(beforePL.getdStart(), new Date(m.getBegin().getTime() - 86400000L), false));
                pls.add(index + 1, new PlayList(m.getBegin(), beforePL.getdEnd(), false));
                m.setBegin(new Date(beforePL.getdEnd().getTime() + 86400000L));
                return m;
            }
        }
        return m;
    }

    private static Movie addAfter(Movie m, ArrayList<PlayList> pls) {
        pls.add(pls.size(), new PlayList(m.getBegin(), m.getEnd(), false));
        return null;
    }

    public static void fillPlayLists(ArrayList<PlayList> pls, Movie[] movies, Logger log) {
        if (log != null) {
            log.info((Object)"\u0417\u0430\u043f\u043e\u043b\u043d\u044f\u044e \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442\u044b");
        }
        block0: for (Movie m : movies) {
            for (PlayList pl : pls) {
                if (pl.isDefaultPL() || pl.getdStart() == null && m.getBegin() != null || pl.getdStart() != null && m.getBegin() != null && m.getBegin().after(pl.getdStart())) continue;
                if (pl.getdEnd() == null && m.getEnd() != null || pl.getdEnd() != null && m.getEnd() != null && m.getEnd().before(pl.getdEnd())) continue block0;
                PlayListHelper.addTrackToPlayList(pl, new Track(m.getId(), m.getIdService(), ManagerPL.TRACKS_DIR + "/" + m.getUrl(), PlayListHelper.getFileType(m.getUrl()), m.getCrc(), 1, 30), m.getWeight());
            }
        }
        if (log != null) {
            log.info((Object)"\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
        }
    }

    private static void addTrackToPlayList(PlayList pl, Track t, int weight) {
        Random r = new Random(new Date().getTime());
        for (int i = 0; i < weight; ++i) {
            int index = (int)(r.nextFloat() * (float)pl.size());
            pl.addTrack(index, t);
        }
    }

    public static void setDefaultPL(PlayList defaultPL, ArrayList<PlayList> pls) {
        for (PlayList pl : pls) {
            if (!pl.isDefaultPL()) continue;
            pls.remove(pl);
        }
        pls.add(defaultPL);
    }

    public static PlayList getDefaultPL(ArrayList<PlayList> pls) {
        for (PlayList pl : pls) {
            if (!pl.isDefaultPL()) continue;
            return pl;
        }
        PlayList defPL = PlayListHelper.createDefaultPL();
        pls.add(defPL);
        return defPL;
    }

    public static PlayList createDefaultPL() {
        PlayList defPL = new PlayList(null, null, true);
        File file = new File(ManagerPL.TRACKS_DIR);
        boolean isEmpty = true;
        if (file.exists()) {
            for (File f : file.listFiles()) {
                if (f.isDirectory() || f.getName().equals("playlist")) continue;
                PlayListHelper.addTrackToPlayList(defPL, new Track(0, null, f.getAbsolutePath(), PlayListHelper.getFileType(f.getAbsolutePath()), 0L, 1, 7), 1);
                isEmpty = false;
            }
        }
        if (isEmpty) {
            PlayListHelper.addTrackToPlayList(defPL, new Track(0, null, ManagerPL.TRACKS_DIR + "/" + "default.mp4", "mp4", 0L, 1, 30), 1);
        }
        return defPL;
    }

    private static String getFileType(String url) {
        if (url == null) {
            throw new IllegalArgumentException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d \u043f\u0443\u0441\u0442\u043e\u0439 url");
        }
        String[] tmp = url.split("\\.");
        return tmp[tmp.length - 1];
    }

    public static PlayList selectCurrentPL(ArrayList<PlayList> pls) {
        if (pls == null) {
            return PlayListHelper.createDefaultPL();
        }
        for (PlayList pl : pls) {
            if (!PlayListHelper.isRelevantPL(pl)) continue;
            return pl;
        }
        return PlayListHelper.getDefaultPL(pls);
    }

    public static Track selectCurrentTrack(PlayList pl) {
        if (pl == null) {
            return null;
        }
        Track t = pl.getNextTrack();
        if (new File(t.getFilePath()).exists()) {
            return t;
        }
        if (PlayListHelper.isTracksAvailableOnDisk(pl)) {
            while (!new File((t = pl.getNextTrack()).getFilePath()).exists()) {
            }
            return t;
        }
        return null;
    }

    public static PlayList buildServicePL(int idService, PlayList source, Logger log) {
        if (log != null) {
            log.info((Object)("\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442. idService=" + idService));
        }
        PlayList pl = new PlayList(source.getdStart(), source.getdEnd(), false);
        for (Track track : source.getTracks()) {
            if (track.getIdService() == null || !track.getIdService().equals(idService)) continue;
            pl.addTrack(track);
        }
        if (pl.size() == 0) {
            if (log != null) {
                log.info((Object)"\u041d\u0435\u0442 \u0440\u043e\u043b\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
            }
            return null;
        }
        if (PlayListHelper.isRelevantPL(pl)) {
            if (log != null) {
                log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
            }
            return pl;
        }
        if (log != null) {
            log.info((Object)"\u0420\u043e\u043b\u0438\u043a\u0438 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430 \u0434\u0438\u0441\u043a\u0435");
        }
        return null;
    }

    public static boolean isRelevantPL(PlayList pl) {
        if (pl == null) {
            return false;
        }
        if (pl.isDefaultPL()) {
            return false;
        }
        Date nowB = new Date();
        nowB.setHours(0);
        nowB.setMinutes(0);
        nowB.setSeconds(-1);
        Date nowE = new Date();
        nowE.setHours(24);
        nowE.setMinutes(0);
        nowE.setSeconds(0);
        return pl.getdStart() != null && pl.getdStart().equals(pl.getdEnd()) ? pl.getdStart().after(nowB) && pl.getdStart().before(nowE) && PlayListHelper.isTracksAvailableOnDisk(pl) : (pl.getdStart() == null && pl.getdEnd() == null || pl.getdStart() == null && nowB.before(pl.getdEnd()) || pl.getdEnd() == null && nowE.after(pl.getdStart()) || pl.getdStart() != null && pl.getdEnd() != null && nowB.before(pl.getdEnd()) && nowE.after(pl.getdStart())) && PlayListHelper.isTracksAvailableOnDisk(pl);
    }

    public static boolean isTracksAvailableOnDisk(PlayList pl) {
        if (pl == null) {
            return false;
        }
        for (Track t : pl.getTracks()) {
            if (!new File(t.getFilePath()).exists()) continue;
            return true;
        }
        return false;
    }
}

