/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.utils.managerpl;

import java.util.ArrayList;
import java.util.Date;
import ru.softlogic.module.utils.managerpl.Track;

public class PlayList {
    private boolean defaultPL;
    private ArrayList<Track> tracks;
    private Date dStart;
    private Date dEnd;
    private int nextTrackId;

    public PlayList(Date dStart, Date dEnd, boolean defaultPL) {
        this.defaultPL = defaultPL;
        this.tracks = new ArrayList();
        this.dStart = dStart;
        this.dEnd = dEnd;
        this.nextTrackId = 0;
    }

    public boolean isDefaultPL() {
        return this.defaultPL;
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(ArrayList<Track> tracks) {
        this.tracks = tracks;
    }

    public Date getdStart() {
        return this.dStart;
    }

    public void setdStart(Date dStart) {
        this.dStart = dStart;
    }

    public Date getdEnd() {
        return this.dEnd;
    }

    public void setdEnd(Date dEnd) {
        this.dEnd = dEnd;
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
    }

    public void addTrack(int index, Track track) {
        this.tracks.add(index, track);
    }

    public int size() {
        return this.tracks.size();
    }

    public Track getNextTrack() {
        if (this.nextTrackId >= this.tracks.size()) {
            this.nextTrackId = 0;
        }
        return this.tracks.get(this.nextTrackId++);
    }

    public void removeTrack(Track track) {
        this.tracks.remove(track);
    }

    public void removeTrack(int index) {
        this.tracks.remove(index);
    }

    public void resetNextTrackId() {
        this.nextTrackId = 0;
    }

    public void decNextTrackId() {
        this.nextTrackId = this.nextTrackId > 0 ? --this.nextTrackId : this.tracks.size() - 1;
    }

    public String toString() {
        return "PlayList{tracks=" + this.tracks + ", dStart=" + this.dStart + ", dEnd=" + this.dEnd + ", nextTrackId=" + this.nextTrackId + '}';
    }

    public boolean equals(Object obj) {
        boolean isFind;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        PlayList pl = (PlayList)obj;
        if (this.tracks.size() != pl.getTracks().size()) {
            return false;
        }
        if (this.dStart != pl.dStart || this.dEnd != pl.dEnd) {
            return false;
        }
        for (Track t : this.getTracks()) {
            isFind = false;
            for (Track tt : pl.getTracks()) {
                if (!t.equals(tt)) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            return false;
        }
        for (Track t : pl.getTracks()) {
            isFind = false;
            for (Track tt : this.getTracks()) {
                if (!t.equals(tt)) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            return false;
        }
        return true;
    }
}

