/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.ups;

import java.io.IOException;
import org.networkupstools.jnut.Client;
import org.networkupstools.jnut.Device;
import org.networkupstools.jnut.NutException;
import org.networkupstools.jnut.Variable;

public class UpsMonitor {
    public static final int ND = -999;
    private final Client client;
    private Device[] deviceList;
    private String host = "localhost";
    private int port = 3493;
    private String login = "";
    private String pass = "";

    public UpsMonitor() {
        this.client = new Client();
    }

    public UpsMonitor(String host, int port) {
        this.host = host;
        this.port = port;
        this.client = new Client();
    }

    public UpsMonitor(String host, int port, String login, String pass) {
        this.host = host;
        this.port = port;
        this.login = login;
        this.pass = pass;
        this.client = new Client();
    }

    public boolean connect() {
        try {
            this.client.connect(this.host, this.port, this.login, this.pass);
            this.getDevices();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void getDevices() {
        try {
            this.deviceList = this.isConnected() ? this.client.getDeviceList() : null;
        }
        catch (IOException ex) {
            this.deviceList = null;
        }
        catch (NutException ex) {
            this.deviceList = null;
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public String getVariableValue(Device device, String variable) {
        if (!this.isConnected()) {
            return null;
        }
        this.getDevices();
        try {
            Device dev = this.client.getDevice(device.getName());
            if (dev == null) {
                return null;
            }
            Variable var = dev.getVariable(variable);
            return var.getValue();
        }
        catch (IOException ex) {
            return null;
        }
        catch (NutException ex) {
            return null;
        }
    }

    public boolean isOnBattery() {
        this.getDevices();
        if (this.deviceList != null) {
            return this.isOnBattery(this.deviceList[0]);
        }
        return false;
    }

    public boolean isOnLine() {
        this.getDevices();
        if (this.deviceList != null) {
            return this.isOnLine(this.deviceList[0]);
        }
        return false;
    }

    public int getBatteryCharge() {
        this.getDevices();
        if (this.deviceList != null) {
            return this.getBatteryCharge(this.deviceList[0]);
        }
        return -999;
    }

    public int getBatteryRuntime() {
        this.getDevices();
        if (this.deviceList != null) {
            return this.getBatteryRuntime(this.deviceList[0]);
        }
        return -999;
    }

    public String getBatteryInfo() {
        this.getDevices();
        if (this.deviceList != null) {
            return this.getBatteryInfo(this.deviceList[0]);
        }
        return null;
    }

    public boolean isOnBattery(Device device) {
        String answer = this.getVariableValue(device, "ups.status");
        if (answer != null) {
            return answer.contains("OB");
        }
        return false;
    }

    public boolean isOnLine(Device device) {
        String answer = this.getVariableValue(device, "ups.status");
        if (answer != null) {
            return answer.contains("OL");
        }
        return false;
    }

    public int getBatteryCharge(Device device) {
        int result = -999;
        String answer = this.getVariableValue(device, "battery.charge");
        if (answer != null) {
            try {
                result = Integer.parseInt(answer);
            }
            catch (NumberFormatException ex) {
                return -999;
            }
        }
        return result;
    }

    public int getBatteryRuntime(Device device) {
        int result = -999;
        String answer = this.getVariableValue(device, "battery.runtime");
        if (answer != null) {
            try {
                result = Integer.parseInt(answer);
            }
            catch (NumberFormatException ex) {
                return -999;
            }
        }
        return result;
    }

    public String getBatteryInfo(Device device) {
        String result = "Device name: " + device.getName() + "\n";
        result = result + "Vendor id:   " + this.getVariableValue(device, "ups.vendorid") + "\n";
        result = result + "Product id:  " + this.getVariableValue(device, "ups.productid") + "\n";
        result = result + "Driver: " + this.getVariableValue(device, "driver.name") + "\n";
        result = result + "Status: " + this.getVariableValue(device, "ups.status") + "\n";
        result = result + "Load:   " + this.getVariableValue(device, "ups.load") + "% \n";
        return result;
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public Device[] getDeviceList() {
        this.getDevices();
        return this.deviceList;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }
}

