/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.ups;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.networkupstools.jnut.Device;
import org.networkupstools.jnut.NutException;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.module.ups.UPSListener;
import ru.softlogic.module.ups.UpsMonitor;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.system.util.ThreadUtil;

public class UPSManager
implements Runnable {
    private static final String BATTERY_CHARGE = "battery.charge";
    private static final String DRIVER_NAME = "driver.name";
    private static final String DRIVER_PORT = "driver.parameter.port";
    private static final String UPS_LOAD = "ups.load";
    private static final String UPS_STATUS = "ups.status";
    private static final String UPS_TEMPERATURE = "ups.temperature";
    private static final String ON_LINE = "OL";
    private static final String ON_BATTERY = "OB";
    private static final String LOW_BATTERY = "LB";
    private static final int CHECK_INTERVAL = 3;
    private ApplicationContext context;
    private static UPSManager instance;
    private Set<UPSListener> listeners = new HashSet<UPSListener>();
    private Logger log;
    private boolean onBattery;

    private UPSManager() {
    }

    public static UPSManager getInstance() {
        if (instance == null) {
            instance = new UPSManager();
        }
        return instance;
    }

    public void addListener(UPSListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        block16: {
            this.log = Logger.getLogger((String)"ups");
            this.log.setAdditivity(false);
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u0418\u0411\u041f");
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0418\u0411\u041f");
            try {
                UpsMonitor um = new UpsMonitor();
                if (um.connect()) {
                    this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
                    this.log.info((Object)("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + um.getPort()));
                    Device[] devices = um.getDeviceList();
                    this.log.info((Object)"\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:");
                    for (Device d : devices) {
                        this.log.info((Object)this.getInfo(d));
                    }
                    while (!Thread.currentThread().isInterrupted()) {
                        boolean isOnBattery = true;
                        for (Object d : devices) {
                            String upsStatus = d.getVariable(UPS_STATUS).getValue();
                            if (!ON_LINE.equals(upsStatus)) continue;
                            isOnBattery = false;
                            break;
                        }
                        if (isOnBattery) {
                            if (!this.onBattery) {
                                this.log.info((Object)"\u0418\u0411\u041f \u043f\u0435\u0440\u0435\u0448\u0435\u043b \u043d\u0430 \u0440\u0430\u0431\u043e\u0442\u0443 \u043e\u0442 \u0430\u043a\u043a\u0443\u043c\u0443\u043b\u044f\u0442\u043e\u0440\u0430");
                                for (UPSListener l : this.listeners) {
                                    l.onBatteryMode();
                                }
                                this.onBattery = true;
                                if (this.context != null) {
                                    this.context.getServerConnector().sendEvent(new Event(EventType.Warning, "Terminal switched to battery operation"));
                                } else {
                                    this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440, context = null");
                                }
                            }
                            for (Object d : devices) {
                                this.log.info((Object)this.getInfo((Device)d));
                            }
                        } else if (this.onBattery) {
                            this.log.info((Object)"\u0418\u0411\u041f \u043f\u0435\u0440\u0435\u0448\u0435\u043b \u043d\u0430 \u0440\u0430\u0431\u043e\u0442\u0443 \u043e\u0442 \u0441\u0435\u0442\u0438");
                            for (UPSListener l : this.listeners) {
                                l.onLineMode();
                            }
                            this.onBattery = false;
                            for (Object d : devices) {
                                this.log.info((Object)this.getInfo((Device)d));
                            }
                        }
                        ThreadUtil.sleep((long)3000L);
                    }
                    um.disconnect();
                    this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u043d\u043e");
                    break block16;
                }
                this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
            }
            catch (Throwable ex) {
                this.log.error((Object)ex, ex);
            }
        }
        this.log.info((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430 \u0418\u0411\u041f");
    }

    private String getInfo(Device device) throws IOException, NutException {
        String res = "Device name = " + device.getName();
        res = res + "\n  Driver name     = " + device.getVariable(DRIVER_NAME).getValue();
        res = res + "\n  Driver port     = " + device.getVariable(DRIVER_PORT).getValue();
        res = res + "\n  Battery charge  = " + device.getVariable(BATTERY_CHARGE).getValue();
        res = res + "\n  UPS load        = " + device.getVariable(UPS_LOAD).getValue();
        res = res + "\n  UPS status      = " + device.getVariable(UPS_STATUS).getValue();
        res = res + "\n  UPS temperature = " + device.getVariable(UPS_TEMPERATURE).getValue();
        return res;
    }
}

