/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.utils.menu.MenuSearchProviderVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonDynamicScreen;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.parser.ParseException;

public class SearchProviderInputModule
extends BaseInputModule {
    private CommonDynamicScreen screen;
    private LocalScreenListener listener = new LocalScreenListener();

    public SearchProviderInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        try {
            Form f = FormHelper.parseUtility("srchprv", environment.getLocale());
            if (f.getScreenSequence().getScreens().size() != 1) {
                throw new ParseException("Wrong number of screens");
            }
            this.screen = (CommonDynamicScreen)CommonScreenStore.getScreen((String)"search-provider");
            this.screen.init(ScreenHelper.processBack((ScreenDescription)((ScreenDescription)f.getScreenSequence().getScreens().get(0)), (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
            this.screen.setListener((ScreenListener)this.listener);
            this.listener.onAction("Edit", Collections.singletonMap("input", ""), null);
            this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)this.screen));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
        catch (ParseException ex) {
            throw new DescriptionException(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if ("Edit".equals(action)) {
                String input = (String)data.get("input");
                if (input == null) {
                    input = "";
                }
                MenuSearchProviderVisitor mspv = new MenuSearchProviderVisitor(input, AppDefaults.getInstance().getStringValue("services.autosearch"), this.getBlockedSet(AppDefaults.getInstance().getStringValue("services.blocked")), AppDefaults.getInstance().getBooleanProperty("services.search.allow-hidden-groups", false));
                MenuUtils.processMenu((MenuVisitor)mspv);
                Map items = mspv.getItemsFull(AppDefaults.getInstance().getIntegerValue("services.maxsearch", -1).intValue());
                SearchProviderInputModule.this.screen.updateData(Collections.singletonMap("items", items));
            } else if (ActionType.isPrev((String)action)) {
                SearchProviderInputModule.this.back();
            } else {
                SearchProviderInputModule.this.cancel(null);
            }
        }

        public void onRedirect(int serviceId) {
            SearchProviderInputModule.this.log.info((Object)("Request to open service: " + serviceId));
            SearchProviderInputModule.this._redirect(serviceId);
        }

        private Set<Integer> getBlockedSet(String val) {
            HashSet<Integer> set = new HashSet<Integer>();
            if (val == null) {
                return set;
            }
            try {
                String[] split;
                for (String s : split = val.split(",")) {
                    if (!s.trim().matches("^\\d{1,5}$")) continue;
                    set.add(Integer.valueOf(s.trim()));
                }
            }
            catch (Exception e) {
                SearchProviderInputModule.this.log.error((Object)e, (Throwable)e);
            }
            return set;
        }
    }
}

