/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing.card;

import i18n.B;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdwbridge.sc.CardOperation;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.service.comission.SumResult;

public class SmartCardProcessingModule
extends ObsoleteProcessingModule {
    private CardReader crd;
    private Environment env;

    public SmartCardProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment env) {
        this.env = env;
        try {
            Pack pack = Session.getInstance().getPack();
            SumResult sumResult = pack.getSumResult();
            if (sumResult != null && sumResult.getOut() != null && sumResult.getOut().isEmpty() && !pack.isCancel() && pack.getPaymentType() == 0) {
                log.info((Object)"Run smartcard payment processing");
                this.crd = CardProcessorStore.getInstance().getCardReader();
                InputElement tid = (InputElement)((Payment)pack.getPayments().get(0)).getData().get("terminal-id");
                this.context.getTaskExecutor().execute(new ProcessTask(sumResult.getOut(), tid));
            } else {
                log.info((Object)"Run no smartcard payment processing");
                super._process(env);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            ProblemNotifier.notifyProblem((String)("Error in smartcard payment processing: " + e.getMessage()));
            ModuleHelper.cancelPack(Session.getInstance().getPack());
            super._process(env);
        }
    }

    private void realProcess(Environment env) {
        super._process(env);
    }

    private void cardReaderRelease() {
        try {
            this.crd.ejectCard();
            if (this.crd.isEnabled()) {
                this.crd.disableDevice();
            }
            this.crd.release();
        }
        catch (CardReaderException ex) {
            log.error((Object)("Card was not eject. Reason: " + ex.getMessage()));
        }
    }

    private class ProcessTask
    implements Task {
        private final Sum out;
        private final InputElement tid;

        private ProcessTask(Sum out, InputElement tid) {
            this.out = out;
            this.tid = tid;
        }

        @Override
        public Object execute() {
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                log.info((Object)"Process request");
                int sum = this.out.getBasicSum();
                if (this.tid != null) {
                    params.put("terminal-id", this.tid.getValue());
                }
                return CardProcessorStore.getInstance().getProcessor().process(SmartCardProcessingModule.this.crd, new CardOperation(sum, params));
            }
            catch (Exception ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            log.info((Object)("Processing result: " + object));
            if (object instanceof Data) {
                Data data = (Data)object;
                if (data.getElements() != null) {
                    for (InputElement ie : data.getElements()) {
                        Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                        payment.getData().put(ie.getKey(), ie);
                    }
                }
                SmartCardProcessingModule.this.realProcess(SmartCardProcessingModule.this.env);
            } else {
                if (object instanceof IllegalArgumentException) {
                    String m = MessageFormat.format(B.get((String)"Module.processing.smartcard.wrongcard", (Locale)SmartCardProcessingModule.this.env.getLocale()), ((IllegalArgumentException)object).getMessage());
                    DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Error, m, 10, DC.cases((int)8, (Locale)SmartCardProcessingModule.this.env.getLocale(), (Object[])new Object[]{new Object()}), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            SmartCardProcessingModule.this.context.getTaskExecutor().execute(new ProcessTask(Session.getInstance().getPack().getSumResult().getOut(), ProcessTask.this.tid));
                        }
                    });
                    SmartCardProcessingModule.this.context.showDialog((DialogInterface)dialog);
                    return;
                }
                ModuleHelper.cancelPack(Session.getInstance().getPack());
                SmartCardProcessingModule.this.realProcess(SmartCardProcessingModule.this.env);
            }
            SmartCardProcessingModule.this.cardReaderRelease();
        }

        @Override
        public String getMessage() {
            return B.get((String)("Request.process.wait." + Session.getInstance().getPack().getService().getId()), (Locale)SmartCardProcessingModule.this.env.getLocale(), (String)B.get((String)"Request.process.wait", (Locale)SmartCardProcessingModule.this.env.getLocale()));
        }
    }
}

