/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing.card;

import i18n.B;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.model.BankModuleError;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.BankModuleResultListener;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class BankCardProcessingModule
extends ObsoleteProcessingModule {
    private LocalGuiListener guiListener;
    private Environment env;

    public BankCardProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment env) {
        this.env = env;
        this.guiListener = new LocalGuiListener(this.context, env);
        PackUtility.printPack("BankCard pack", Session.getInstance().getPack());
        this.startBankOperation();
    }

    private void startBankOperation() {
        CardModuleStore cardModuleStore = CardModuleStore.getInstance();
        try {
            CashRequireListener cashRequireListener = cardModuleStore.getCashRequireListener();
            CashRequireListener bankCashRequireListener = cardModuleStore.getBankCashRequireListener();
            log.info((Object)("startBankOperation: cashRequireListener = " + cashRequireListener));
            log.info((Object)("startBankOperation: bankCashRequireListener = " + bankCashRequireListener));
            cardModuleStore.getEventsProxy().setListener(this.guiListener);
            Pack pack = Session.getInstance().getPack();
            if (!pack.isCancel() && pack.getPaymentType() == 0) {
                int out = pack.getSumResult().getOut().getBasicSum();
                int comm = pack.getSumResult().getCommission().getBasicSum();
                if (cashRequireListener != null) {
                    cardModuleStore.getDepositProxy().setListener(new LocalDepositResult(this.env));
                    FinanceOperation fo = new FinanceOperation((long)out, (long)comm);
                    log.info((Object)("Invoke CashRequireListener with " + fo));
                    cashRequireListener.onResult(fo);
                    cardModuleStore.setCashRequireListener(null);
                } else if (bankCashRequireListener != null) {
                    cardModuleStore.getBankDepositProxy().setListener(new LocalBankDepositResult(this.env));
                    FinanceOperation fo = new FinanceOperation((long)out, (long)comm);
                    log.info((Object)("Invoke BankCashRequireListener with " + fo));
                    bankCashRequireListener.onResult(fo);
                    cardModuleStore.setBankCashRequireListener(null);
                } else {
                    log.error((Object)"No result listeners. Cancel pack.");
                    ModuleHelper.cancelPack(Session.getInstance().getPack());
                    this.realProcess(this.env);
                }
            } else {
                log.info((Object)"No need to process payment in bank");
                this.realProcess(this.env);
                cardModuleStore.clearCashRequireListener();
                cardModuleStore.clearBankCashRequireListener();
                cardModuleStore.closeSessionSafe(true);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            ProblemNotifier.notifyProblem((String)("Error in BankCardProcessingModule: " + e.getMessage()));
            this.guiListener.setClosedListener(new Runnable(){

                @Override
                public void run() {
                    ModuleHelper.cancelPack(Session.getInstance().getPack());
                    BankCardProcessingModule.this.realProcess(BankCardProcessingModule.this.env);
                }
            });
            cardModuleStore.clearCashRequireListener();
            cardModuleStore.clearBankCashRequireListener();
            cardModuleStore.closeSessionSafe(true);
        }
    }

    private void realProcess(Environment env) {
        super._process(env);
    }

    private void fillCardInfo(Map<String, Object> data, OperationDepositResult t, CardInfo ci, Locale locale) {
        log.info((Object)("OperationDepositResult: " + t));
        if (t.getAuthIdentResponse() != null) {
            data.put("auth", new InputElement("auth", B.get((String)"Module.card.cardinfo.auth", (Locale)locale), t.getAuthIdentResponse()));
        }
        if (t.getRrn() != null) {
            data.put("rrn", new InputElement("rrn", B.get((String)"Module.card.cardinfo.rrn", (Locale)locale), t.getRrn()));
        }
        InputElement curr = new InputElement("curr", B.get((String)"Module.card.account.currency", (Locale)locale), B.get((String)("Module.card.currency.code." + t.getCurrency().getDigitCode()), (Locale)locale, (String)(t.getCurrency() == null ? "" : t.getCurrency().getDigitCode())));
        InputElement merchant = new InputElement("merchant", B.get((String)"Module.card.cardinfo.merchant", (Locale)locale), t.getMerchant());
        InputElement stan = new InputElement("stan", B.get((String)"Module.card.cardinfo.stan", (Locale)locale), t.getStan());
        InputElement terminal = new InputElement("terminal", B.get((String)"Module.card.cardinfo.terminal", (Locale)locale), t.getTerminal());
        data.put("curr", curr);
        data.put("merchant", merchant);
        data.put("stan", stan);
        data.put("terminal", terminal);
        if (t.getAcquireFee() != null) {
            data.put("acquireFee", new InputElement("acquireFee", B.get((String)"Module.card.deposit.fee.title", (Locale)locale), SumFormatter.format((long)t.getAcquireFee().getValue()) + " " + B.get((String)("Module.card.currency.code." + t.getAcquireFee().getCurrency()), (Locale)locale, (String)(t.getAcquireFee().getCurrency() == null ? "" : t.getAcquireFee().getCurrency().getDigitCode()))));
        }
        if (ci.getPan() != null) {
            InputElement id = (InputElement)data.get("id1");
            String title = B.get((String)"Module.card.pan", (Locale)locale, (String)"PAN");
            if (id != null && !title.equals(id.getKeyTitle())) {
                data.put("pan", new InputElement("pan", title, ci.getPan()));
            } else {
                data.put("id1", new InputElement("id1", title, ci.getPan()));
                if (ci.getAccountInfo() != null && ci.getAccountInfo().getNumber() != null) {
                    data.put("account", new InputElement("account", B.get((String)"Module.card.account", (Locale)locale), ci.getAccountInfo().getNumber()));
                }
            }
        }
        log.info((Object)("!hash-pan " + BU.toHexString((byte[])ci.getPanHash().getSha1())));
        InputElement ieHash = new InputElement("hash-pan", B.get((String)"Module.card.hash", (Locale)locale, (String)"hash-pan"), BU.toHexString((byte[])ci.getPanHash().getSha1()));
        data.put("hash-pan", ieHash);
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private Runnable closedListener;

        public LocalGuiListener(ApplicationContext context, Environment environment) {
            super(context, environment, log);
        }

        public void setClosedListener(Runnable closedListener) {
            this.closedListener = closedListener;
        }

        @Override
        public synchronized void _onClosed() {
            Runnable r = this.closedListener;
            if (r != null) {
                r.run();
                this.closedListener = null;
            }
        }

        @Override
        public void onCashRequire(boolean isEmitent, AccountInfo ai, CashRequireListener cl) {
            log.info((Object)"BankCardProcessingModule.LocalGuiListener.onCashRequire");
            BankCardProcessingModule.this.context.showWait(null);
            CardModuleStore.getInstance().setCashRequireListener(cl);
            BankCardProcessingModule.this.startBankOperation();
        }
    }

    private class LocalBankDepositResult
    implements BankModuleResultListener<OperationDepositResult> {
        private final Environment env;

        public LocalBankDepositResult(Environment env) {
            this.env = env;
        }

        public void onError(BankModuleError cme, String message) {
            String mess;
            log.info((Object)(">>>onError " + cme + ", " + message));
            UserAction.getInstance().update();
            BankCardProcessingModule.this.context.getServerConnector().sendEvent(new Event(EventType.Warning, "CardPaymentError(initiator=" + cme + ", " + message + ")"));
            if (cme == BankModuleError.ERROR_USER_CANCEL) {
                mess = B.get((String)"Provider.card.topup.error1", (Locale)this.env.getLocale());
            } else {
                BankCardProcessingModule.this.context.showWait(null);
                mess = message == null || message.isEmpty() ? B.get((String)"Provider.card.topup.error2", (Locale)this.env.getLocale()) : MessageFormat.format(B.get((String)"Provider.card.topup.error3", (Locale)this.env.getLocale()), message);
            }
            log.info((Object)"Ask about action");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, mess, 20, DC.cases((int)8, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    log.info((Object)("User make choise " + userCase));
                    BankCardProcessingModule.this.guiListener.setClosedListener(new Runnable(){

                        @Override
                        public void run() {
                            ModuleHelper.cancelPack(Session.getInstance().getPack());
                            BankCardProcessingModule.this.realProcess(LocalBankDepositResult.this.env);
                        }
                    });
                    CardModuleStore.getInstance().closeSessionSafe(false);
                    CardModuleStore.getInstance().reverse();
                }
            });
            dialog.show(BankCardProcessingModule.this.context.getShell());
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
            BankCardProcessingModule.this.fillCardInfo(data, t, ci, this.env.getLocale());
            log.info((Object)("LocalBankDepositResult.onResult.t = " + t));
            log.info((Object)("LocalBankDepositResult.onResult.ci = " + ci));
            BankCardProcessingModule.this.guiListener.setClosedListener(new Runnable(){

                @Override
                public void run() {
                    BankCardProcessingModule.this.realProcess(LocalBankDepositResult.this.env);
                }
            });
            CardModuleStore.getInstance().closeSessionSafe(true);
        }
    }

    private class LocalDepositResult
    implements CardModuleResultListener<OperationDepositResult> {
        private final Environment env;

        public LocalDepositResult(Environment env) {
            this.env = env;
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            String mess;
            log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            if (cardInfo != null) {
                Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
                this.fillLocalCardInfo(data, cardInfo, this.env.getLocale());
            }
            UserAction.getInstance().update();
            BankCardProcessingModule.this.context.getServerConnector().sendEvent(new Event(EventType.Warning, "CardPaymentError(initiator=" + cme + ", " + message + ")"));
            final CardModule cm = CardModuleStore.getInstance().getCurrentSession();
            if (cme == CardModuleError.ERROR_WRONG_PIN && cm != null) {
                log.info((Object)"Wrong pin, show dialog");
                BankCardProcessingModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.pin-wrong", (Locale)this.env.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        log.info((Object)"Wrong pin dialog closed. Start card operation");
                        cm.deposit((CardModuleResultListener)CardModuleStore.getInstance().getDepositProxy());
                        log.info((Object)"Done");
                    }
                });
                BankCardProcessingModule.this.context.showDialog((DialogInterface)dialog);
                return;
            }
            if (cme == CardModuleError.ERROR_USER_CANCEL) {
                mess = B.get((String)"Provider.card.topup.error1", (Locale)this.env.getLocale());
            } else {
                BankCardProcessingModule.this.context.showWait(null);
                mess = message == null || message.isEmpty() ? B.get((String)"Provider.card.topup.error2", (Locale)this.env.getLocale()) : MessageFormat.format(B.get((String)"Provider.card.topup.error3", (Locale)this.env.getLocale()), B.get((String)message, (Locale)this.env.getLocale(), (String)message));
            }
            log.info((Object)"Ask about action");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, mess, 20, DC.cases((int)8, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    log.info((Object)("User make choise " + userCase));
                    BankCardProcessingModule.this.guiListener.setClosedListener(new Runnable(){

                        @Override
                        public void run() {
                            ModuleHelper.cancelPack(Session.getInstance().getPack());
                            BankCardProcessingModule.this.realProcess(LocalDepositResult.this.env);
                        }
                    });
                    CardModuleStore.getInstance().closeSessionSafe(false);
                    CardModuleStore.getInstance().reverse();
                }
            });
            dialog.show(BankCardProcessingModule.this.context.getShell());
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
            BankCardProcessingModule.this.fillCardInfo(data, t, ci, this.env.getLocale());
            log.info((Object)("LocalDepositResult.onResult.t = " + t));
            log.info((Object)("LocalDepositResult.onResult.ci = " + ci));
            BankCardProcessingModule.this.guiListener.setClosedListener(new Runnable(){

                @Override
                public void run() {
                    BankCardProcessingModule.this.realProcess(LocalDepositResult.this.env);
                }
            });
            CardModuleStore.getInstance().closeSessionSafe(true);
        }

        public void onCardData(CardData cd) {
        }

        private void fillLocalCardInfo(Map<String, Object> data, CardInfo ci, Locale locale) {
            InputElement cashless = new InputElement("is-cashless", B.get((String)"Module.card.cashless", (Locale)locale, (String)"\u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u0430\u044f \u043e\u043f\u043b\u0430\u0442\u0430 "), "true");
            InputElement pan = new InputElement("account-client", B.get((String)"Module.card.pan", (Locale)locale, (String)"PAN"), ci.getPan());
            InputElement hash = new InputElement("hash-pan", B.get((String)"Module.card.hash", (Locale)locale, (String)"hash-pan"), BU.toHexString((byte[])ci.getPanHash().getSha1()));
            InputElement curr = new InputElement("curr", "", "810");
            String terminalId = ci.getTerminal().isEmpty() ? String.valueOf(this.env.getPoint().getId()) : ci.getTerminal();
            InputElement terminal = new InputElement("terminal", B.get((String)"Module.card.cardinfo.terminal", (Locale)locale), terminalId);
            data.put("is-cashless", cashless);
            data.put("account-client", pan);
            data.put("hash-pan", hash);
            data.put("terminal", terminal);
            data.put("curr", curr);
        }
    }
}

