/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.BaseProcessingModule;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.PinCodeGenerator;

public class VirtualProcessingModule
extends BaseProcessingModule {
    private Random random = new Random();
    protected Logger log = Logger.getLogger((String)"pay");
    private Environment environment;

    public VirtualProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment environment) {
        Object bannerId;
        this.environment = environment;
        if (environment.getInitData() != null && (bannerId = environment.getInitData().get("#bannerId")) != null && bannerId instanceof Integer) {
            AppEnvironment.getInstance().addAdvEvent(((Integer)bannerId).intValue(), AdvStatisticType.BannerShowAndPayment);
            environment.getInitData().remove("#bannerId");
        }
        Pack pack = Session.getInstance().getPack();
        pack.setUnknownProcessResult(false);
        if (pack.getPayments().size() == 1 || pack.getSumResult().getOut().isEmpty()) {
            InputElement ie2;
            this.log.info((Object)"Process single virtual pack operation");
            Payment payment = (Payment)pack.getPayments().get(0);
            int id = SequenceManager.getValueQuietly((String)"operation-id");
            payment.setId(id % 32000);
            payment.setDoc(this.random.nextInt(32000));
            payment.setDate(new Date());
            PackUtility.printPack("Processing pack", pack);
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(pack.getService());
            operation.setCommission(pack.getCommission());
            operation.setIdOperation(payment.getId());
            operation.setCheckNumber(payment.getDoc());
            operation.setDate(payment.getDate());
            operation.setDealer(environment.getDealer());
            operation.setPoint(environment.getPoint());
            operation.setPaymentSystem(environment.getPaymentSystem());
            operation.setServiceType(environment.getServiceType());
            operation.setPaymentTool(pack.getPaymentTool());
            operation.setCashlessData(pack.getCashlessData());
            operation.setPaybackType(pack.getPaybackType());
            operation.setChangeDispenseError(pack.isChangeDispenseError());
            SumResult sr = pack.getSumResult();
            operation.setSumResult(new SumResult(sr.getCash(), sr.getCashLess(), payment.getSumOut(), sr.getOutProv(), sr.getCommission(), sr.getChange(), sr.getProviderFee(), sr.getCommService()));
            operation.setLocale(environment.getLocale());
            operation.setKeeper(pack.getKeeper());
            for (InputElement ie2 : StoreHelper.clear((Map)payment.getData()).values()) {
                operation.getForm().put(ie2.getKey(), ie2.getValue());
                operation.getViews().put(ie2.getKey(), ie2.getValueTitle());
                operation.getTitles().put(ie2.getKey(), ie2.getKeyTitle());
                operation.getInputElements().put(ie2.getKey(), ie2);
            }
            int flags = 0;
            if (environment.isPrinterError()) {
                flags |= 1;
                if (pack.getService().getPaperRequire() == 4) {
                    flags |= 0x200;
                }
            }
            if (pack.getService().getPaperRequire() == 3) {
                flags |= 0x200;
            }
            if (pack.getService().isFiscalService()) {
                flags |= 0x20;
            }
            if (pack.getService().getProcessingType() == ProcessingType.Online || pack.getService().getProcessingType() == ProcessingType.HalfOnline) {
                flags |= 0x10;
            }
            if (pack.isFraud()) {
                flags |= 0x40;
            }
            if (pack.isFixedSum()) {
                flags |= 0x800;
            }
            if (pack.isPersonalComm()) {
                flags |= 0x4000;
            }
            if (payment.getData().get("sms-agree") instanceof InputElement && "1".equals((ie2 = (InputElement)payment.getData().get("sms-agree")).getValue())) {
                flags |= 0x80;
            }
            operation.setFlags(flags);
            if (ModuleHelper.isOnlineProcessing(pack) && !pack.isFraud() && (flags & 0x100) == 0) {
                this.log.info((Object)"Run online payment processing");
                if (pack.getCbc() == null && ModuleHelper.isPINPayoutOnly(pack) && !operation.getSumResult().getChange().isEmpty()) {
                    operation.setPinCode(PinCodeGenerator.generate());
                    operation.setPinCodeNominal(operation.getSumResult().getChange());
                }
                this.context.getTaskExecutor().execute(new ProcessTask(operation, environment.getLocale()));
            } else {
                this.log.info((Object)("Run offline processing: " + operation.getSumResult()));
                if (this.context.getFraudQueue() != null && (pack.getService().getProcessingType() == null || pack.getService().getProcessingType() == ProcessingType.Offline || operation.getSumResult().getOut().isEmpty())) {
                    this.processingFinished(this.context.getFraudQueue().putOperation(operation), operation);
                } else {
                    try {
                        this.processingFinished(this.context.getServerConnector().process(operation), operation);
                    }
                    catch (ConnectorException ex) {
                        this.log.error((Object)"Error on processing payment", (Throwable)ex);
                        this.processingFinished(null, operation);
                    }
                }
            }
        } else {
            Date date = new Date();
            for (Payment p : Session.getInstance().getPack().getPayments()) {
                p.setDate(date);
            }
            GroupOperation go = this.convert(Session.getInstance().getPack());
            go.setDealer(environment.getDealer());
            go.setLocale(environment.getLocale());
            go.setServiceType(environment.getServiceType());
            this.log.info((Object)("Multi operation pack " + go));
            if (this.context.getFraudQueue() != null && (pack.getService().getProcessingType() == null || pack.getService().getProcessingType() == ProcessingType.Offline || go.getSumResult().getOut().isEmpty())) {
                this.context.getFraudQueue().putGroupOperation(go);
            } else {
                this.context.getServerConnector().sendGroupOperation(go);
            }
            this.processingFinished(new ProcessingResult(ProcessingResultType.Ok), (Operation)go);
        }
    }

    private void processingFinished(ProcessingResult result, Operation operation) {
        this.log.info((Object)("Processing result: " + result));
        if (result == null || result.getType() == ProcessingResultType.Error) {
            if (result == null) {
                operation.setUnknownProcessResult(true);
            }
            this.log.info((Object)"Skip printing");
            this.environment.getEndingModule().end(this.environment);
        } else if (result.getType() == ProcessingResultType.Ok) {
            Session.getInstance().setPaymentAddedToQueue(true);
            this.environment.setPrintOperation(operation);
            this.environment.getPrintModule().print(this.environment);
        }
    }

    private GroupOperation convert(Pack pack) {
        int id = SequenceManager.getValueQuietly((String)"operation-id") % 32000;
        int doc = this.random.nextInt(32000);
        Date date = new Date();
        GroupOperation go = new GroupOperation();
        go.setFeHash(PaymentHelper.getFeHash());
        LinkedList<ChildOperation> opers = new LinkedList<ChildOperation>();
        boolean commInChild = false;
        boolean isFirst = true;
        for (Payment p : pack.getPayments()) {
            InputElement ie;
            Service service = new Service(pack.getService());
            if (p.getData().get("name") != null && p.getData().get("name") instanceof InputElement && (ie = (InputElement)p.getData().get("name")).getValueTitle() != null && !ie.getValueTitle().trim().isEmpty()) {
                service.setPrintName(ie.getValueTitle());
            }
            ChildOperation cho = null;
            if (!pack.isPrintByOne()) {
                if (isFirst) {
                    cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), Integer.valueOf(id), Integer.valueOf(doc));
                    isFirst = false;
                } else {
                    cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), Integer.valueOf(SequenceManager.getValueQuietly((String)"operation-id") % 32000), Integer.valueOf(this.random.nextInt(32000)));
                }
            } else {
                cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), null, null);
            }
            for (InputElement ie2 : StoreHelper.clear((Map)p.getData()).values()) {
                cho.getForm().put(ie2.getKey(), ie2.getValue());
                cho.getViews().put(ie2.getKey(), ie2.getValueTitle());
                cho.getTitles().put(ie2.getKey(), ie2.getKeyTitle());
                cho.getInputElements().put(ie2.getKey(), ie2);
            }
            opers.add(cho);
            if (p.getSum\u0421omm() == null || p.getSum\u0421omm().isEmpty()) continue;
            commInChild = true;
        }
        go.setChildOperations(opers);
        go.setService(pack.getService());
        go.setCommission(pack.getCommission());
        go.setIdOperation(id);
        go.setCheckNumber(doc);
        go.setSingleCheck(pack.isPrintByOne());
        go.setKeeper(pack.getKeeper());
        go.getForm().putAll(((ChildOperation)opers.get(0)).getForm());
        go.getViews().putAll(((ChildOperation)opers.get(0)).getViews());
        go.getTitles().putAll(((ChildOperation)opers.get(0)).getTitles());
        go.getInputElements().putAll(((ChildOperation)opers.get(0)).getInputElements());
        go.setDate(date);
        go.setChange(pack.getChange());
        go.setSumResult(pack.getSumResult());
        if (pack.getCbc() != null) {
            go.setPinCode(pack.getCbc().getPincode());
            go.setPinCodeNominal(pack.getCbc().getNominal());
        }
        if (commInChild) {
            go.getSumResult().setCommission(new Sum());
        }
        return go;
    }

    private class ProcessTask
    implements Task {
        private Operation operation;
        private Locale locale;
        private final int attempts = 5;
        private final int timeout = 5;

        public ProcessTask(Operation operation, Locale locale) {
            this.operation = operation;
            this.locale = locale;
        }

        @Override
        public Object execute() {
            try {
                long time = System.currentTimeMillis();
                if (this.operation.getService().getProcessingType() == ProcessingType.Online) {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            VirtualProcessingModule.this.log.info((Object)("Pre-process request. Attempt " + (i + 1)));
                            VirtualProcessingModule.this.context.getServerConnector().ping();
                            VirtualProcessingModule.this.log.info((Object)"Ping successed");
                            break;
                        }
                        catch (ConnectorException ex) {
                            if (i == 4 || System.currentTimeMillis() - time > 5L) {
                                return ex;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                    }
                }
                VirtualProcessingModule.this.log.info((Object)"Process request");
                return VirtualProcessingModule.this.context.getServerConnector().process(this.operation);
            }
            catch (ConnectorException ex) {
                VirtualProcessingModule.this.log.error((Object)ex, (Throwable)ex);
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            VirtualProcessingModule.this.log.info((Object)("Processing result: " + object));
            if (object instanceof ProcessingResult) {
                final ProcessingResult pr = (ProcessingResult)object;
                if (pr.getType() == ProcessingResultType.Ok) {
                    VirtualProcessingModule.this.processingFinished((ProcessingResult)object, this.operation);
                } else {
                    VirtualProcessingModule.this.log.info((Object)"Ask about action");
                    DialogScreen dialog = null;
                    if (pr.getErrorText() != null && !pr.getErrorText().trim().isEmpty()) {
                        dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Module.processing.virtual.online.error.action.text", (Locale)VirtualProcessingModule.this.environment.getLocale()), pr.getErrorText()), 20, DC.cases((int)17, (Locale)VirtualProcessingModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                    } else {
                        String mess = B.get((String)("Module.processing.virtual.online.error.action.srv" + this.operation.getService().getId()), (Locale)VirtualProcessingModule.this.environment.getLocale(), (String)B.get((String)"Module.processing.virtual.online.error.action", (Locale)VirtualProcessingModule.this.environment.getLocale()));
                        dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, mess, 20, DC.cases((int)17, (Locale)VirtualProcessingModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                    }
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            VirtualProcessingModule.this.log.info((Object)("User make choise " + userCase));
                            if (userCase == UserCase.Ok) {
                                VirtualProcessingModule.this.log.info((Object)"Go to input module");
                                VirtualProcessingModule.this.environment.getInputModule().restore();
                            } else {
                                ProcessTask.this.fullPayout(pr.getErrorText());
                            }
                        }
                    });
                    dialog.show(VirtualProcessingModule.this.context.getShell());
                }
            } else {
                VirtualProcessingModule.this.processingFinished(null, this.operation);
            }
        }

        private void fullPayout(String errorText) {
            VirtualProcessingModule.this.log.info((Object)"Make full payout");
            SumResult sr = Session.getInstance().getPack().getSumResult();
            Session.getInstance().getPack().setCancel(true);
            sr.setCommission(new Sum());
            sr.setOut(new Sum());
            sr.setOutProv(new Sum());
            sr.setChange(new Sum());
            ((Payment)Session.getInstance().getPack().getPayments().get(0)).setSumOut(new Sum());
            if (errorText != null) {
                ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put("online-error-text", new InputElement("online-error-text", "Error Text", errorText));
            }
            VirtualProcessingModule.this.environment.getReinitModule().process(VirtualProcessingModule.this.environment);
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.process.wait", (Locale)this.locale);
        }
    }
}

