/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.ChequeGenerator;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.BaseProcessingModule;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.CbcUtil;
import ru.softlogic.system.util.PinCodeGenerator;
import ru.softlogic.system.util.ThreadUtil;

public class ObsoleteProcessingModule
extends BaseProcessingModule {
    private static final Random random = new Random();
    protected static final Logger log = Logger.getLogger((String)"pay");
    protected Environment environment;

    public ObsoleteProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment environment) {
        Object bannerId;
        this.environment = environment;
        if (environment.getInitData() != null && (bannerId = environment.getInitData().get("#bannerId")) instanceof Integer) {
            AppEnvironment.getInstance().addAdvEvent(((Integer)bannerId).intValue(), AdvStatisticType.BannerShowAndPayment);
            environment.getInitData().remove("#bannerId");
        }
        try {
            if (CardModuleStore.getInstance().isInit()) {
                CardModuleStore cmStore = CardModuleStore.getInstance();
                cmStore.setCashRequireListener(null);
                cmStore.setBankCashRequireListener(null);
            }
        }
        catch (Throwable cmStore) {
            // empty catch block
        }
        Pack pack = Session.getInstance().getPack();
        pack.setUnknownProcessResult(false);
        if (pack.getPayments().size() == 1 || pack.getSumResult().getOut().isEmpty()) {
            InputElement ie;
            Object smsAgreeKeyObj;
            ProcessingType processingType;
            log.info((Object)"Process single pack operation");
            Payment payment = (Payment)pack.getPayments().get(0);
            int id = SequenceManager.getValueQuietly((String)"operation-id");
            payment.setId(id % 32000);
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (pack.getKeeper().getCashSum().isEmpty() && lp != null) {
                    payment.setDoc(lp.getCheckNumber());
                } else {
                    payment.setDoc(random.nextInt(32000));
                }
            } else {
                payment.setDoc(random.nextInt(32000));
            }
            payment.setDate(new Date());
            PackUtility.printPack("Processing pack", pack);
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(pack.getService());
            operation.setCommission(pack.getCommission());
            operation.setIdOperation(payment.getId());
            operation.setCheckNumber(payment.getDoc());
            operation.setDate(payment.getDate());
            operation.setDealer(environment.getDealer());
            operation.setPoint(environment.getPoint());
            operation.setPaymentSystem(environment.getPaymentSystem());
            operation.setServiceType(environment.getServiceType());
            operation.setPaymentTool(pack.getPaymentTool());
            operation.setCashlessData(pack.getCashlessData());
            operation.setPaybackType(pack.getPaybackType());
            operation.setChangeDispenseError(pack.isChangeDispenseError());
            operation.setFraudControlRule(pack.getFraudControlRule());
            if (pack.getCbc() != null) {
                operation.setPinCode(pack.getCbc().getPincode());
                operation.setPinCodeNominal(pack.getCbc().getNominal());
            }
            operation.setLocale(environment.getLocale());
            for (InputElement ie2 : StoreHelper.clear((Map)payment.getData()).values()) {
                operation.getForm().put(ie2.getKey(), ie2.getValue());
                operation.getViews().put(ie2.getKey(), ie2.getValueTitle());
                operation.getTitles().put(ie2.getKey(), ie2.getKeyTitle());
                operation.getInputElements().put(ie2.getKey(), ie2);
            }
            if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
                operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
            }
            if (pack.isZeroAmount()) {
                Sum s0 = new Sum();
                SumResult voidSumResult = new SumResult(s0, s0, s0, s0, s0, s0, null, null);
                operation.setSumResult(voidSumResult);
                operation.setKeeper(new Keeper());
                pack.setSumResult(voidSumResult);
            } else {
                SumResult sr = pack.getSumResult();
                SumResult sumResult = new SumResult(sr.getCash(), sr.getCashLess(), payment.getSumOut(), sr.getOutProv(), sr.getCommission(), sr.getChange(), sr.getProviderFee(), sr.getCommService());
                operation.setSumResult(sumResult);
                operation.setKeeper(pack.getKeeper());
            }
            int flags = 0;
            if (environment.isPrinterError()) {
                flags |= 1;
                if (pack.getService().getPaperRequire() == 4 || pack.getService().isFlagExist(524288L)) {
                    flags |= 0x200;
                }
            }
            if (pack.getService().getPaperRequire() == 3) {
                flags |= 0x200;
            }
            if (pack.getService().isFiscalService()) {
                flags |= 0x20;
            }
            if ((processingType = pack.getService().getProcessingType()) == ProcessingType.Online || processingType == ProcessingType.HalfOnline) {
                flags |= 0x10;
            }
            if (pack.isFraud()) {
                flags |= 0x40;
            }
            if (pack.isZeroAmount()) {
                flags |= 0x400;
            }
            if (pack.isFixedSum()) {
                flags |= 0x800;
            }
            if (pack.isUndrawnFundsSum()) {
                flags |= 0x1000;
            }
            if (pack.isPersonalComm()) {
                flags |= 0x4000;
            }
            if ((smsAgreeKeyObj = payment.getData().get("sms-agree")) instanceof InputElement && "1".equals((ie = (InputElement)smsAgreeKeyObj).getValue())) {
                flags |= 0x80;
            }
            if (operation.getSumResult().getCommService() != null) {
                flags |= 4;
            }
            operation.setChange(pack.getChange());
            SumResult sumRes = operation.getSumResult();
            if (sumRes.getOut().isEmpty() && pack.getPaybackType() == 5) {
                flags |= 0x100;
                log.info((Object)"Set payment to safe change service");
                operation.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), null, sumRes.getCommService()));
                operation.setCommission(new Commission(1));
                operation.setChange(new Keeper());
                pack.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), null, sumRes.getCommService()));
            }
            if (!operation.getKeeper().getVirtualSum().isEmpty() && Session.getInstance().getChangeDate() != null) {
                operation.setChangeDate(Session.getInstance().getChangeDate());
            }
            operation.setFlags(flags);
            if (ModuleHelper.isOnlineProcessing(pack) && !pack.isFraud() && (flags & 0x100) == 0) {
                if (pack.isUndrawnFundsSum()) {
                    try {
                        this.processingFinished(this.context.getServerConnector().process(operation), operation);
                    }
                    catch (ConnectorException ex) {
                        log.error((Object)"Error on processing payment", (Throwable)ex);
                        this.processingFinished(null, operation);
                    }
                } else {
                    log.info((Object)"Run online payment processing");
                    if (pack.getCbc() == null && ModuleHelper.isPINPayoutOnly(pack) && !operation.getSumResult().getChange().isEmpty()) {
                        operation.setPinCode(PinCodeGenerator.generate());
                        operation.setPinCodeNominal(operation.getSumResult().getChange());
                    }
                    Session.getInstance().setOnlinePaymentStart(true);
                    Session.getInstance().setLastPayment(operation);
                    Session.getInstance().flush();
                    this.context.getTaskExecutor().execute(new ProcessTask(operation, environment.getLocale()));
                }
            } else {
                log.info((Object)("Run offline processing: " + operation.getSumResult()));
                if (this.context.getFraudQueue() != null && (pack.getService().getProcessingType() == null || pack.getService().getProcessingType() == ProcessingType.Offline || operation.getSumResult().getOut().isEmpty() && !pack.isUndrawnFundsSum())) {
                    this.processingFinished(this.context.getFraudQueue().putOperation(operation), operation);
                } else {
                    try {
                        this.processingFinished(this.context.getServerConnector().process(operation), operation);
                    }
                    catch (ConnectorException ex) {
                        log.error((Object)"Error on processing payment", (Throwable)ex);
                        this.processingFinished(null, operation);
                    }
                }
            }
        } else {
            Date date = new Date();
            for (Payment p : Session.getInstance().getPack().getPayments()) {
                p.setDate(date);
            }
            GroupOperation go = this.convert(Session.getInstance().getPack());
            go.setDealer(environment.getDealer());
            go.setLocale(environment.getLocale());
            go.setServiceType(environment.getServiceType());
            go.setPaymentTool(pack.getPaymentTool());
            int flags = 0;
            if (pack.isUndrawnFundsSum()) {
                flags |= 0x1000;
            }
            go.setFlags(flags);
            log.info((Object)("Multi operation pack " + go));
            if (this.context.getFraudQueue() != null && (pack.getService().getProcessingType() == null || pack.getService().getProcessingType() == ProcessingType.Offline || go.getSumResult().getOut().isEmpty() && !pack.isUndrawnFundsSum())) {
                this.context.getFraudQueue().putGroupOperation(go);
            } else {
                this.context.getServerConnector().sendGroupOperation(go);
            }
            this.processingFinished(new ProcessingResult(ProcessingResultType.Ok), (Operation)go);
        }
    }

    protected void processingFinished(ProcessingResult result, Operation operation) {
        log.info((Object)("Processing result: " + result));
        Session.getInstance().setOnlinePaymentStart(false);
        Pack pack = Session.getInstance().getPack();
        if (result != null && result.getType() == ProcessingResultType.Ok) {
            Session.getInstance().setPaymentAddedToQueue(true);
            if (result.getDataItems() != null) {
                for (DataItem di : result.getDataItems()) {
                    String key = di.getKey();
                    String value = di.getValue();
                    operation.getForm().put(key, value);
                    operation.getViews().put(key, value);
                    if (operation.getTitles().get(key) == null) {
                        operation.getTitles().put(key, key);
                    }
                    operation.getInputElements().put(key, new InputElement(key, (String)operation.getTitles().get(key), value, value, 0));
                }
            }
            if (pack.getCbc() == null && ModuleHelper.isOnlineProcessing(pack) && ModuleHelper.isPINPayoutOnly(pack)) {
                if (pack.getSumResult() != null) {
                    pack.getSumResult().setChange(new Sum(0));
                }
                if (operation.getPinCode() != null) {
                    pack.setCbc(new CashBackCard(operation.getPinCode(), operation.getSumResult().getChange()));
                }
            }
        } else {
            if (result == null) {
                operation.setUnknownProcessResult(true);
                pack.setUnknownProcessResult(true);
            }
            log.info((Object)"Cancel operation");
            if (pack.getCbc() == null && ModuleHelper.isOnlineProcessing(pack) && ModuleHelper.isPINPayoutOnly(pack)) {
                CbcUtil.cancelOnlineOperationWithPIN(operation, pack);
            } else if (ModuleHelper.toSavePayout(pack)) {
                CbcUtil.cancelOperationToSave(operation);
            } else {
                CbcUtil.cancelOperation(operation);
            }
            log.error((Object)"Save it to queue");
            try {
                operation.setLastProcess(System.currentTimeMillis() - 240000L);
                this.context.getServerConnector().process(operation);
                Session.getInstance().setPaymentAddedToQueue(true);
            }
            catch (Exception ex) {
                log.error((Object)"Error on save payment", (Throwable)ex);
            }
        }
        this.environment.setPrintOperation(operation);
        if (pack.getPaymentType() != 1) {
            Keeper change = operation.getChange();
            if (pack.getPaybackType() == 1 || pack.getPaybackType() == 2) {
                change = null;
            }
            if (pack.getSumResult() == null || pack.getSumResult().getChange().isEmpty()) {
                change = null;
            }
            if (change != null && !change.getSum().isEmpty()) {
                Session.getInstance().setChangeDate(operation.getDate());
                Sum chs = change.getSum();
                if (operation.getPinCodeNominal() != null) {
                    chs = chs.sub(operation.getPinCodeNominal());
                }
                if (!chs.isEmpty()) {
                    Keeper k = new Keeper();
                    k.addPayback(chs);
                    Session.getInstance().setCurrentKeeper(k);
                    Session.getInstance().setPaymentAddedToQueue(false);
                    log.info((Object)"\u041f\u0440\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u0432 \u043a\u0438\u043f\u0435\u0440 \u0441\u0443\u043c\u043c\u0443 \u0441\u0434\u0430\u0447\u0438. \u0421\u043d\u0438\u043c\u0430\u044e \u0444\u043b\u0430\u0433 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
                } else {
                    Session.getInstance().setChangeDate(null);
                    Session.getInstance().setCurrentKeeper(null);
                }
            } else {
                Session.getInstance().setChangeDate(null);
                Session.getInstance().setCurrentKeeper(null);
            }
            Session.getInstance().setLastPayment(operation);
            Session.getInstance().setLastPack(pack);
        }
        this.endProcess();
    }

    protected void endProcess() {
        Pack pack = Session.getInstance().getPack();
        int paybackType = pack.getPaybackType();
        int paymentType = pack.getPaymentType();
        if (paymentType == 2 && (paybackType == 3 || paybackType == 6 || paybackType == 8)) {
            log.info((Object)"Skip printing");
            if (ModuleHelper.isOnlineProcessingIgnoreOutcome(pack)) {
                this.environment.getReinitModule().process(this.environment);
            } else {
                this.environment.getEndingModule().end(this.environment);
            }
        } else if (paymentType == 2 && paybackType == 2 && pack.getCbc() == null) {
            log.info((Object)"Skip printing");
            if (ModuleHelper.isOnlineProcessingIgnoreOutcome(pack)) {
                this.environment.getReinitModule().process(this.environment);
            } else {
                this.environment.getEndingModule().end(this.environment);
            }
        } else if (AppDefaults.getInstance().getBooleanProperty("processing.print.canceled", false) && pack.isCancel() && paybackType != 1 && pack.getCbc() == null) {
            log.info((Object)"Skip printing");
            if (ModuleHelper.isOnlineProcessingIgnoreOutcome(pack)) {
                this.environment.getReinitModule().process(this.environment);
            } else {
                this.environment.getEndingModule().end(this.environment);
            }
        } else {
            this.environment.getPrintModule().print(this.environment);
        }
    }

    private GroupOperation convert(Pack pack) {
        int id = SequenceManager.getValueQuietly((String)"operation-id") % 32000;
        int doc = random.nextInt(32000);
        Date date = new Date();
        GroupOperation go = new GroupOperation();
        go.setFeHash(PaymentHelper.getFeHash());
        LinkedList<ChildOperation> opers = new LinkedList<ChildOperation>();
        boolean commInChild = false;
        boolean isFirst = true;
        for (Payment p : pack.getPayments()) {
            ChildOperation cho;
            InputElement ie;
            Service service = new Service(pack.getService());
            Object name = p.getData().get("name");
            if (name instanceof InputElement && (ie = (InputElement)name).getValueTitle() != null && !ie.getValueTitle().trim().isEmpty()) {
                service.setPrintName(ie.getValueTitle());
            }
            if (!pack.isPrintByOne()) {
                if (isFirst) {
                    cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), Integer.valueOf(id), Integer.valueOf(doc));
                    isFirst = false;
                } else {
                    cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), Integer.valueOf(SequenceManager.getValueQuietly((String)"operation-id") % 32000), Integer.valueOf(random.nextInt(32000)));
                }
            } else {
                cho = new ChildOperation(service, p.getSumOut(), p.getSum\u0421omm(), null, null);
            }
            for (InputElement ie2 : StoreHelper.clear((Map)p.getData()).values()) {
                cho.getForm().put(ie2.getKey(), ie2.getValue());
                cho.getViews().put(ie2.getKey(), ie2.getValueTitle());
                cho.getTitles().put(ie2.getKey(), ie2.getKeyTitle());
                cho.getInputElements().put(ie2.getKey(), ie2);
            }
            opers.add(cho);
            if (p.getSum\u0421omm() == null || p.getSum\u0421omm().isEmpty()) continue;
            commInChild = true;
        }
        go.setChildOperations(opers);
        go.setService(pack.getService());
        go.setCommission(pack.getCommission());
        go.setIdOperation(id);
        go.setCheckNumber(doc);
        go.setSingleCheck(pack.isPrintByOne());
        go.setKeeper(pack.getKeeper());
        go.getForm().putAll(((ChildOperation)opers.get(0)).getForm());
        go.getViews().putAll(((ChildOperation)opers.get(0)).getViews());
        go.getTitles().putAll(((ChildOperation)opers.get(0)).getTitles());
        go.getInputElements().putAll(((ChildOperation)opers.get(0)).getInputElements());
        go.setDate(date);
        go.setChange(pack.getChange());
        go.setSumResult(pack.getSumResult());
        if (pack.getCbc() != null) {
            go.setPinCode(pack.getCbc().getPincode());
            go.setPinCodeNominal(pack.getCbc().getNominal());
        }
        if (commInChild) {
            go.getSumResult().setCommission(new Sum());
        }
        return go;
    }

    protected boolean onOnlineError(ProcessingResult pr) {
        return false;
    }

    private class ProcessTask
    implements Task {
        private static final int ATTEMPTS = 5;
        private static final int TIMEOUT = 5;
        private final Operation operation;
        private final Locale locale;

        public ProcessTask(Operation operation, Locale locale) {
            this.operation = operation;
            this.locale = locale;
        }

        @Override
        public Object execute() {
            try {
                long time = System.currentTimeMillis();
                if (this.operation.getService().getProcessingType() == ProcessingType.Online) {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            log.info((Object)("Pre-process request. Attempt " + (i + 1)));
                            ObsoleteProcessingModule.this.context.getServerConnector().ping();
                            log.info((Object)"Ping successed");
                            break;
                        }
                        catch (ConnectorException ex) {
                            if (i == 4 || System.currentTimeMillis() - time > 5L) {
                                return ex;
                            }
                            ThreadUtil.sleep((long)1000L);
                            continue;
                        }
                    }
                }
                log.info((Object)"Process request");
                return ObsoleteProcessingModule.this.context.getServerConnector().process(this.operation);
            }
            catch (ConnectorException ex) {
                log.error((Object)ex, (Throwable)ex);
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            log.info((Object)("Processing result: " + object));
            if (object instanceof ProcessingResult) {
                final ProcessingResult pr = (ProcessingResult)object;
                if (pr.getType() == ProcessingResultType.Ok) {
                    ObsoleteProcessingModule.this.processingFinished((ProcessingResult)object, this.operation);
                } else if (!ObsoleteProcessingModule.this.onOnlineError(pr)) {
                    log.info((Object)"Ask about action");
                    if (Session.getInstance().getPack().getCashlessData() != null) {
                        log.info((Object)"It's card payment, cant to back");
                        this.fullPayout(pr.getErrorText());
                    } else {
                        String errorText = pr.getErrorText();
                        String msg = errorText != null && !errorText.trim().isEmpty() ? MessageFormat.format(B.get((String)"Module.processing.online.error.action.text", (Locale)this.locale), errorText) : B.get((String)"Module.processing.online.error.action", (Locale)this.locale);
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, msg, 20, DC.cases((int)17, (Locale)ObsoleteProcessingModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                log.info((Object)("User make choise " + userCase));
                                if (userCase == UserCase.Ok) {
                                    log.info((Object)"Go to input module");
                                    ObsoleteProcessingModule.this.environment.getInputModule().restore();
                                } else {
                                    ProcessTask.this.fullPayout(pr.getErrorText());
                                }
                            }
                        });
                        dialog.show(ObsoleteProcessingModule.this.context.getShell());
                    }
                }
            } else {
                ObsoleteProcessingModule.this.processingFinished(null, this.operation);
            }
        }

        private void fullPayout(String errorText) {
            log.info((Object)"Make full payout");
            SumResult sr = Session.getInstance().getPack().getSumResult();
            Session.getInstance().getPack().setCancel(true);
            sr.setCommission(new Sum());
            sr.setOut(new Sum());
            sr.setOutProv(new Sum());
            sr.setChange(sr.getCash().add(sr.getCashLess()));
            sr.setCommService(null);
            Payment firstPayment = (Payment)Session.getInstance().getPack().getPayments().get(0);
            firstPayment.setSumOut(new Sum());
            if (errorText != null) {
                firstPayment.getData().put("online-error-text", new InputElement("online-error-text", "Error Text", errorText));
            }
            ObsoleteProcessingModule.this.environment.getPayoutModule().startPayout(ObsoleteProcessingModule.this.environment);
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.process.wait", (Locale)this.locale);
        }
    }
}

