/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.request.ConnectorException;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.service.comission.SumResult;

public class ExbankProcessingModule
extends ObsoleteProcessingModule {
    private Logger log = Logger.getLogger((String)"pay");

    public ExbankProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _process(Environment env) {
        PackUtility.printPack("ExpressBank pack", Session.getInstance().getPack());
        try {
            if (!Session.getInstance().getPack().isCancel() && Session.getInstance().getPack().getPaymentType() == 0) {
                this.context.getTaskExecutor().execute(new GetUserCases(env));
            } else {
                this.log.info((Object)"No need to process payment in bank");
                this.realProcess(env);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.cancelPack(Session.getInstance().getPack());
            ProblemNotifier.notifyProblem((String)("Error in ExbankProcessingModule: " + e.getMessage()));
            this.realProcess(env);
        }
    }

    private void cancelPack(Pack pack) {
        this.log.info((Object)"Cancel pack");
        SumResult sumResult = pack.getSumResult();
        sumResult.setChange(sumResult.getIncome());
        sumResult.setCommission(new Sum());
        sumResult.setOut(new Sum());
        sumResult.setOutProv(new Sum());
        PackUtility.cancelPackage(pack);
        pack.setSumResult(sumResult);
        pack.setPaybackType(3);
        pack.setCancel(true);
    }

    private void realProcess(Environment env) {
        super._process(env);
    }

    private void showError(Exception ex, String message, final Environment env) {
        if (ex == null) {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 advanced \u0437\u0430\u043f\u0440\u043e\u0441\u0435: " + message));
        } else {
            this.log.error((Object)("\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 advanced \u0437\u0430\u043f\u0440\u043e\u0441\u0435: " + message), (Throwable)ex);
        }
        this.log.info((Object)("Show dialog with message: " + message));
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                ExbankProcessingModule.this.cancelPack(Session.getInstance().getPack());
                ExbankProcessingModule.this.realProcess(env);
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private class GetUserCases
    implements Task {
        Environment env;

        public GetUserCases(Environment enviroment) {
            this.env = enviroment;
        }

        @Override
        public Object execute() {
            HashMap<String, InputElement> form = new HashMap<String, InputElement>();
            String out = String.valueOf(Session.getInstance().getPack().getSumResult().getOutProv().getSum());
            form.put("id1", StoreHelper.getElement((String)"contract-no", (Map)((Payment)Session.getInstance().getPack().getPayments().get(0)).getData()));
            form.put("sum", new InputElement("sum", "sum", out));
            RequestData rd = new RequestData();
            rd.setFunction("get-cred-option");
            rd.setIdService((short)Session.getInstance().getPack().getService().getId());
            rd.setParamsIe(form);
            if (Session.getInstance().getPack().getService().getProvider() != null) {
                rd.setIdProvider(Session.getInstance().getPack().getService().getProvider().getId());
            }
            ExbankProcessingModule.this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e advanced \u0437\u0430\u043f\u0440\u043e\u0441, \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: " + rd));
            try {
                return ExbankProcessingModule.this.context.getServerConnector().request(rd);
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            ExbankProcessingModule.this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442: " + object));
            if (object instanceof Exception) {
                ExbankProcessingModule.this.showError((Exception)object, B.get((String)"Module.processing.exbank.dialog.exception", (Locale)this.env.getLocale()), this.env);
            } else {
                Response resp = (Response)object;
                if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
                    String credOption = null;
                    if (resp.getData() != null && ((Data)resp.getData()).getElements() != null) {
                        List ie = ((Data)resp.getData()).getElements();
                        credOption = this.getValue("cred-option", ie);
                    }
                    if (credOption != null) {
                        ExbankProcessingModule.this.log.debug((Object)("cred-option value: " + credOption));
                        ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put("cred-option", new InputElement("cred-option", "cred-option", credOption, credOption, credOption, 0));
                        switch (Integer.parseInt(credOption)) {
                            case 1: {
                                ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put("cred-prep", new InputElement("cred-prep", "cred-prep", "0", "0", "0", 0));
                                ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put("use-acc", new InputElement("use-acc", "use-acc", "0", "0", "0", 0));
                                ExbankProcessingModule.this.realProcess(this.env);
                                return;
                            }
                            case 2: {
                                ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put("use-acc", new InputElement("use-acc", "use-acc", "0", "0", "0", 0));
                                DialogScreen dialog = this.createDialog(B.get((String)"Module.processing.exbank.dialog.message.credoption.2", (Locale)this.env.getLocale()), "cred-prep", null);
                                ExbankProcessingModule.this.context.showDialog((DialogInterface)dialog);
                                return;
                            }
                            case 3: {
                                DialogScreen dialog2 = this.createDialog(B.get((String)"Module.processing.exbank.dialog.message.credoption.3.2", (Locale)this.env.getLocale()), "use-acc", null);
                                DialogScreen dialog = this.createDialog(B.get((String)"Module.processing.exbank.dialog.message.credoption.3.1", (Locale)this.env.getLocale()), "cred-prep", dialog2);
                                ExbankProcessingModule.this.context.showDialog((DialogInterface)dialog);
                                return;
                            }
                            case 4: {
                                DialogScreen dialog2 = this.createDialog(B.get((String)"Module.processing.exbank.dialog.message.credoption.4.2", (Locale)this.env.getLocale()), "use-acc", null);
                                DialogScreen dialog = this.createDialog(B.get((String)"Module.processing.exbank.dialog.message.credoption.4.1", (Locale)this.env.getLocale()), "cred-prep", dialog2);
                                ExbankProcessingModule.this.context.showDialog((DialogInterface)dialog);
                                return;
                            }
                        }
                        ExbankProcessingModule.this.log.info((Object)"Wrong cred-option value");
                        ExbankProcessingModule.this.showError(null, B.get((String)"Module.processing.exbank.dialog.error.other", (Locale)this.env.getLocale()), this.env);
                    } else {
                        ExbankProcessingModule.this.log.debug((Object)"cred-option not find in response");
                        ExbankProcessingModule.this.showError(null, B.get((String)"Module.processing.exbank.dialog.error.other", (Locale)this.env.getLocale()), this.env);
                    }
                } else {
                    ExbankProcessingModule.this.showError(null, B.get((String)"Module.processing.exbank.dialog.error", (Locale)this.env.getLocale()), this.env);
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait", (Locale)this.env.getLocale());
        }

        private String getValue(String key, List<InputElement> inputElements) {
            for (InputElement ie : inputElements) {
                if (!ie.getKey().equals(key)) continue;
                return ie.getValue();
            }
            return null;
        }

        private DialogScreen createDialog(String message, final String option, final DialogScreen dialog2) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, message, 20, DC.cases((int)24), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    ExbankProcessingModule.this.log.info((Object)("User make choise " + userCase));
                    if (userCase == UserCase.Cancel) {
                        ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put(option, new InputElement(option, option, "1", "1", "1", 0));
                    } else {
                        ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put(option, new InputElement(option, option, "0", "0", "0", 0));
                    }
                    if (dialog2 != null) {
                        ExbankProcessingModule.this.context.showDialog((DialogInterface)dialog2);
                    } else {
                        ExbankProcessingModule.this.realProcess(GetUserCases.this.env);
                    }
                }
            });
            return dialog;
        }
    }
}

