/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.print;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.adv.AdvExtractor;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderFactory;
import ru.softlogic.hardware.device.print.render2.op.OperationRender;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.template.UtilityHelper;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.CheckAdv;
import ru.softlogic.reference.email.Auth;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class SendEmailModule {
    private ApplicationContext context;
    private DeviceType deviceType;
    private Operation operation;
    private Logger log;
    private static SendEmailModule instance;

    public static synchronized SendEmailModule getInstance() {
        if (instance == null) {
            instance = new SendEmailModule();
        }
        return instance;
    }

    public static boolean isNeedSendCheckToEmail(Operation printOperation, Service srv, PrinterStatus lastStatus) {
        if (srv.getPrintCheckDialog() == null) {
            return true;
        }
        if ((printOperation.getFlags() & 0x200) <= 0) {
            if (!srv.getPrintCheckDialog().booleanValue() && srv.getPaperRequire() == 1 && (lastStatus.isError() || lastStatus.isPaperEnd())) {
                return true;
            }
            if (srv.getPrintCheckDialog().booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public void openEmailInputScreen(Environment currentEnvironment, ApplicationContext ncontext, DeviceType dt, Operation noperation) {
        try {
            SendEmailModule.getInstance().context = ncontext;
            SendEmailModule.getInstance().deviceType = dt;
            SendEmailModule.getInstance().operation = noperation;
            UtilityHelper utilityHelper = new UtilityHelper("templates/email");
            Scenario s = utilityHelper.getScenario(currentEnvironment.getLocale());
            AdvancedScreenDescription asd = s.getScreenById("begin");
            ScreenDescription sd = asd.getDescription();
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            for (Action a : asd.getActionMap().getActions()) {
                buttons.put(a.getType(), new ButtonInit(a.getTitle()));
            }
            sd.setButtons(buttons);
            EmailInputScreenListener listener = new EmailInputScreenListener(this.context);
            listener.setEnvironment(currentEnvironment);
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            if (cs == null) {
                throw new InitException("Can't get screen type: " + sd.getType());
            }
            cs.setListener((ScreenListener)listener);
            cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)false), InitModuleHelper.buildScreenInit(currentEnvironment, null));
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (Exception ex) {
            Logger.getLogger((String)"print").error((Object)ex.getMessage());
        }
    }

    private class EmailInputScreenListener
    extends ComplexScreenListener {
        public EmailInputScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                String email = (String)data.get("email");
                this.sendCheck(email);
            }
        }

        private Properties getMailProperties(Auth auth) throws Exception {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(PathUtils.getAppHome() + "/resources/mail-server.properties");
                 StringReader strReader = auth != null ? new StringReader(auth.getEmailSettings()) : null;){
                if (auth == null || auth.getEmailSettings() == null || auth.getEmailSettings().trim().isEmpty()) {
                    props.load(fis);
                } else {
                    props.load(strReader);
                }
            }
            catch (Exception e) {
                SendEmailModule.this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendCheck(String email) {
            Auth auth = null;
            Point point = null;
            try {
                auth = ReferenceManager.getInstance().getAuth();
                point = ReferenceManager.getInstance().getPoint();
            }
            catch (ReferenceException ex) {
                SendEmailModule.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
            }
            RenderData data = new RenderData();
            CheckAdv adv = AdvExtractor.extractCheckAdv((int)SendEmailModule.this.operation.getService().getId());
            if (SendEmailModule.this.operation.getService() != null) {
                data.setAdvertisement(adv == null ? null : adv.getContent());
            }
            data.setRenderName(SendEmailModule.this.operation.getService().getCheckRender());
            OperationRender render = RenderFactory.createOperationRender((DeviceType)SendEmailModule.this.deviceType, (String)(data != null ? data.getRenderName() : null), (Locale)SendEmailModule.this.operation.getLocale());
            SendEmailModule.this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0440\u0435\u043d\u0434\u0435\u0440\u0438\u0442\u044c \u0447\u0435\u043a");
            String[] res = render.process(SendEmailModule.this.operation, data);
            if (res == null || res != null && res.length == 0) {
                SendEmailModule.this.log.info((Object)"\u0410\u0440\u0445\u0438\u0432 \u043f\u0443\u0441\u0442\u043e\u0439. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e");
                return;
            }
            PrintWriter pw = null;
            File htmlFile = new File(PathUtils.getAppHome() + File.separator + "templates" + File.separator + "check.html");
            if (!htmlFile.exists()) {
                try {
                    pw = new PrintWriter(htmlFile);
                    pw.write(res[0]);
                }
                catch (FileNotFoundException ex) {
                    SendEmailModule.this.log.error((Object)("initHTMLComponents.ex = " + ex.getMessage()));
                    SendEmailModule.this.log.error((Object)("initHTMLComponents.ex = " + Arrays.toString(ex.getStackTrace())));
                    return;
                }
                finally {
                    try {
                        if (pw != null) {
                            pw.close();
                        } else {
                            SendEmailModule.this.log.error((Object)"Can't open check.html. Print writer is null.");
                        }
                    }
                    catch (Exception ex) {
                        SendEmailModule.this.log.error((Object)("pw.close.ex = " + ex.getMessage()));
                        SendEmailModule.this.log.error((Object)("pw.close.ex = " + Arrays.toString(ex.getStackTrace())));
                    }
                }
            }
            SendEmailModule.this.log.info((Object)("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + htmlFile + ", \u0440\u0430\u0437\u043c\u0435\u0440=" + htmlFile.length() / 1024L + " Kb"));
            SendEmailModule.this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
            try {
                Properties props = this.getMailProperties(auth);
                Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
                MimeMessage message = new MimeMessage(session);
                String mailFrom = props.getProperty("mail.from");
                if (auth == null) {
                    throw new Exception("Empty mail authentication options");
                }
                message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
                message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
                message.setSubject("\u0427\u0435\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0430", "utf-8");
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(htmlFile);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName("logs_" + point.getId() + ".zip");
                multipart.addBodyPart((BodyPart)messageBodyPart);
                message.setContent((Multipart)multipart);
                for (int i = 0; i < 5; ++i) {
                    SendEmailModule.this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                    try {
                        Transport.send((Message)message);
                        SendEmailModule.this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                        break;
                    }
                    catch (MessagingException ex) {
                        SendEmailModule.this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                        ThreadUtil.sleep((long)20000L);
                        if (i != 4) continue;
                        throw new Exception("Failed to send mail");
                    }
                }
            }
            catch (Exception ex) {
                SendEmailModule.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            }
        }
    }

    private class MailAuthenticator
    extends Authenticator {
        private Auth auth;

        public MailAuthenticator(Auth auth) {
            this.auth = auth;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.auth.getUser(), this.auth.getPassword());
        }
    }
}

