/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.print;

import i18n.B;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.input.model.field.text.RegexValidator;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.mobile.MobileFilter;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;

public class PrintHelper {
    private PrintHelper() {
    }

    public static GroupOperation prepareGO(GroupOperation go) {
        Sum commTotal = new Sum();
        for (ChildOperation co : go.getChildOperations()) {
            if (co.getCommission() == null) continue;
            commTotal = commTotal.add(co.getCommission());
        }
        if (!commTotal.isEmpty()) {
            GroupOperation res = new GroupOperation((Operation)go);
            res.setChildOperations(go.getChildOperations());
            res.getSumResult().setCommission(commTotal);
            return res;
        }
        return go;
    }

    public static List<Operation> convertGroupToSingleList(GroupOperation go) {
        LinkedList<Operation> ops = new LinkedList<Operation>();
        boolean isFirst = true;
        Sum cashSum = go.getKeeper().getCashSum();
        Sum commTotal = new Sum();
        for (ChildOperation co : go.getChildOperations()) {
            if (co.getCommission() == null) continue;
            commTotal = commTotal.add(co.getCommission());
        }
        Sum commAdd = new Sum();
        if (go.getSumResult().getCommission().compareTo(commTotal) > 0) {
            commAdd = go.getSumResult().getCommission().sub(commTotal);
        }
        for (ChildOperation co : go.getChildOperations()) {
            Sum change;
            Operation op = new Operation();
            op.setFeHash(go.getFeHash());
            op.setService(go.getService());
            op.setCommission(go.getCommission());
            op.setIdOperation(co.getIdOperation() == null ? 0 : co.getIdOperation());
            op.setCheckNumber(co.getCheckNumber() == null ? 0 : co.getCheckNumber());
            op.getForm().putAll(co.getForm());
            op.getViews().putAll(co.getViews());
            op.getTitles().putAll(co.getTitles());
            op.getInputElements().putAll(co.getInputElements());
            ModuleHelper.clearNotPrinted(op.getInputElements(), op.getForm(), op.getViews(), op.getTitles());
            op.setDate(go.getDate());
            op.setChange(go.getChange());
            Sum comm = co.getCommission() == null ? new Sum() : co.getCommission();
            Sum commServ = null;
            if (isFirst) {
                op.setPinCode(go.getPinCode());
                op.setPinCodeNominal(go.getPinCodeNominal());
                change = go.getSumResult().getChange();
                comm = comm.add(commAdd);
                go.getSumResult().getCommService();
                isFirst = false;
            } else {
                change = new Sum();
            }
            Sum in = co.getSumOutcome().add(comm).add(change);
            Sum cash = in.compareTo(cashSum) <= 0 ? new Sum(in) : new Sum(cashSum);
            cashSum = cashSum.sub(cash);
            Sum cashless = in.sub(cash);
            Keeper keeper = new Keeper();
            keeper.addCashBackCard(new CashBackCard(0, in));
            op.setKeeper(keeper);
            op.setSumResult(new SumResult(cash, cashless, co.getSumOutcome(), co.getSumOutcome(), comm, change, go.getSumResult().getProviderFee(), commServ));
            ops.add(op);
        }
        return ops;
    }

    public static Operation copyOperation(Operation printOperation) {
        if (printOperation instanceof GroupOperation) {
            GroupOperation go = new GroupOperation(printOperation);
            ModuleHelper.clearNotPrinted(go.getInputElements(), go.getForm(), go.getViews(), go.getTitles());
            if (go.getChildOperations() != null) {
                for (ChildOperation co : go.getChildOperations()) {
                    ModuleHelper.clearNotPrinted(co.getInputElements(), co.getForm(), co.getViews(), co.getTitles());
                }
            }
            return go;
        }
        if (printOperation != null) {
            Operation op = new Operation(printOperation);
            ModuleHelper.clearNotPrinted(op.getInputElements(), op.getForm(), op.getViews(), op.getTitles());
            return op;
        }
        return null;
    }

    public static ScreenDescription createSmsSD(Locale locale) {
        Keyboard kbr = new Keyboard(KeyboardType.Digital);
        TextField tf = new TextField();
        tf.setId("echeckaddress");
        tf.setTitle(B.get((String)"Provider.mobile.phone.number", (Locale)locale));
        tf.setMaxLength(10);
        tf.setKeyboard(kbr);
        tf.setExampleValue(AppDefaults.getInstance().getStringValue("Provider.mobile.input.field.example", "8( ) - -"));
        if ("ru".equals(AppDefaults.getInstance().getStringValue("Provider.mobile.input.filter.country", "ru"))) {
            tf.setFilter((Filter)new MobileFilter());
        } else {
            tf.setFilter((Filter)new VoidFilter());
        }
        tf.setHelp(B.get((String)"Provider.mobile.phone.help", (Locale)locale));
        RegexFormatter formatter = new RegexFormatter();
        formatter.setDefaultMask(AppDefaults.getInstance().getStringValue("Provider.mobile.input.mask", "8(***)***-****"));
        formatter.setPadding(Character.valueOf(' '));
        HashMap fm = new HashMap();
        formatter.setMasks(fm);
        tf.setFormatter((Formatter)formatter);
        LinkedList<String> vr = new LinkedList<String>();
        RegexValidator validator = new RegexValidator(vr, null);
        vr.add("^\\d{10}");
        tf.setValidator((Validator)validator);
        FieldSequence fs = new FieldSequence();
        fs.setFields(Arrays.asList(tf));
        ScreenDescription sd = new ScreenDescription();
        sd.setType("digital");
        sd.setTitle(B.get((String)"Provider.mobile.phone.screen.title", (Locale)locale));
        sd.setSequence(fs);
        sd.setId("input");
        sd.setButtons(PrintHelper.createButtons(locale));
        return sd;
    }

    public static ScreenDescription createMailSD(Locale locale) {
        Keyboard keyboard = new Keyboard(KeyboardType.Any, Arrays.asList("en", "symb"), KeyboardCase.Lower, true, null);
        RegexValidator validator = new RegexValidator(Arrays.asList(AppDefaults.getInstance().getStringValue("Print.email.input.field.reg", "^(\\S+@\\S+?\\.[a-zA-Z]{2,6})$")), null);
        TextField lf = new TextField();
        lf.setId("echeckaddress");
        lf.setKeyboard(keyboard);
        lf.setMaxLength(80);
        lf.setValidator((Validator)validator);
        lf.setTitle(B.get((String)"Module.print.additional.check.mail.field.title", (Locale)locale));
        FieldSequence fs = new FieldSequence(Arrays.asList(lf));
        UniScreenDescription sd = new UniScreenDescription("letter");
        sd.setSequence(fs);
        sd.setTitle(B.get((String)"Module.print.additional.check.mail.title", (Locale)locale));
        sd.setButtons(PrintHelper.createButtons(locale));
        return sd;
    }

    private static Map<String, ButtonInit> createButtons(Locale locale) {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Prev", new ButtonInit(B.get((String)"Action.cancel", (Locale)locale)));
        buttons.put("Next", new ButtonInit(B.get((String)"Action.next", (Locale)locale)));
        return buttons;
    }
}

