/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.print;

import i18n.B;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.print.BasePrintModule;
import ru.softlogic.module.print.PrintHelper;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.VariantDoc;
import ru.softlogic.reference.service.Service;

public class ObsoletePrintModule
extends BasePrintModule {
    protected final Logger log = LoggerId.PAY;
    protected final boolean noPrintGiftPayment;
    private final UserCase defaultUserCase;
    private CommonScreen smsScreen;
    private CommonScreen mailScreen;
    private LocalScreenListener smsListener;
    private LocalScreenListener mailListener;
    private Operation prinOperation;
    protected Environment environment;

    public ObsoletePrintModule(ApplicationContext context) {
        super(context);
        AppDefaults appDefaults = AppDefaults.getInstance();
        this.defaultUserCase = appDefaults.getStringValue("Module.print.dialog.default", "ok").equalsIgnoreCase("cancel") ? UserCase.Cancel : UserCase.Ok;
        this.noPrintGiftPayment = appDefaults.getBooleanProperty("Module.present.gift-payment.no-print", false);
        this.smsListener = new LocalScreenListener();
        this.mailListener = new LocalScreenListener();
        try {
            this.smsScreen = CommonScreenStore.getScreen((String)"digital");
            this.mailScreen = CommonScreenStore.getScreen((String)"letter");
        }
        catch (Exception ex) {
            this.log.warn((Object)("Print module screen create exception -> " + ex.getMessage()));
        }
    }

    @Override
    protected void _print(Environment environment) {
        this.environment = environment;
        Pack pack = Session.getInstance().getPack();
        Operation printOperation = environment.getPrintOperation();
        Service srv = pack.getService();
        boolean isPaperEnd = false;
        PrinterStatus lastStatus = this.context.getPrinterQueue().getLastStatus();
        if (lastStatus != null && lastStatus.isPaperEnd()) {
            isPaperEnd = true;
        }
        if (AppDefaults.getInstance().getBooleanProperty("Module.print.skip-void", false) && isPaperEnd && printOperation != null && printOperation.getSumResult() != null && (printOperation.getSumResult().getOut() == null || printOperation.getSumResult().getOut().isEmpty())) {
            this.prePrint(false);
        } else if (srv.getPrintCheckDialog() == null) {
            if (pack.getCbc() == null && (printOperation == null || printOperation.getPinCodeNominal() == null)) {
                this.prePrint(false);
            } else {
                this.log.info((Object)"Print without ask");
                this.prePrint(true);
            }
        } else if (printOperation != null && (printOperation.getFlags() & 0x200) > 0) {
            this.prePrint(false);
        } else if (this.noPrintGiftPayment && Session.getInstance().getPack().getPaymentType() == 1) {
            this.log.info((Object)"Gift payment print disabled");
            this.prePrint(false);
        } else if (pack.isCancel() && pack.getPaybackType() == 3) {
            this.prePrint(false);
        } else if (srv.getPrintCheckDialog().booleanValue() && pack.getCbc() == null && (printOperation == null || printOperation.getPinCodeNominal() == null) && pack.getPaymentType() == 0 && !isPaperEnd) {
            this.log.info((Object)("Ask about printing, default case: " + this.defaultUserCase));
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.print.confirm", (Locale)environment.getLocale()), 20, DC.cases((int)13, (Locale)environment.getLocale(), (Object[])new Object[0]), this.defaultUserCase);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    ObsoletePrintModule.this.log.info((Object)("User make choise " + userCase));
                    ObsoletePrintModule.this.prePrint(UserCase.Ok == userCase);
                }
            });
            dialog.show(this.context.getShell());
        } else {
            this.log.info((Object)"Print invoice without ask");
            this.prePrint(true);
        }
    }

    protected void prePrint(boolean canPrint) {
        this.prinOperation = null;
        if (canPrint) {
            this.prinOperation = PrintHelper.copyOperation(this.environment.getPrintOperation());
            VariantDoc receipttype = VariantDoc.NotUse;
            try {
                if (ReferenceManager.getInstance().getPoint().getVariantFiscalDoc() != null) {
                    receipttype = ReferenceManager.getInstance().getPoint().getVariantFiscalDoc();
                }
            }
            catch (ReferenceException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            final VariantDoc printType = receipttype;
            boolean isPaperEnd = false;
            PrinterStatus lastStatus = this.context.getPrinterQueue().getLastStatus();
            if (lastStatus != null && lastStatus.isPaperEnd()) {
                isPaperEnd = true;
            }
            if (PrinterType.KkmOnline.equals((Object)this.context.getPrinterQueue().getPrinterType()) && this.smsScreen != null && this.mailScreen != null && VariantDoc.NotUse != printType) {
                if (isPaperEnd) {
                    this.log.info((Object)("Paper is end, ask about send e-check, default case: " + UserCase.Cancel));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.print.additional.check.paperend", (Locale)this.environment.getLocale()), 20, DC.cases((int)24, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            ObsoletePrintModule.this.log.info((Object)("User make choise " + userCase));
                            if (UserCase.Ok.equals((Object)userCase)) {
                                ObsoletePrintModule.this.selectCheckType(printType);
                            } else {
                                ObsoletePrintModule.this._print();
                            }
                        }
                    });
                    dialog.show(this.context.getShell());
                } else if (VariantDoc.EmailOrSMS == printType) {
                    this.log.info((Object)("Ask about send additional check, default case: " + UserCase.Cancel));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.print.additional.check", (Locale)this.environment.getLocale()), 20, DC.cases((int)24, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            ObsoletePrintModule.this.log.info((Object)("User make choise " + userCase));
                            if (UserCase.Ok.equals((Object)userCase)) {
                                ObsoletePrintModule.this.selectCheckType(printType);
                            } else {
                                ObsoletePrintModule.this._print();
                            }
                        }
                    });
                    dialog.show(this.context.getShell());
                } else {
                    this.selectCheckType(printType);
                }
            } else {
                this._print();
            }
        } else {
            this._print();
        }
    }

    private void selectCheckType(final VariantDoc printType) {
        this.log.info((Object)("Ask about e-check type, default case: " + UserCase.Timeout));
        DisplayedUserCase[] userCases = DC.cases((int)35, (Locale)this.environment.getLocale(), (Object[])new Object[0]);
        String message = B.get((String)"Module.print.additional.check.type", (Locale)this.environment.getLocale());
        if (VariantDoc.SMS == printType) {
            userCases = DC.cases((int)24, (Locale)this.environment.getLocale(), (Object[])new Object[0]);
            message = B.get((String)"Module.print.additional.check.type.sms", (Locale)this.environment.getLocale());
        } else if (VariantDoc.Email == printType) {
            userCases = DC.cases((int)24, (Locale)this.environment.getLocale(), (Object[])new Object[0]);
            message = B.get((String)"Module.print.additional.check.type.email", (Locale)this.environment.getLocale());
        }
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, message, 20, userCases, UserCase.Timeout);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                ObsoletePrintModule.this.log.info((Object)("printType: " + printType));
                if (VariantDoc.EmailOrSMS == printType) {
                    ObsoletePrintModule.this.log.info((Object)("User make choise " + (UserCase.Ok.equals((Object)userCase) ? "sms" : "mail")));
                    if (UserCase.Ok.equals((Object)userCase)) {
                        ObsoletePrintModule.this.smsScreen.setListener((ScreenListener)ObsoletePrintModule.this.smsListener);
                        ObsoletePrintModule.this.showScreen(ObsoletePrintModule.this.smsScreen, PrintHelper.createSmsSD(ObsoletePrintModule.this.environment.getLocale()));
                    } else if (UserCase.Cancel.equals((Object)userCase)) {
                        ObsoletePrintModule.this.mailScreen.setListener((ScreenListener)ObsoletePrintModule.this.mailListener);
                        ObsoletePrintModule.this.showScreen(ObsoletePrintModule.this.mailScreen, PrintHelper.createMailSD(ObsoletePrintModule.this.environment.getLocale()));
                    } else {
                        ObsoletePrintModule.this._print();
                    }
                } else if (VariantDoc.SMS == printType && UserCase.Ok.equals((Object)userCase)) {
                    ObsoletePrintModule.this.smsScreen.setListener((ScreenListener)ObsoletePrintModule.this.smsListener);
                    ObsoletePrintModule.this.showScreen(ObsoletePrintModule.this.smsScreen, PrintHelper.createSmsSD(ObsoletePrintModule.this.environment.getLocale()));
                } else if (VariantDoc.Email == printType && UserCase.Ok.equals((Object)userCase)) {
                    ObsoletePrintModule.this.mailScreen.setListener((ScreenListener)ObsoletePrintModule.this.mailListener);
                    ObsoletePrintModule.this.showScreen(ObsoletePrintModule.this.mailScreen, PrintHelper.createMailSD(ObsoletePrintModule.this.environment.getLocale()));
                } else {
                    ObsoletePrintModule.this._print();
                }
            }
        });
        dialog.show(this.context.getShell());
    }

    private void showScreen(CommonScreen screen, ScreenDescription sd) {
        this.log.info((Object)("------ Show screen: " + sd.getType()));
        try {
            screen.init(sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
            this.context.showScreen(new ContentScreenAdapterKbr(screen));
        }
        catch (InitException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this._print();
        }
    }

    private void _print() {
        if (this.prinOperation != null) {
            this.log.info((Object)("Print operation: " + this.prinOperation + ", " + this.prinOperation.getSumResult()));
            if (this.prinOperation instanceof GroupOperation) {
                if (!Session.getInstance().getPack().isPrintByOne()) {
                    List<Operation> ops = PrintHelper.convertGroupToSingleList((GroupOperation)this.prinOperation);
                    for (Operation op : ops) {
                        this.context.getPrinterQueue().print(op);
                    }
                } else {
                    this.context.getPrinterQueue().printGroup(PrintHelper.prepareGO((GroupOperation)this.prinOperation));
                }
            } else {
                this.context.getPrinterQueue().print(this.prinOperation);
            }
        } else {
            this.log.info((Object)"Skip printing");
        }
        this.endPrint();
    }

    protected void endPrint() {
        this.environment.getEndingModule().end(this.environment);
    }

    @Override
    public void cancel(Intent intent) {
        this._print();
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                InputElement ie = (InputElement)data.get("echeckaddress");
                ObsoletePrintModule.this.log.info((Object)ie);
                if (ie.getOriginalValue() != null && !ie.getOriginalValue().isEmpty()) {
                    ObsoletePrintModule.this.prinOperation.seteCheckAddress(ie.getOriginalValue());
                }
            }
            ObsoletePrintModule.this._print();
        }
    }
}

