/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.print;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.TimeoutManager;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.print.ObsoletePrintModule;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.service.Service;

public class BanneredPrintModule
extends ObsoletePrintModule {
    private static final String SCREEN_TYPE = "print";
    private LocalScreenListener listener = new LocalScreenListener();
    private CommonScreen screen;
    private boolean isFirstShow = true;

    public BanneredPrintModule(ApplicationContext context) {
        super(context);
        try {
            this.screen = CommonScreenStore.getScreen((String)SCREEN_TYPE);
        }
        catch (Exception ex) {
            this.log.error((Object)("Print module screen create exception -> " + ex.getMessage()));
        }
    }

    @Override
    public int getInactivityTimeout() {
        return TimeoutManager.getInstance().getTimeout(this.getType());
    }

    public ScreenDescription createSD() {
        ScreenDescription sd = new ScreenDescription();
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Search", new ButtonInit(null));
        sd.setButtons(buttons);
        return sd;
    }

    private void showScreen(ScreenDescription sd, Map<String, Object> data) {
        this.log.info((Object)"------ Show screen: print");
        if (this.screen == null) {
            this.log.warn((Object)"Screen not create, skip show");
            this.environment.getEndingModule().end(this.environment);
        } else {
            try {
                this.screen.setListener((ScreenListener)this.listener);
                ScreenInit si = InitModuleHelper.buildScreenInit(this.environment, data);
                Pack pack = Session.getInstance().getPack();
                si.setPayments(pack.getPayments());
                this.screen.init(sd, si);
                this.log.info((Object)("Show screen: " + this.screen));
                this.context.showScreen(new ContentScreenAdapterKbr(this.screen));
                this.log.info((Object)"Complete show screen");
            }
            catch (InitException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                this.environment.getEndingModule().end(this.environment);
            }
        }
    }

    @Override
    protected void _print(Environment environment) {
        this.environment = environment;
        this.startPrint(environment);
        if (this.isFirstShow) {
            this.isFirstShow = false;
            this.showScreen(this.createSD(), new HashMap<String, Object>());
        } else {
            environment.getEndingModule().end(environment);
        }
    }

    private void startPrint(Environment environment) {
        boolean printOperationFlag;
        Pack pack = Session.getInstance().getPack();
        Operation printOperation = environment.getPrintOperation();
        Service srv = pack.getService();
        boolean isPaperEnd = false;
        PrinterStatus lastStatus = this.context.getPrinterQueue().getLastStatus();
        if (lastStatus != null && lastStatus.isPaperEnd()) {
            isPaperEnd = true;
        }
        boolean bl = printOperationFlag = printOperation != null && printOperation.getSumResult() != null && (printOperation.getSumResult().getOut() == null || printOperation.getSumResult().getOut().isEmpty());
        if (AppDefaults.getInstance().getBooleanProperty("Module.print.skip-void", false) && isPaperEnd && printOperationFlag) {
            this.prePrint(false);
        } else if (srv.getPrintCheckDialog() == null) {
            if (pack.getCbc() == null && (printOperation == null || printOperation.getPinCodeNominal() == null)) {
                this.prePrint(false);
            } else {
                this.log.info((Object)"Print without ask");
                this.prePrint(true);
            }
        } else if (printOperation != null && (printOperation.getFlags() & 0x200) > 0) {
            this.prePrint(false);
        } else if (this.noPrintGiftPayment && Session.getInstance().getPack().getPaymentType() == 1) {
            this.log.info((Object)"Gift payment print disabled");
            this.prePrint(false);
        } else if (srv.getPrintCheckDialog() == null || pack.isCancel() && pack.getPaybackType() == 3) {
            this.prePrint(false);
        } else {
            this.log.info((Object)"Print invoice without ask");
            this.prePrint(true);
        }
    }

    @Override
    protected void endPrint() {
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null) {
            if (this.environment != null) {
                this.environment.getEndingModule().end(this.environment);
            } else {
                intent.process();
            }
        } else {
            this.context.toMainMenu();
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if ("Search".equals(action)) {
                AppEnvironment.getInstance().open(ProviderType.SearchService);
            } else {
                BanneredPrintModule.this.environment.getEndingModule().end(BanneredPrintModule.this.environment);
            }
        }

        public void onRedirect(int serviceId) {
            if (ModuleHelper.redirect(serviceId, null, BanneredPrintModule.this.environment, BanneredPrintModule.this.context)) {
                BanneredPrintModule.this.environment.getEndingModule().end(BanneredPrintModule.this.environment);
            }
        }
    }
}

