/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payout;

import i18n.B;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.application.cdm.Cdm;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui.utils.menu.MobileSearchVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.device.hopper.DispenseAdapter;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.hardware.device.hopper.PayoutOperation;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.module.payout.BasePayoutModule;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.PinCodeGenerator;

public class PayoutModuleDispatcherV2
extends BasePayoutModule {
    public static final String CASH = "CASH";
    public static final String PIN = "PIN";
    public static final String SERVICE = "SERVICE";
    public static final String TO_SAVE = "TO_SAVE";
    public static final String MOBILE = "MOBILE";
    public static final String KEEPER = "KEEPER";
    private static final String PAYOUT_TYPE = "#payoutType";
    private static final String PAYOUT_SCREEN_TYPE = "cashback-selector";
    private static final String NO_CASH_ON_CANCEL_KEY = "Module.payout.no-cash-oncancel";
    private final Logger log = Logger.getLogger((String)"pay");
    private final WaitScreen waitScreen = ComponentFactory.getInstance().createWaitScreen("");
    private final IHopper hopper = Hopper.getDefaultHopper();
    private final CashDispenser dispancer = Cdm.getInstance();
    private Environment environment;
    private Pack pack;
    private SumResult sr;

    public PayoutModuleDispatcherV2(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startPayout(Environment environment) {
        this.environment = environment;
        this.pack = Session.getInstance().getPack();
        this.sr = this.pack.getSumResult();
        if (this.sr.getChange() != null && !this.sr.getChange().isEmpty()) {
            if (!ModuleHelper.isDeferredPayout(this.pack)) {
                this.log.info((Object)("Payout amount: " + this.sr.getChange()));
                Keeper keeper = new Keeper();
                keeper.addPayback(this.pack.getSumResult().getChange());
                this.pack.setChange(keeper);
                if (AppDefaults.getInstance().getBooleanProperty(NO_CASH_ON_CANCEL_KEY, false) && this.pack.isCancel() && this.pack.getPaybackType() != 4) {
                    this.payoutToPin();
                } else {
                    Service srv = this.pack.getService();
                    int cm = srv.getChangeType();
                    if (this.hopper == null && this.dispancer == null) {
                        this.log.error((Object)"Hopper or dispancer is not found. Remove cash change.");
                        this.log.info((Object)("Old mask: " + BU.toHex((int)srv.getChangeType()) + ", new mask: " + BU.toHex((int)(cm &= 0xFFFFFFFB))));
                    }
                    if ((cm & 8) > 0 && !this.isToMobileEnable((srv.getChangeType() & 0x10) > 0)) {
                        this.log.error((Object)"Remove TO_MOBILE change.");
                        this.log.info((Object)("Old mask: " + BU.toHex((int)srv.getChangeType()) + ", new mask: " + BU.toHex((int)(cm &= 0xFFFFFFF7))));
                    }
                    PaymentSystem ps = environment.getPaymentSystem();
                    if ((cm & 0x20) > 0 && (ps == null || ps.getKeeperChangeService() == null)) {
                        this.log.error((Object)"Remove TO_KEEPER change.");
                        this.log.info((Object)("Old mask: " + BU.toHex((int)srv.getChangeType()) + ", new mask: " + BU.toHex((int)(cm &= 0xFFFFFFDF))));
                    }
                    int cnt = this.getChangeVarCount(cm);
                    this.log.info((Object)("Change types count: " + cnt));
                    this.log.info((Object)("Avaliable types: " + this.getTypes(cm)));
                    if (cnt <= 1) {
                        if ((cm & 2) > 0) {
                            this.payoutToService();
                        } else if ((cm & 8) > 0) {
                            this.payoutToMobile();
                        } else if ((cm & 4) > 0 && (this.hopper != null || this.dispancer != null)) {
                            this.payoutToCash();
                        } else if ((cm & 0x10) > 0) {
                            this.payoutToSave();
                        } else if ((cm & 0x20) > 0) {
                            this.payoutToKeeper();
                        } else {
                            this.payoutToPin();
                        }
                    } else if (cnt >= 2) {
                        String message = MessageFormat.format(B.get((String)"Module.payout.select", (Locale)environment.getLocale()), SumFormatter.formatRound((int)this.sr.getChange().getBasicSum()));
                        String[] cmList = this.getTypes(cm).split(",");
                        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
                        for (int i = 0; i < cnt; ++i) {
                            SelectorItem si = new SelectorItem(B.get((String)("Module.payout.type." + this.getTypeId(cmList[i])), (Locale)environment.getLocale()), "" + this.getTypeId(cmList[i]));
                            items.add(si);
                        }
                        SelectorField sf = new SelectorField();
                        sf.setStore((ItemsStore)new StaticStore(items));
                        LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
                        fields.add(sf);
                        ScreenDescription sd = new ScreenDescription(PAYOUT_SCREEN_TYPE);
                        sd.setTitle(message);
                        sd.setDecor("");
                        sd.setSequence(new FieldSequence(fields));
                        sd.setButtons(InitModuleHelper.createKeyMap());
                        CommonScreen cbScreen = CommonScreenStore.getScreen((String)sd.getType());
                        try {
                            cbScreen.init(sd, InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
                            cbScreen.setListener((ScreenListener)new LocalSelectListener());
                            this.context.showScreen(new ContentScreenAdapter(cbScreen));
                        }
                        catch (InitException ex) {
                            this.log.info((Object)ex, (Throwable)ex);
                        }
                    }
                }
            } else {
                this.pack.setPaybackType(4);
                this.log.info((Object)("Payout amount: " + this.sr.getChange()));
                Keeper keeper = new Keeper();
                keeper.addPayback(this.pack.getSumResult().getChange());
                this.skipPayout("Payout will be made after payment processing", keeper);
            }
        } else {
            this.skipPayout("Payment has no change, process payment", new Keeper());
        }
    }

    private void skipPayout(String text, Keeper change) {
        this.log.info((Object)text);
        this.pack.setChange(change);
        this.environment.getProcessingModule().process(this.environment);
    }

    private int getChangeVarCount(int mask) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if ((mask & 1 << i) <= 0) continue;
            ++count;
        }
        if ((mask & 0x20) > 0) {
            ++count;
        }
        return count;
    }

    private String getTypes(int mask) {
        String res;
        StringBuilder sb = new StringBuilder();
        if ((mask & 4) > 0) {
            sb.append("CASH,");
        }
        if ((mask & 1) > 0) {
            sb.append("PIN,");
        }
        if ((mask & 2) > 0) {
            sb.append("SERVICE,");
        }
        if ((mask & 0x10) > 0) {
            sb.append("TO_SAVE,");
        }
        if ((mask & 8) > 0) {
            sb.append("MOBILE,");
        }
        if ((mask & 0x20) > 0) {
            sb.append("KEEPER,");
        }
        res = (res = sb.toString()).isEmpty() ? "PIN*" : res.substring(0, res.length() - 1);
        return res;
    }

    private int getTypeId(String type) {
        if (CASH.equals(type)) {
            return 4;
        }
        if (PIN.equals(type)) {
            return 1;
        }
        if (SERVICE.equals(type)) {
            return 2;
        }
        if (TO_SAVE.equals(type)) {
            return 16;
        }
        if (MOBILE.equals(type)) {
            return 8;
        }
        if (KEEPER.equals(type)) {
            return 32;
        }
        return 0;
    }

    private void payoutToPin() {
        this.log.info((Object)"Payout to cash back card");
        this.log.info((Object)"Need's to make payback");
        this.pack.setPaybackType(1);
        this.pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), this.pack.getSumResult().getChange()));
        this.environment.getProcessingModule().process(this.environment);
    }

    private void payoutToSave() {
        this.log.info((Object)"Payout to save service");
        this.log.info((Object)"Need's to make payback");
        this.pack.setPaybackType(5);
        this.environment.getProcessingModule().process(this.environment);
    }

    private void payoutToService() {
        this.log.info((Object)"Payout to service");
        this.pack.setPaybackType(3);
        this.environment.getProcessingModule().process(this.environment);
    }

    private void payoutToMobile() {
        this.log.info((Object)"Payout to mobile");
        InputElement chnum = null;
        Service changesrv = null;
        Object objchnum = ((Payment)this.pack.getPayments().get(0)).getData().get(this.environment.getChangeNumber());
        if (objchnum != null && objchnum instanceof InputElement) {
            chnum = (InputElement)objchnum;
        }
        Integer idprov = null;
        if (chnum != null) {
            idprov = FederalNumberValidator.getInstance().getProvider(chnum.getValue());
        }
        if (idprov != null) {
            MobileSearchVisitor visitor = new MobileSearchVisitor(idprov.intValue());
            MenuUtils.processMenu((MenuVisitor)visitor);
            if (visitor.getMenuItem() != null) {
                changesrv = visitor.getMenuItem().getService();
            }
        }
        if (chnum == null) {
            this.log.error((Object)"Can not transfer change to mobile. Mobile number is not set (variable <chnum> is not set)");
            ProblemNotifier.getDefaultNotifier();
            ProblemNotifier.notifyProblemOnce((String)"Can not transfer change to mobile. Mobile number is not set (variable <chnum> is not set)");
            this.payoutToPin();
        } else if (idprov == null) {
            this.log.error((Object)"Can not transfer change to mobile. Id provider is not set (variable <chnum_idprov> is not set)");
            ProblemNotifier.getDefaultNotifier();
            ProblemNotifier.notifyProblemOnce((String)"Can not transfer change to mobile. Id provider is not set (variable <chnum_idprov> is not set)");
            this.payoutToSave();
        } else if (changesrv == null) {
            this.log.error((Object)"Can not transfer change to mobile. Service is not found");
            ProblemNotifier.getDefaultNotifier();
            ProblemNotifier.notifyProblemOnce((String)"Can not transfer change to mobile. Service is not found");
            this.payoutToSave();
        } else {
            this.log.info((Object)"Need's to make payback");
            this.pack.setPaybackType(6);
            this.pack.setPaybackData((Object)chnum);
            this.pack.setPaybackService(changesrv);
            this.environment.getProcessingModule().process(this.environment);
        }
    }

    private void payoutToKeeper() {
        PaymentSystem ps;
        this.log.info((Object)"Payout to keeper");
        InputElement chnum = null;
        Short idKeeper = null;
        Object objchnum = ((Payment)this.pack.getPayments().get(0)).getData().get(this.environment.getChangeNumber());
        if (objchnum != null && objchnum instanceof InputElement) {
            chnum = (InputElement)objchnum;
        }
        if ((ps = this.environment.getPaymentSystem()) != null && ps.getKeeperChangeService() != null) {
            idKeeper = ps.getKeeperChangeService();
        }
        if (chnum == null) {
            this.log.error((Object)"Can not transfer change to keeper. Keeper number is not set (variable <chnum> is not set)");
            ProblemNotifier.notifyProblemOnce((String)"Can not transfer change to keeper. Keeper number is not set (variable <chnum> is not set)");
            this.payoutToPin();
        } else if (idKeeper == null) {
            this.log.error((Object)"Can not transfer change to keeper. Service keeper is not found");
            ProblemNotifier.notifyProblemOnce((String)"Can not transfer change to keeper. Service keeper is not found");
            this.payoutToSave();
        } else {
            this.pack.setPaybackType(8);
            this.pack.setPaybackData((Object)chnum);
            this.pack.setPaybackService(new Service(idKeeper.intValue()));
            this.environment.getProcessingModule().process(this.environment);
        }
    }

    private void payoutToCash() {
        this.log.info((Object)"Payout to cash");
        this.waitScreen.setText(B.get((String)"Module.payout.cash.wait", (Locale)this.environment.getLocale()));
        this.context.showWait(this.waitScreen);
        this.pack.setPaybackType(2);
        this.pack.setChange(new Keeper());
        if (this.dispancer != null) {
            this.context.showWait(null);
            this.payoutToCoin();
        } else {
            this.payoutToCoin();
        }
    }

    private void payoutToCoin() {
        this.waitScreen.setText(B.get((String)"Module.payout.cash.wait", (Locale)this.environment.getLocale()));
        this.context.showWait(this.waitScreen);
        if (this.hopper != null) {
            try {
                this.log.info((Object)"Payout by hopper");
                this.hopper.payout(new PayoutOperation(this.sr.getChange().sub(this.pack.getChange().getCashSum()).getBasicSum(), this.sr.getIncome().getBasicSum(), (DispenseListener)new LocalHopperListener()));
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on", (Throwable)ex);
                this.context.showWait(null);
                this.payoutToPin();
            }
        } else {
            this.payoutToPin();
        }
    }

    private boolean isToMobileEnable(boolean toSave) {
        InputElement chnum = null;
        Service changesrv = null;
        MenuItem mi = null;
        Object objchnum = ((Payment)this.pack.getPayments().get(0)).getData().get(this.environment.getChangeNumber());
        if (objchnum == null || !(objchnum instanceof InputElement)) {
            return false;
        }
        chnum = (InputElement)objchnum;
        Integer idprov = FederalNumberValidator.getInstance().getProvider(chnum.getValue());
        if (idprov != null) {
            MobileSearchVisitor visitor = new MobileSearchVisitor(idprov.intValue());
            MenuUtils.processMenu((MenuVisitor)visitor);
            if (visitor.getMenuItem() != null) {
                mi = visitor.getMenuItem();
                changesrv = visitor.getMenuItem().getService();
            }
        }
        if (idprov == null || changesrv == null) {
            return toSave;
        }
        if (AppDefaults.getInstance().getBooleanProperty("Module.reinit.change.modile.use-menu-comm", false)) {
            Keeper keeper = new Keeper();
            keeper.addPayback(this.pack.getSumResult().getChange());
            Commission personal = ProviderHelper.getPersonalCommission(((Payment)this.pack.getPayments().get(0)).getData(), changesrv.getId(), changesrv.getServiceTypeId());
            Commission comm = personal != null ? personal : mi.getCommission();
            SumResult sr = CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)comm, (Commission)changesrv.getMinComm(), (Commission)changesrv.getCommission(), null, (Sum)changesrv.getMaxSum(), null, (Date)new Date(), (String)CASH, (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)this.pack.getProviderFee(), (boolean)false, null);
            if (sr.getOut().isEmpty() || changesrv.getMinSum().compareTo(sr.getOut()) > 0 || !sr.getChange().isEmpty()) {
                return false;
            }
        } else {
            Sum change = this.pack.getSumResult().getChange();
            if (changesrv.getMinSum().compareTo(change) > 0 || changesrv.getMaxSum().compareTo(change) < 0) {
                return false;
            }
        }
        return true;
    }

    private static Keeper convert(Map<Denomination, Integer> map) {
        Keeper result = new Keeper();
        if (map != null) {
            for (Map.Entry<Denomination, Integer> c : map.entrySet()) {
                result.addCash(CashFactory.getInstance((String)c.getKey().getCurrency()).getCashUnitByNominal(new Sum(c.getKey().getNominal())), c.getValue().intValue());
            }
        }
        return result;
    }

    private class LocalSelectListener
    extends ScreenAdapter {
        private LocalSelectListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            PayoutModuleDispatcherV2.this.log.info((Object)("Cashback selector data: " + data.toString()));
            PayoutModuleDispatcherV2.this.log.info((Object)("Cashback selector action: " + action));
            if (ActionType.isNext((String)action)) {
                InputElement ie = (InputElement)data.get(PayoutModuleDispatcherV2.PAYOUT_TYPE);
                PayoutModuleDispatcherV2.this.log.info((Object)("User make choise " + ie.getValueTitle()));
                int choice = Integer.parseInt(ie.getValue());
                if ((choice & 2) > 0) {
                    PayoutModuleDispatcherV2.this.payoutToService();
                } else if ((choice & 8) > 0) {
                    PayoutModuleDispatcherV2.this.payoutToMobile();
                } else if ((choice & 4) > 0 && (PayoutModuleDispatcherV2.this.hopper != null || PayoutModuleDispatcherV2.this.dispancer != null)) {
                    PayoutModuleDispatcherV2.this.payoutToCash();
                } else if ((choice & 0x10) > 0) {
                    PayoutModuleDispatcherV2.this.payoutToSave();
                } else if ((choice & 0x20) > 0) {
                    PayoutModuleDispatcherV2.this.payoutToKeeper();
                } else {
                    PayoutModuleDispatcherV2.this.payoutToPin();
                }
            }
        }
    }

    private class LocalHopperListener
    extends DispenseAdapter {
        private LocalHopperListener() {
        }

        public void onProcess(int sumDispensed) {
            PayoutModuleDispatcherV2.this.log.info((Object)("Sum dispensed: " + sumDispensed));
            PayoutModuleDispatcherV2.this.waitScreen.setText(MessageFormat.format(B.get((String)"Module.payout.cash.process", (Locale)PayoutModuleDispatcherV2.this.environment.getLocale()), new Sum(sumDispensed)));
        }

        public void onResult(Keeper keeper) {
            PayoutModuleDispatcherV2.this.log.info((Object)("Finish: " + keeper));
            PayoutModuleDispatcherV2.this.log.info((Object)("Expected payout: " + PayoutModuleDispatcherV2.this.pack.getSumResult().getChange() + ", obtained=" + keeper.getSum()));
            PayoutModuleDispatcherV2.this.context.showWait(null);
            PayoutModuleDispatcherV2.this.pack.setChange(keeper);
            if (PayoutModuleDispatcherV2.this.pack.getSumResult().getChange().compareTo(keeper.getSum()) > 0) {
                Sum rest = PayoutModuleDispatcherV2.this.pack.getSumResult().getChange().sub(keeper.getSum());
                PayoutModuleDispatcherV2.this.log.info((Object)("Failed to give full payout, rest=" + rest));
                PayoutModuleDispatcherV2.this.pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), rest));
            }
            ServiceZReportStorage.getInstance().getCurrentSnapshot().mulZCashSum(keeper);
            Session.getInstance().flush();
            PayoutModuleDispatcherV2.this.environment.getProcessingModule().process(PayoutModuleDispatcherV2.this.environment);
        }

        public void onError() {
            PayoutModuleDispatcherV2.this.context.showWait(null);
            PayoutModuleDispatcherV2.this.log.info((Object)"Error on dispens");
            PayoutModuleDispatcherV2.this.log.info((Object)"Payout to cash back card");
            PayoutModuleDispatcherV2.this.pack.setPaybackType(1);
            PayoutModuleDispatcherV2.this.pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), PayoutModuleDispatcherV2.this.pack.getSumResult().getChange()));
            PayoutModuleDispatcherV2.this.pack.setChangeDispenseError(true);
            PayoutModuleDispatcherV2.this.environment.getProcessingModule().process(PayoutModuleDispatcherV2.this.environment);
        }
    }
}

