/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.awt.EventQueue;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BaseKeeperListener;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class CreditCashPaymentModule
extends BasePaymentModule {
    private BasePinCodeScreen pinScreen = (BasePinCodeScreen)ComponentFactory.getInstance().createDialogPanel("cbc");
    private ScreenListener listener = new LocalScreenListener();
    private Logger log = Logger.getLogger((String)"pay");
    private Runnable cancelListener;
    private BaseKeeperListener keeperListener;
    private PayDetector payDetector;
    private Keeper cbcKeeper;
    private Sum max;
    private Sum maxPay;
    private Service service;
    private ServiceLimit payToolServiceLimit;
    CommonSumScreen sumScreen;
    private Commission c;
    private Sum min;
    private Sum opr;
    private Sum requireSum;
    private static final Sum emptySum = new Sum(0);

    public CreditCashPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public int getInactivityTimeout() {
        if (this.service != null && this.service.getAutoProcessDueToInactivity() != null && this.service.getAutoProcessDueToInactivity() >= 20 && this.service.getAutoProcessDueToInactivity() <= 120 && this.payDetector.canPay(this.payDetector.calculate(CashManager.getDefaultInstance().current()))) {
            return this.service.getAutoProcessDueToInactivity();
        }
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Session.getInstance().setCorrectPack(Session.getInstance().getPack());
        this.environment = environment;
        this.sumScreen = sumScreen;
        this.context.setModule(this);
        this.cbcKeeper = null;
        this.log.info((Object)"Open payment module");
        Pack pack = Session.getInstance().getPack();
        PackUtility.printPack("Payment pack", pack);
        MenuItem mi = environment.getMenuItem();
        this.service = pack.getService() == null ? mi.getService() : pack.getService();
        this.c = pack.getCommission() == null ? mi.getCommission() : pack.getCommission();
        this.updateSums("CASH");
        sumScreen.setListener(this.listener);
        this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)sumScreen));
        this.payDetector = new PayDetector(this.service, this.c, this.min, this.maxPay, this.opr, environment.getDateOfStartPayment(), null, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        this.keeperListener = new BaseKeeperListener(this.context, environment.getLocale(), sumScreen, this.requireSum, pack.getMinSum(), this.service, this.payDetector, this.service.isAutoFinishPayment(), this.listener, pack.isAllowReturn());
        this.enableCashManager(Session.getInstance().getCurrentKeeper());
    }

    private void updateSums(String pSource) {
        this.min = this.payToolServiceLimit != null ? this.payToolServiceLimit.getMinSum() : this.service.getMinSum();
        Pack pack = Session.getInstance().getPack();
        this.maxPay = pack.getMaxSum() != null ? pack.getMaxSum() : this.service.getMaxSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.payToolServiceLimit != null ? this.payToolServiceLimit.getMaxSum() : this.service.getMaxSum();
        }
        this.opr = pack.getOperationSum();
        if (this.min == null) {
            this.min = new Sum();
        }
        this.log.info((Object)("min sum=" + this.min + ", max=" + this.max + ", max payment sum=" + this.maxPay + ",max input sum=" + this.service.getMaxInputSum() + ", operation sum=" + this.opr));
        if (this.min != null && this.opr != null && this.opr.compareTo(this.min) < 0) {
            this.log.info((Object)("Fix min sum to=" + this.opr));
            this.min = this.opr;
        }
        this.requireSum = null;
        if (this.opr != null && !this.opr.isEmpty()) {
            this.requireSum = CommissionCalculator.calculate((Sum)this.opr, (Commission)this.c, (Commission)this.service.getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)pSource, (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        if (this.requireSum == null && this.min.equals((Object)this.max)) {
            this.requireSum = CommissionCalculator.calculate((Sum)this.min, (Commission)this.c, (Commission)this.service.getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)pSource, (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            this.requireSum = this.roundRequireSum(this.requireSum);
        }
        if (this.requireSum == null && this.min != null && !this.min.isEmpty()) {
            this.requireSum = CommissionCalculator.calculate((Sum)this.min, (Commission)this.c, (Commission)this.service.getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)pSource, (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            this.requireSum = this.roundRequireSum(this.requireSum);
        }
        if (this.requireSum != null) {
            this.log.info((Object)("Required sum: " + this.requireSum));
        }
    }

    @Override
    public void cancel(Intent intent) {
        this._cancel(intent);
    }

    private void enableCashManager(Keeper parent) {
        if (parent != null) {
            this.log.info((Object)("Enable cash manager with keeper: " + parent));
        }
        CashManager.getDefaultInstance().enable(parent, this.max, this.environment.getAllowedNotes(), this.environment.getAllowedCoins(), (KeeperObserver)this.keeperListener, CashMobuleHelper.getAllowDevices(this.service, parent == null ? false : !parent.getCashBackCards().isEmpty()), false);
    }

    private void _cancel(Intent intent) {
        this.log.info((Object)"Cancel was requested on payment module");
        boolean timeout = intent.getType() == 0;
        this.log.info((Object)"Disable cash devices");
        Keeper keeper = CashManager.getDefaultInstance().disable();
        this.log.info((Object)("Keeper is " + (!keeper.getSum().isEmpty() ? "not " : "") + "empty: " + keeper));
        Session.getInstance().setCurrentKeeper(keeper);
        if (!(keeper.getSum().isEmpty() || 2 != intent.getType() && 0 != intent.getType())) {
            this.process(keeper, UserCase.Cancel, timeout);
        } else {
            this.log.info((Object)("Process intent: " + intent.getType() + " (" + intent + ")"));
            intent.process();
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        this.log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = this.payDetector.calculate(keeper);
        if (Session.getInstance().getPack().getService().getDivideSum() != null && !Session.getInstance().getPack().getService().getDivideSum().isEmpty() && userCase == UserCase.Ok && pkg.getPayments().size() == 1) {
            Sum totalInput = new Sum(sumResult.getOut());
            Sum divSum = Session.getInstance().getPack().getService().getDivideSum();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getBasicSum() / divSum.getBasicSum();
            if (!totalInput.divRest(divSum).isEmpty()) {
                ++count;
            }
            --count;
            Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                Session.getInstance().getPack().getPayments().add(payment1);
            }
            Session.getInstance().getPack().setSumDistributionType("consistent");
        }
        if (pkg.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                p.setSumOut(sumResult.getOut());
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private Sum roundRequireSum(Sum requireSum) {
        int ost;
        CashUnit[] cashUnits;
        if (requireSum == null) {
            return requireSum;
        }
        if (CashDeviceManager.getInstance().getDefaultCoinValidator() == null && (cashUnits = CashFactory.getDefaultInstance().getCashUnits()) != null && cashUnits.length > 0 && (ost = requireSum.getBasicSum() % cashUnits[0].getNominal().getBasicSum()) > 0) {
            return requireSum.add(cashUnits[0].getNominal().sub(new Sum(ost)));
        }
        return requireSum;
    }

    private class DialogRunnable
    implements Runnable {
        private String text;

        public DialogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, this.text, 10, DC.cases((int)1, (Locale)CreditCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CreditCashPaymentModule.this.enableCashManager(CreditCashPaymentModule.this.cbcKeeper);
                    CreditCashPaymentModule.this.cbcKeeper = null;
                }
            });
            CreditCashPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class PincodeActivator
    implements Task {
        private String pin;

        public PincodeActivator(String pin) {
            this.pin = pin;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.cbc.wait");
        }

        @Override
        public Object execute() {
            Sum localMaxSum;
            Sum sum = localMaxSum = CreditCashPaymentModule.this.payToolServiceLimit != null ? CreditCashPaymentModule.this.payToolServiceLimit.getMaxSum() : CreditCashPaymentModule.this.max;
            if (localMaxSum == null || localMaxSum.isEmpty()) {
                CreditCashPaymentModule.this.log.info((Object)"Max sum is not specify. Return error");
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            if (localMaxSum.compareTo(CreditCashPaymentModule.this.cbcKeeper.getSum()) <= 0) {
                CreditCashPaymentModule.this.log.info((Object)("Keeper reached max sum. Return error. Max=" + localMaxSum + ", keeper=" + CreditCashPaymentModule.this.cbcKeeper.getSum()));
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            Sum rest = localMaxSum.sub(CreditCashPaymentModule.this.cbcKeeper.getSum());
            CreditCashPaymentModule.this.log.info((Object)("Maximum nominal: " + localMaxSum));
            CreditCashPaymentModule.this.log.info((Object)("Allowed rest: " + rest));
            try {
                return CreditCashPaymentModule.this.context.getServerConnector().acivateCashBackCard(this.pin, new Sum(), localMaxSum.sub(CreditCashPaymentModule.this.cbcKeeper.getSum()), SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            CreditCashPaymentModule.this.log.info((Object)("Result: " + object));
            String text = null;
            if (object instanceof ActivationResult) {
                ActivationResult ar = (ActivationResult)object;
                if (ar.getError() == ActivationResultType.Ok) {
                    CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
                    cbc.setNominal(ar.getRest());
                    cbc.setRef(ar.getIdOperation());
                    CreditCashPaymentModule.this.cbcKeeper.addCashBackCard(cbc);
                    CreditCashPaymentModule.this.enableCashManager(CreditCashPaymentModule.this.cbcKeeper);
                    CreditCashPaymentModule.this.cbcKeeper = null;
                    return;
                }
                text = B.get((String)("Request.cbc.err." + ar.getError()), (Locale)CreditCashPaymentModule.this.environment.getLocale());
            } else {
                text = B.get((String)("Request.cbc.err." + ActivationResultType.ErrNetwork), (Locale)CreditCashPaymentModule.this.environment.getLocale());
            }
            EventQueue.invokeLater(new DialogRunnable(text));
        }
    }

    private class LocalPinCodeListener
    implements CustomDialogListener {
        private LocalPinCodeListener() {
        }

        public void onClose(Object type) {
            ModuleHelper.invoke(CreditCashPaymentModule.this.cancelListener);
            if (type != null) {
                String pincode = (String)type;
                CreditCashPaymentModule.this.log.info((Object)("Input pincode: " + pincode));
                ModuleHelper.invoke(CreditCashPaymentModule.this.cancelListener);
                CreditCashPaymentModule.this.context.getTaskExecutor().execute(new PincodeActivator(pincode));
            } else {
                CreditCashPaymentModule.this.log.info((Object)"Close pincode screen");
                ModuleHelper.invoke(CreditCashPaymentModule.this.cancelListener);
                CreditCashPaymentModule.this.enableCashManager(CreditCashPaymentModule.this.cbcKeeper);
                CreditCashPaymentModule.this.cbcKeeper = null;
                CreditCashPaymentModule.this.context.getShell().showPopup(null);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CreditCashPaymentModule.this.log.info((Object)("Action on sum screen: " + action));
            CreditCashPaymentModule.this.log.info((Object)("Data: " + data));
            CreditCashPaymentModule.this.cancelListener = cancelListener;
            if (ActionType.isCbc((String)action)) {
                CreditCashPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                CreditCashPaymentModule.this.log.info((Object)("Keeper: " + CreditCashPaymentModule.this.cbcKeeper));
                if (!CashMobuleHelper.isAllowCBC(CreditCashPaymentModule.this.service, !CreditCashPaymentModule.this.cbcKeeper.getCashSum().isEmpty())) {
                    CreditCashPaymentModule.this.log.info((Object)"CBC disable for this service ");
                    CreditCashPaymentModule.this.enableCashManager(CreditCashPaymentModule.this.cbcKeeper);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                CreditCashPaymentModule.this.pinScreen.init(CreditCashPaymentModule.this.environment.getLocale());
                CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)CreditCashPaymentModule.this.pinScreen, Math.min(30, CreditCashPaymentModule.this.getInactivityTimeout() - 5), null, true);
                cpd.addListener((CustomDialogListener)new LocalPinCodeListener());
                CreditCashPaymentModule.this.context.showDialog((DialogInterface)cpd);
            } else if (ActionType.isEdit((String)action)) {
                CreditCashPaymentModule.this.updateSums("CASH");
                CreditCashPaymentModule.this.payDetector.setOperationSum(CreditCashPaymentModule.this.opr);
                CreditCashPaymentModule.this.keeperListener.setRequireSum(CreditCashPaymentModule.this.requireSum);
                CreditCashPaymentModule.this.keeperListener.update(Session.getInstance().getCurrentKeeper(), emptySum);
                ModuleHelper.invoke(cancelListener);
            } else if (ActionType.isExit((String)action)) {
                CreditCashPaymentModule.this.cancel(new ExitIntent(CreditCashPaymentModule.this.context, 2));
            } else if (ActionType.isPrev((String)action)) {
                CreditCashPaymentModule.this.cancel(new ExitIntent(CreditCashPaymentModule.this.context, 2));
            } else if (ActionType.isNext((String)action)) {
                CreditCashPaymentModule.this.log.info((Object)"Disable devices again");
                Keeper keeper = CashManager.getDefaultInstance().disable();
                if (keeper.getSum().isEmpty()) {
                    CreditCashPaymentModule.this.log.info((Object)"Enable devices again");
                    CreditCashPaymentModule.this.enableCashManager(keeper);
                    ModuleHelper.invoke(cancelListener);
                } else {
                    CreditCashPaymentModule.this.process(keeper, UserCase.Cancel, false);
                }
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Unknown action on sumscreen: " + action);
            }
        }

        public void onLocale(Locale locale) {
            CreditCashPaymentModule.this.environment.setLocale(locale);
        }
    }
}

