/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class CashlessAutoPaymentModule
extends BasePaymentModule {
    private Logger log = Logger.getLogger((String)"pay");
    private Sum max;
    private Sum maxPay;
    private Service service;
    private Sum operationSum;
    private List<Sum> packSums;
    private Commission commission;
    private MenuItem mi;

    public CashlessAutoPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public int getInactivityTimeout() {
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        this.environment = environment;
        this.context.setModule(this);
        Pack pack = Session.getInstance().getPack();
        this.log.info((Object)"Open cashless-auto payment module");
        PackUtility.printPack("Payment pack", pack);
        this.mi = environment.getMenuItem();
        this.service = pack.getService() == null ? this.mi.getService() : pack.getService();
        this.commission = pack.getCommission() == null ? this.mi.getCommission() : pack.getCommission();
        Sum min = pack.getMinSum() != null ? pack.getMinSum() : this.service.getMinSum();
        this.maxPay = pack.getMaxSum() != null ? pack.getMaxSum() : this.service.getMaxSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.service.getMaxSum();
        }
        this.operationSum = pack.getOperationSum();
        if (this.operationSum != null && this.operationSum.getBasicSum() < 0) {
            ProblemNotifier.notifyProblem((String)(environment.getMenuItem().getService().getId() + "->TransactionSumError: " + this.operationSum));
            this.context.toMainMenu();
            return;
        }
        if (min == null) {
            min = new Sum();
        }
        this.log.info((Object)("min sum=" + min + ", max=" + this.max + ", max payment sum=" + this.maxPay + ",max input sum=" + this.service.getMaxInputSum() + ", operation sum=" + this.operationSum));
        if (min != null && this.operationSum != null && this.operationSum.compareTo(min) < 0) {
            this.log.info((Object)("Fix min sum to=" + this.operationSum));
            min = this.operationSum;
        }
        Sum requireSum = null;
        this.packSums = PackUtility.getPackSums(Session.getInstance().getPack());
        if (this.service.isGroupPaymentDividedCommission() && this.packSums != null && (this.operationSum == null || this.operationSum.isEmpty())) {
            requireSum = CommissionCalculator.calculate(this.packSums, (Commission)this.commission, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        } else if (this.service.isGroupPaymentDividedCommission() && this.service.getDivideSum() != null && !this.service.getDivideSum().isEmpty() && (this.operationSum == null || this.operationSum.isEmpty())) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Sum)this.service.getDivideSum(), (Commission)this.commission, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        } else if (this.operationSum != null && !this.operationSum.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)this.operationSum, (Commission)this.commission, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        if (requireSum == null && min.equals((Object)this.maxPay)) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)this.commission, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        if (requireSum == null && min != null && !min.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)this.commission, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        if (requireSum != null) {
            this.log.info((Object)("Required sum: " + requireSum));
        }
        Keeper k = new Keeper();
        k.addPayback(requireSum);
        this.process(k, UserCase.Ok, true);
    }

    @Override
    public void cancel(Intent intent) {
        this._cancel(intent);
    }

    private synchronized void _cancel(Intent intent) {
        this.log.info((Object)"Cancel was requested on payment module");
        if (intent != null) {
            intent.process();
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        this.log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = null;
        if (this.service.isGroupPaymentDividedCommission() && this.operationSum == null) {
            Sum divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? this.max : this.service.getDivideSum();
            sumResult = CommissionCalculator.calculatePack((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, null, (Date)this.environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), null);
        } else {
            sumResult = CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, null, (Date)this.environment.getDateOfStartPayment(), (String)"CASH", (boolean)this.mi.isIgnoreMinMaxCommission(), (FeeSum)pkg.getProviderFee(), null);
        }
        if (pkg.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                p.setSumOut(sumResult.getOut());
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    public String toString() {
        return "CashlessAutoPaymentModule";
    }
}

