/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.currency.CurrencyUtil;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CompleteInit;
import ru.softlogic.gui.screen.popup.dialog.custom.CompletePanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.intent.BackIntent;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.CurrencyKeeperListener;
import ru.softlogic.module.payment.KeeperObserverProxy;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionNominal;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class CashCurrencyPaymentModule
extends BasePaymentModule {
    private BasePinCodeScreen pinScreen = (BasePinCodeScreen)ComponentFactory.getInstance().createDialogPanel("cbc");
    private ScreenListener listener = new LocalScreenListener();
    private Logger log;
    private Runnable cancelListener;
    private KeeperObserver keeperListener;
    private CurrencyKeeperListener currencyKeeperListener;
    private PayDetector payDetector;
    private Keeper cbcKeeper;
    private Sum max;
    private Sum operSystem;
    private Sum operProvider;
    private Sum maxPay;
    private Service service;
    private ServiceLimit payToolServiceLimit;
    private Double rate;
    private CompletePanel commissionPanel = (CompletePanel)ComponentFactory.getInstance().createDialogPanel("commission");

    public CashCurrencyPaymentModule(ApplicationContext context) {
        super(context);
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public int getInactivityTimeout() {
        if (this.service != null && this.service.getAutoProcessDueToInactivity() != null && this.service.getAutoProcessDueToInactivity() >= 20 && this.service.getAutoProcessDueToInactivity() <= 120 && this.payDetector.canPay(this.payDetector.calculate(CashManager.getDefaultInstance().current()))) {
            return this.service.getAutoProcessDueToInactivity();
        }
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Session.getInstance().setCorrectPack(Session.getInstance().getPack());
        this.environment = environment;
        Pack pack = Session.getInstance().getPack();
        this.cbcKeeper = null;
        this.log.info((Object)"Open payment module");
        PackUtility.printPack("Payment pack", pack);
        MenuItem mi = environment.getMenuItem();
        this.service = pack.getService() == null ? mi.getService() : pack.getService();
        Commission c = pack.getCommission() == null ? mi.getCommission() : pack.getCommission();
        Sum min = this.service.getMinSum();
        this.maxPay = pack.getMaxSum() != null ? pack.getMaxSum() : this.service.getMaxSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.service.getMaxSum();
        }
        this.operProvider = this.operSystem = pack.getOperationSum();
        this.log.info((Object)("Service currency: " + this.service.getCurrencyCode()));
        this.rate = CurrencyUtil.getRate((String)this.service.getCurrencyCode(), (int)this.service.getId());
        this.log.info((Object)("Currency rate: " + this.rate));
        if (this.service.getCurrencyCode() != null && !this.service.getCurrencyCode().isEmpty() && this.rate == null) {
            ProblemNotifier.notifyProblem((String)("Can't get currency rate: " + this.service.getCurrencyCode()));
            this.cancel(null);
            return;
        }
        if (this.operProvider != null && this.operProvider.getBasicSum() < 0) {
            ProblemNotifier.notifyProblem((String)(environment.getMenuItem().getService().getId() + "->TransactionSumError: " + this.operProvider));
            this.context.toMainMenu();
            return;
        }
        if (min == null) {
            min = new Sum();
        }
        this.log.info((Object)("min sum=" + min + ", max=" + this.max + ", max payment sum=" + this.maxPay + ",max input sum=" + this.service.getMaxInputSum() + ", operation sum=" + this.operSystem));
        if (this.operProvider != null && this.rate != null) {
            this.log.info((Object)"");
            if (c.getNominals() != null) {
                boolean notFound = true;
                for (CommissionNominal cn : c.getNominals()) {
                    if (cn.getProviderAmount() == null || cn.getProviderAmount().getBasicSum() != this.operProvider.getBasicSum()) continue;
                    this.operSystem = new Sum(cn.getNominal());
                    notFound = false;
                    break;
                }
                if (notFound) {
                    this.operSystem = this.operProvider.mul(this.rate.doubleValue());
                }
            } else {
                this.operSystem = this.operProvider.mul(this.rate.doubleValue());
            }
        }
        if (min != null && this.operSystem != null && this.operSystem.compareTo(min) < 0) {
            this.log.info((Object)("Fix min sum to=" + this.operSystem));
            min = this.operSystem;
        }
        Sum requireSum = null;
        if (this.operSystem != null && !this.operSystem.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)this.operSystem, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
        }
        if (requireSum == null && min.equals((Object)this.max)) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
        }
        if (requireSum == null && min != null && !min.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
        }
        if (requireSum != null) {
            this.log.info((Object)("Required sum: " + requireSum));
        }
        sumScreen.setListener(this.listener);
        this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)sumScreen));
        this.payDetector = new PayDetector(this.service, c, min, this.max, this.operSystem, environment.getDateOfStartPayment(), null, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        this.currencyKeeperListener = new CurrencyKeeperListener(sumScreen, this.operSystem, requireSum, this.service, this.payDetector, this.service.isAutoFinishPayment(), this.listener);
        this.keeperListener = new KeeperObserverProxy(this.currencyKeeperListener, externalObserver);
        this.enableCashManager(Session.getInstance().getCurrentKeeper());
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null) {
            this._cancel(intent);
        } else {
            this.context.toMainMenu();
        }
    }

    @Override
    public boolean canRedirect() {
        Keeper current = CashManager.getDefaultInstance().current();
        this.log.info((Object)"canRedirect: Request for permission to redirect from PaymentModule");
        if (current == null || current.getSum().isEmpty()) {
            this.log.info((Object)"canRedirect: Keeper is empty. Disable cash devices");
            Keeper keeper = CashManager.getDefaultInstance().disable();
            if (keeper == null || keeper.getSum().isEmpty()) {
                this.log.info((Object)"canRedirect: Keeper is empty. Process redirect");
                return true;
            }
            this.log.info((Object)"canRedirect: Current keeper is not empty");
            this.enableCashManager(keeper);
            return false;
        }
        this.log.info((Object)"canRedirect: Current keeper is not empty. Skip redirect");
        return false;
    }

    private void enableCashManager(Keeper parent) {
        if (parent != null) {
            this.log.info((Object)("Enable cash manager with keeper: " + parent));
        }
        CashManager.getDefaultInstance().enable(parent, this.max, this.environment.getAllowedNotes(), this.environment.getAllowedCoins(), this.keeperListener, CashMobuleHelper.getAllowDevices(this.service, parent == null ? false : !parent.getCashBackCards().isEmpty()), false);
    }

    @Override
    public synchronized boolean cancelRequest() {
        Keeper keeper;
        this.log.info((Object)"Try to cancel payment module");
        Keeper keep = this.cbcKeeper;
        if (keep != null) {
            this.enableCashManager(keep);
        }
        if ((keeper = CashManager.getDefaultInstance().disable()).getSum().isEmpty()) {
            return true;
        }
        this.log.info((Object)"Can't invoke CancelRequest");
        this.enableCashManager(keeper);
        return false;
    }

    private synchronized void _cancel(Intent intent) {
        block17: {
            boolean timeout;
            this.log.info((Object)"Cancel was requested on payment module");
            Keeper current = CashManager.getDefaultInstance().current();
            boolean bl = timeout = intent.getType() == 0;
            if (current.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Disable cash devices");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                if (keeper.getSum().isEmpty()) {
                    this.log.info((Object)"Keeper is empty. Process intent");
                    Session.getInstance().getPack().setKeeper(keeper);
                    try {
                        if (CardModuleStore.getInstance().getCurrentSession() != null) {
                            CardModuleStore.getInstance().clearCashRequireListener();
                            CardModuleStore.getInstance().clearBankCashRequireListener();
                            CardModuleStore.getInstance().invokeOutCancelListener(intent);
                            break block17;
                        }
                        intent.process();
                    }
                    catch (Throwable e) {
                        intent.process();
                    }
                } else {
                    this.log.info((Object)("New keeper state: " + keeper));
                    if (intent.getType() == 3) {
                        this.log.info((Object)"Can't do back action. Enable devices again");
                        this.enableCashManager(keeper);
                        ModuleHelper.invoke(this.cancelListener);
                    } else if (this.payDetector.canPay(this.payDetector.calculate(keeper))) {
                        if (timeout && this.service != null && this.service.getAutoProcessDueToInactivity() != null) {
                            this.log.info((Object)"Exit by timeout, but payment can be processed. Process payment without question.");
                            this.process(keeper, UserCase.Ok, timeout);
                        } else {
                            this.log.info((Object)"Payment can be processed, ask question");
                            final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)CashCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)CashCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                    dialog.addListener(new DialogListener(){

                                        public void dialogClosed(UserCase userCase) {
                                            CashCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                            if (userCase == UserCase.Cancel) {
                                                CashCurrencyPaymentModule.this.log.info((Object)"Process cancel");
                                                CashCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                                            } else {
                                                CashCurrencyPaymentModule.this.log.info((Object)"Enable devices again");
                                                CashCurrencyPaymentModule.this.enableCashManager(keeper);
                                                ModuleHelper.invoke(CashCurrencyPaymentModule.this.cancelListener);
                                            }
                                        }
                                    });
                                    dialog.show(CashCurrencyPaymentModule.this.context.getShell());
                                }
                            });
                        }
                    } else {
                        this.log.info((Object)"Payment can't be processed. Cancel payment");
                        this.process(keeper, UserCase.Cancel, timeout);
                    }
                }
            } else {
                this.log.info((Object)"Keeper is not empty. Disable cash devices");
                if (this.payDetector.canPay(this.payDetector.calculate(current))) {
                    final Keeper keeper = CashManager.getDefaultInstance().disable();
                    if (timeout && this.service != null && this.service.getAutoProcessDueToInactivity() != null) {
                        this.log.info((Object)"Exit by timeout, but payment can be processed. Process payment without question.");
                        this.process(keeper, UserCase.Ok, timeout);
                    } else {
                        this.log.info((Object)"The amount is sufficient for the payment, ask question");
                        final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)CashCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)4, (Locale)CashCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        CashCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                        CashCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                                    }
                                });
                                dialog.show(CashCurrencyPaymentModule.this.context.getShell());
                            }
                        });
                    }
                } else {
                    this.log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                    final Keeper keeper = CashManager.getDefaultInstance().disable();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.payment.cancel.continue", (Locale)CashCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)CashCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    CashCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                    if (userCase == UserCase.Cancel) {
                                        CashCurrencyPaymentModule.this.log.info((Object)"Disable cash devices");
                                        CashCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                                    } else {
                                        CashCurrencyPaymentModule.this.enableCashManager(keeper);
                                        ModuleHelper.invoke(CashCurrencyPaymentModule.this.cancelListener);
                                    }
                                }
                            });
                            dialog.show(CashCurrencyPaymentModule.this.context.getShell());
                        }
                    });
                }
            }
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        this.log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        ServiceZReportStorage.getInstance().getCurrentSnapshot().addZCashSum(keeper);
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = this.payDetector.calculate(keeper);
        if (userCase == UserCase.Ok) {
            if (this.operProvider != null) {
                sumResult.setOutProv(this.operProvider);
            } else {
                sumResult.setOutProv(sumResult.getOut().div(this.rate.doubleValue()));
            }
        }
        if (Session.getInstance().getPack().getService().getDivideSum() != null && !Session.getInstance().getPack().getService().getDivideSum().isEmpty() && userCase == UserCase.Ok && pkg.getPayments().size() == 1) {
            Sum totalInput = new Sum(sumResult.getOut());
            Sum divSum = Session.getInstance().getPack().getService().getDivideSum();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getBasicSum() / divSum.getBasicSum();
            if (!totalInput.divRest(divSum).isEmpty()) {
                ++count;
            }
            --count;
            Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                Session.getInstance().getPack().getPayments().add(payment1);
            }
            Session.getInstance().getPack().setSumDistributionType("consistent");
        }
        if (pkg.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                p.setSumOut(sumResult.getOut());
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private class DialogRunnable
    implements Runnable {
        private String text;

        public DialogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, this.text, 10, DC.cases((int)1, (Locale)CashCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CashCurrencyPaymentModule.this.enableCashManager(CashCurrencyPaymentModule.this.cbcKeeper);
                    CashCurrencyPaymentModule.this.cbcKeeper = null;
                }
            });
            CashCurrencyPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class PincodeActivator
    implements Task {
        private String pin;

        public PincodeActivator(String pin) {
            this.pin = pin;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.cbc.wait");
        }

        @Override
        public Object execute() {
            Sum localMaxSum;
            Sum sum = localMaxSum = CashCurrencyPaymentModule.this.payToolServiceLimit != null ? CashCurrencyPaymentModule.this.payToolServiceLimit.getMaxSum() : CashCurrencyPaymentModule.this.max;
            if (localMaxSum == null || localMaxSum.isEmpty()) {
                CashCurrencyPaymentModule.this.log.info((Object)"Max sum is not specify. Return error");
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            if (localMaxSum.compareTo(CashCurrencyPaymentModule.this.cbcKeeper.getSum()) <= 0) {
                CashCurrencyPaymentModule.this.log.info((Object)("Keeper reached max sum. Return error. Max=" + localMaxSum + ", keeper=" + CashCurrencyPaymentModule.this.cbcKeeper.getSum()));
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            Sum rest = localMaxSum.sub(CashCurrencyPaymentModule.this.cbcKeeper.getSum());
            CashCurrencyPaymentModule.this.log.info((Object)("Maximum nominal: " + localMaxSum));
            CashCurrencyPaymentModule.this.log.info((Object)("Allowed rest: " + rest));
            try {
                return CashCurrencyPaymentModule.this.context.getServerConnector().acivateCashBackCard(this.pin, new Sum(), localMaxSum.sub(CashCurrencyPaymentModule.this.cbcKeeper.getSum()), SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            CashCurrencyPaymentModule.this.log.info((Object)("Result: " + object));
            String text = null;
            if (object instanceof ActivationResult) {
                ActivationResult ar = (ActivationResult)object;
                if (ar.getError() == ActivationResultType.Ok) {
                    CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
                    cbc.setNominal(ar.getRest());
                    cbc.setRef(ar.getIdOperation());
                    CashCurrencyPaymentModule.this.cbcKeeper.addCashBackCard(cbc);
                    CashCurrencyPaymentModule.this.enableCashManager(CashCurrencyPaymentModule.this.cbcKeeper);
                    CashCurrencyPaymentModule.this.cbcKeeper = null;
                    return;
                }
                text = B.get((String)("Request.cbc.err." + ar.getError()), (Locale)CashCurrencyPaymentModule.this.environment.getLocale());
            } else {
                text = B.get((String)("Request.cbc.err." + ActivationResultType.ErrNetwork), (Locale)CashCurrencyPaymentModule.this.environment.getLocale());
            }
            EventQueue.invokeLater(new DialogRunnable(text));
        }
    }

    private class LocalPinCodeListener
    implements CustomDialogListener {
        private LocalPinCodeListener() {
        }

        public void onClose(Object type) {
            ModuleHelper.invoke(CashCurrencyPaymentModule.this.cancelListener);
            if (type != null) {
                String pincode = (String)type;
                CashCurrencyPaymentModule.this.log.info((Object)("Input pincode: " + pincode));
                ModuleHelper.invoke(CashCurrencyPaymentModule.this.cancelListener);
                CashCurrencyPaymentModule.this.context.getTaskExecutor().execute(new PincodeActivator(pincode));
            } else {
                CashCurrencyPaymentModule.this.log.info((Object)"Close pincode screen");
                ModuleHelper.invoke(CashCurrencyPaymentModule.this.cancelListener);
                CashCurrencyPaymentModule.this.enableCashManager(CashCurrencyPaymentModule.this.cbcKeeper);
                CashCurrencyPaymentModule.this.cbcKeeper = null;
                CashCurrencyPaymentModule.this.context.getShell().showPopup(null);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            try {
                CashCurrencyPaymentModule.this.log.info((Object)("Action on sum screen: " + action));
                CashCurrencyPaymentModule.this.cancelListener = cancelListener;
                if (ActionType.isCbc((String)action)) {
                    CashCurrencyPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                    CashCurrencyPaymentModule.this.log.info((Object)("Keeper: " + CashCurrencyPaymentModule.this.cbcKeeper));
                    if (!CashMobuleHelper.isAllowCBC(CashCurrencyPaymentModule.this.service, !CashCurrencyPaymentModule.this.cbcKeeper.getCashSum().isEmpty())) {
                        CashCurrencyPaymentModule.this.log.info((Object)"CBC disable for this service ");
                        CashCurrencyPaymentModule.this.enableCashManager(CashCurrencyPaymentModule.this.cbcKeeper);
                        ModuleHelper.invoke(cancelListener);
                        return;
                    }
                    CashCurrencyPaymentModule.this.pinScreen.init(CashCurrencyPaymentModule.this.environment.getLocale());
                    CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)CashCurrencyPaymentModule.this.pinScreen, Math.min(40, CashCurrencyPaymentModule.this.getInactivityTimeout() - 5), null, true);
                    cpd.addListener((CustomDialogListener)new LocalPinCodeListener());
                    CashCurrencyPaymentModule.this.context.showDialog((DialogInterface)cpd);
                } else if (ActionType.isExit((String)action)) {
                    CashCurrencyPaymentModule.this.cancel(new ExitIntent(CashCurrencyPaymentModule.this.context, 2));
                } else if (ActionType.isPrev((String)action)) {
                    CashCurrencyPaymentModule.this.cancel(new BackIntent(CashCurrencyPaymentModule.this.environment.getInputModule()));
                } else if (ActionType.isNext((String)action)) {
                    CashCurrencyPaymentModule.this.process(CashManager.getDefaultInstance().disable(), UserCase.Ok, false);
                } else if (ActionType.isCommission((String)action)) {
                    if (CashCurrencyPaymentModule.this.commissionPanel == null) {
                        ModuleHelper.invoke(cancelListener);
                        return;
                    }
                    SumResult sr = CashCurrencyPaymentModule.this.payDetector.calculate(CashManager.getDefaultInstance().current());
                    HashMap<String, Object> dt = new HashMap<String, Object>();
                    dt.put("env", CashCurrencyPaymentModule.this.environment);
                    dt.put("sr", sr);
                    dt.put("pack", Session.getInstance().getPack());
                    if (CashManager.getDefaultInstance().current() != null) {
                        dt.put("keeper-sum", CashManager.getDefaultInstance().current().getSum());
                    }
                    dt.put("screen-data", data);
                    dt.put("pernumbers", ReferenceManager.getInstance().getPersonalNumbers(CashCurrencyPaymentModule.this.environment.getMenuItem().getService()));
                    CashCurrencyPaymentModule.this.commissionPanel.init(new CompleteInit(null, CashCurrencyPaymentModule.this.environment.getMenuItem().getService(), CashCurrencyPaymentModule.this.environment.getMenuItem().getCommission(), sr, dt, CashCurrencyPaymentModule.this.environment.getLocale(), CashCurrencyPaymentModule.this.environment.getDateOfStartPayment(), "CASH", CashCurrencyPaymentModule.this.environment.getMenuItem()));
                    CashCurrencyPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                    CustomPopupDialog dialog = new CustomPopupDialog((CustomPanel)CashCurrencyPaymentModule.this.commissionPanel, Math.min(30, CashCurrencyPaymentModule.this.getInactivityTimeout() - 5));
                    dialog.addListener((CustomDialogListener)new LocalPinCodeListener());
                    CashCurrencyPaymentModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    ProblemNotifier.getDefaultNotifier().onProblem("Unknown action on sumscreen: " + action);
                }
            }
            catch (Exception ex) {
                CashCurrencyPaymentModule.this.log.error((Object)ex.getMessage());
                CashCurrencyPaymentModule.this.log.error((Object)Arrays.toString(ex.getStackTrace()));
            }
        }
    }
}

