/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleCardWaitListener;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.OutCancelListener;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CardPaymentModule;
import ru.softlogic.module.payment.CashCurrencyPaymentModule;
import ru.softlogic.module.payment.CashPaymentModule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;

public class CashAndCardPaymentModule
extends CashPaymentModule {
    private BasePaymentModule cspm;
    private BasePaymentModule ccpm;
    private BasePaymentModule cardPM;
    private BasePaymentModule pm;
    private Logger log = Logger.getLogger((String)"pay");

    public CashAndCardPaymentModule(ApplicationContext context) {
        super(context);
        try {
            if (CardModuleStore.getInstance().isInit()) {
                this.cardPM = new CardPaymentModule(context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        this.environment = environment;
        this.sumScreen = sumScreen;
        Service service = Session.getInstance().getPack().getService();
        this.log.info((Object)"Start cash-and-card dispatcher paument module");
        this.cspm = ModuleFactory.createCashPaymentModule(this.context, environment.getMenuItem(), new CashPaymentModule(this.context));
        this.ccpm = ModuleFactory.createCashCurrencyPaymentModule(this.context, environment.getMenuItem(), new CashCurrencyPaymentModule(this.context));
        if (this.cardPM != null && (service.getPaymentSchemaFlags() & 4) > 0) {
            boolean sessionNotExist;
            CardModule currentSession = CardModuleStore.getInstance().getCurrentSession();
            boolean bl = sessionNotExist = currentSession == null;
            if (sessionNotExist) {
                try {
                    CardModuleStore.getInstance().openSession(new LocalGuiListener(this.context, environment, this.log));
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
            if (CardModuleStore.getInstance().getCurrentSession() != null) {
                CardModuleStore.getInstance().setOutCancelListener(new LocalOutCancelListener());
                CardModuleStore.getInstance().getCurrentSession().waitCard((CardModuleCardWaitListener)new LocalCardModuleCardDataListener());
            }
            if (sessionNotExist) {
                this.toCash(environment, sumScreen, new LocalKeeperObserver());
            }
        } else {
            this.toCash(environment, sumScreen, null);
        }
    }

    @Override
    public void startPaymentByCash(Environment environment, CommonSumScreen sumScreen) {
        this.toCash(environment, sumScreen, null);
    }

    private void toCash(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Service service;
        MenuItem mi = environment.getMenuItem();
        Service service2 = service = Session.getInstance().getPack().getService() == null ? mi.getService() : Session.getInstance().getPack().getService();
        if (service.getCurrencyCode() != null && !service.getCurrencyCode().isEmpty() && !CashFactory.getDefaultInstance().getCurrency().equals(service.getCurrencyCode())) {
            this.log.info((Object)"Dispathcher: open currency cash payment module");
            this.pm = this.ccpm;
            this.ccpm._startPayment(environment, sumScreen, externalObserver);
        } else {
            this.log.info((Object)"Dispathcher: open simple cash payment module");
            this.pm = this.cspm;
            this.cspm._startPayment(environment, sumScreen, externalObserver);
        }
    }

    @Override
    public void cancel(Intent intent) {
        this.pm.cancel(intent);
    }

    private class LocalKeeperObserver
    implements KeeperObserver {
        private LocalKeeperObserver() {
        }

        public void update(Keeper keeper, Sum sum) {
            try {
                if (keeper != null && !keeper.getSum().isEmpty() && CardModuleStore.getInstance().getCurrentSession() != null) {
                    CardModuleStore.getInstance().getCurrentSession().cancelOperation();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void notifyNoMoreNeed() {
        }
    }

    private class LocalOutCancelListener
    implements OutCancelListener {
        private LocalOutCancelListener() {
        }

        @Override
        public void cancel(Intent intent) {
            if (intent != null) {
                intent.process();
            }
            CardModuleStore.getInstance().getCurrentSession().cancelOperation();
        }
    }

    private class LocalCardModuleCardDataListener
    implements CardModuleCardWaitListener {
        private LocalCardModuleCardDataListener() {
        }

        public void onError(CardModuleError cme, String string) {
            CardModuleStore.getInstance().closeSessionSafe(true);
        }

        public void onCard() {
            if (CashAndCardPaymentModule.this.pm == null || CashAndCardPaymentModule.this.pm.cancelRequest()) {
                CashAndCardPaymentModule.this.cardPM._startPayment(CashAndCardPaymentModule.this.environment, CashAndCardPaymentModule.this.sumScreen, null);
            } else {
                CardModuleStore.getInstance().closeSessionSafe(true);
            }
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void onEvent(UserInterfaceEvent uie, Runnable r) {
            switch (uie) {
                case CARD_REQUIRE: {
                    UserAction.getInstance().update();
                    CashAndCardPaymentModule.this.log.info((Object)">>>onCardRequire");
                    ModuleHelper.invoke(r);
                    return;
                }
                case SESSION_CLOSED: {
                    UserAction.getInstance().update();
                    CashAndCardPaymentModule.this.log.info((Object)"SESSION_CLOSED");
                    ModuleHelper.invoke(r);
                    return;
                }
            }
            super.onEvent(uie, r);
        }

        @Override
        public synchronized void _onClosed() {
        }
    }
}

