/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.Currency;
import ru.softlogic.cards.v2.connector.model.OperationResult;
import ru.softlogic.cards.v2.connector.model.OperationTransferResult;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.CardPaymentModule;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.service.comission.SumResult;

public class CardTransferPaymentModule
extends CardPaymentModule {
    private static final Logger log = Logger.getLogger((String)"pay");
    private Sum sumIncome;
    private Sum sumOutcome;
    private LocalGuiListener guiListener;

    public CardTransferPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startPayment(final Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        this.guiListener = new LocalGuiListener(this.context, environment, log);
        CardModuleStore cmStore = CardModuleStore.getInstance();
        cmStore.setUserEventInterfaceListener(this.guiListener);
        Pack pack = Session.getInstance().getPack();
        Map<String, Object> initData = environment.getInitData();
        OperationTransferResult result = (OperationTransferResult)initData.remove("TRANSFER_RESUALT");
        CardInfo ci = (CardInfo)initData.remove("CARD_INFO");
        this.sumIncome = (Sum)initData.remove("SUM_INCOME");
        this.sumOutcome = (Sum)initData.remove("SUM_OUTCOME");
        Payment p = (Payment)pack.getPayments().get(0);
        Amount acquireFee = result.getAcquireFee();
        if (acquireFee != null && acquireFee.getValue() != 0L) {
            Currency currency = acquireFee.getCurrency();
            InputElement ieAcquireFee = new InputElement("acquireFee", B.get((String)"Module.card.deposit.fee.title", (Locale)environment.getLocale()), SumFormatter.format((long)acquireFee.getValue()) + " " + B.get((String)("Module.card.currency.code." + currency), (Locale)environment.getLocale(), (String)(currency == null ? "" : currency.getAlphaCode())));
            p.getData().put("acquireFee", ieAcquireFee);
        }
        UserAction.getInstance().update();
        this.context.showWait(null);
        Keeper keeper = new Keeper();
        if (pack.getKeeper() != null) {
            keeper = pack.getKeeper();
        }
        keeper.addPayback(this.sumIncome);
        ServiceZReportStorage.getInstance().getCurrentSnapshot().addZCashlessSum(this.sumIncome);
        p.setSumOut(this.sumOutcome);
        this.fillCardInfo(p.getData(), (OperationResult)result, ci, environment.getLocale());
        InputElement recipientPan = new InputElement("id1", B.get((String)"Module.card.recipient", (Locale)environment.getLocale(), (String)"recipient-pan"), result.getPanRecipient());
        p.getData().put("recipient-pan", recipientPan);
        pack.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), this.sumOutcome, this.sumOutcome, this.sumIncome.sub(this.sumOutcome), keeper.getSum().sub(this.sumIncome), pack.getProviderFee(), null));
        pack.setKeeper(keeper);
        pack.setPaymentTool(ci.isIinCard() ? 2 : 3);
        pack.setCashlessData(new CashlessData(ci.getPan(), ci.getCardholderName() == null ? "-" : ci.getCardholderName(), "" + environment.getPoint().getId(), "", "", "", result.getRrn(), result.getAuthIdentResponse()));
        if (ModuleHelper.isCardRevert()) {
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    environment.getProcessingModule().process(environment);
                    return null;
                }
            });
        } else {
            Intent i = new Intent(){

                @Override
                public void process() {
                    environment.getProcessingModule().process(environment);
                }

                @Override
                public int getType() {
                    return 1;
                }
            };
            this.guiListener.setIntent(i);
            CardModuleStore.getInstance().closeSessionSafe(true);
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private Intent intent;

        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        public void setIntent(Intent intent) {
            this.intent = intent;
        }

        @Override
        public synchronized void _onClosed() {
            Intent i = this.intent;
            if (i == null) {
                i = new ExitIntent(CardTransferPaymentModule.this.context);
            }
            i.process();
            this.intent = null;
        }
    }
}

