/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.module.Module;
import ru.softlogic.module.TimeoutManager;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;

public abstract class BasePaymentModule
implements Module,
PaymentModule {
    protected ApplicationContext context;
    protected Environment environment;

    public BasePaymentModule(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public int getInactivityTimeout() {
        return TimeoutManager.getInstance().getTimeout(this.getType());
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final void startPayment(Environment environment, CommonSumScreen sumScreen) {
        LoggerId.PAY.info((Object)B.get((String)"Module.payment", (Locale)environment.getLocale()));
        this.context.setModule(this);
        Session.getInstance().setPaymentAddedToQueue(false);
        Service service = environment.getMenuItem().getService();
        if (service.isSendZeroAmount()) {
            LoggerId.PAY.info((Object)B.get((String)"Module.payment.sendzeroamount", (Locale)environment.getLocale()));
            Pack pack = Session.getInstance().getPack();
            if (pack.getKeeper() == null) {
                pack.setKeeper(new Keeper());
            }
            pack.setZeroAmount(true);
            environment.getProcessingModule().process(environment);
        } else {
            this._startPayment(environment, sumScreen, null);
        }
    }

    @Override
    public void startPaymentByCash(Environment environment, CommonSumScreen sumScreen) {
    }

    protected abstract void _startPayment(Environment var1, CommonSumScreen var2, KeeperObserver var3);

    protected void startPayout(Environment environment) {
        environment.getPayoutModule().startPayout(environment);
    }

    @Override
    public boolean cancelRequest() {
        return false;
    }

    public boolean canRedirect() {
        Logger log = LoggerId.PAY;
        log.info((Object)"BasePaymentModule: canRedirect: false");
        return false;
    }

    protected void _redirect(int serviceId) {
        Logger log = LoggerId.PAY;
        if (!this.canRedirect()) {
            log.info((Object)"Redirect is disable. CashKeeper is not empty");
            return;
        }
        log.info((Object)("Requested redirect to service: " + serviceId));
        if (this.environment != null && this.environment.getRedirectProxy() != null) {
            this.environment.getRedirectProxy().redirect(serviceId, null);
        } else {
            MenuItem mi = null;
            try {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId, AppDefaults.getInstance().getBooleanProperty("Module.input.redirect.childs", true));
                MenuUtils.processMenu((MenuVisitor)mbsiv);
                mi = mbsiv.getMenuItem();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            if (mi != null) {
                log.info((Object)("Found service: " + mi.getService().getName()));
                Keeper k = Session.getInstance().getPack().getKeeper();
                log.info((Object)("Redirect with keeper: " + k));
                AppEnvironment.getInstance().open(mi, null);
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Redirect to service " + serviceId + " not found");
                log.info((Object)"Service not found, show dialog");
                Locale locale = this.environment != null ? this.environment.getLocale() : null;
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.redirect.notfound", (Locale)locale), 10, DC.cases((int)8, (Locale)locale, (Object[])new Object[0]), UserCase.Ok);
                this.context.showDialog((DialogInterface)dialog);
            }
        }
    }
}

