/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.lock;

import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.ContentScreen;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.lock.LockScreen;
import ru.softlogic.gui.screen.popup.lock.LockScreenClick;
import ru.softlogic.gui.screen.popup.lock.LockScreenListener;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.custom.ComplexLockScreen;
import ru.softlogic.gui2.screen.custom.LockScreenInit;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.lock.BaseLockModule;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;

public class GuiLockModule
extends BaseLockModule {
    private LockScreenClick[] clicks;
    private int index;
    private ComplexLockScreen screen = ComponentFactory.getInstance().createLockScreen();
    private LockScreenListener lockScreenListener;
    private Logger log;

    public GuiLockModule(ApplicationContext context) {
        super(context);
        this.clicks = new LockScreenClick[4];
        for (int i = 0; i < 4; ++i) {
            this.clicks[i] = new LockScreenClick(0);
        }
        this.lockScreenListener = new LocalLockScreenListener();
        this.log = Logger.getLogger((String)"gui");
    }

    @Override
    public void _start(Locale locale, Dealer dealer, Point point, TerminalState ts) {
        LockScreenInit init = new LockScreenInit(Locale.getDefault(), dealer, point, Integer.toString(ts.getErrorCode()));
        LockScreen ls = this.screen.init(init);
        this.context.showScreen((ContentScreen)this.screen);
        if (ls != null) {
            ls.setListener(this.lockScreenListener);
            this.context.getShell().showPopup((PopupScreen)ls);
        } else {
            ModuleHelper.showModuleErrorDialog(this.context, 20, B.get((String)"Module.entry.create.lock"), DC.cases((int)1));
        }
    }

    private class LocalLockScreenListener
    implements LockScreenListener {
        private LocalLockScreenListener() {
        }

        public void onAreaClick(LockScreenClick lsc) {
            UserAction.getInstance().update();
            ((GuiLockModule)GuiLockModule.this).clicks[((GuiLockModule)GuiLockModule.this).index] = lsc;
            int sum = 0;
            for (int i = 0; i < 4; ++i) {
                int j = GuiLockModule.this.index - i;
                if (j < 0) {
                    j = 4 + j;
                }
                sum = (int)((double)sum + (double)GuiLockModule.this.clicks[j].getAreaId() * Math.pow(10.0, i));
            }
            GuiLockModule.this.index = (GuiLockModule.this.index + 1) % 4;
            if (sum == 1643) {
                GuiLockModule.this.log.info((Object)"Unlock screen");
                GuiLockModule.this.context.getShell().showPopup(null);
                AppEnvironment.getInstance().open(ProviderType.AdminProvider);
            } else {
                GuiLockModule.this.log.error((Object)("wrong code: " + sum));
            }
        }
    }
}

