/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.template;

import i18n.B;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.template.OnlineRequest;
import ru.softlogic.module.input.template.RequestResultListener;
import ru.softlogic.module.input.template.TemplateModuleListener;
import ru.softlogic.module.input.template.UtilityHelper;
import ru.softlogic.reference.menu.MenuItem;

public class TemplateModule
implements Restorable {
    private static final String SCREEN_CHOOSE_TEMPLATE_ID = "choose-template";
    private static final String SCREEN_LOGIN_ID = "login";
    private static final String SCREEN_PASSWORD_ID = "password";
    private static final String SCREEN_LOGIN_PASSWORD_ID = "login-password";
    private static final String SCREEN_TEMPLATES = "templates";
    private static final String SCREEN_LOGIN_SAVE_COMPLEX = "login-save-complex";
    private static final String SCREEN_LOGIN_SAVE = "login-save";
    private static final String SCREEN_NAME_SAVE = "name-save";
    private static final String LOGIN_FIELD = "keeper.login";
    private static final String PWD_FIELD = "keeper.password";
    private static final String TEMPLATE_NAME_FIELD = "keeper.template.name";
    private static final String CHOOSE_TEMPLATE = "choose-template";
    private ApplicationContext context;
    private Environment env;
    private TemplateModuleListener listener;
    private TemplateModuleListener finalListener;
    private UtilityHelper utilityHelper = new UtilityHelper("templates");
    private Map<String, Object> data;
    private Logger log = Logger.getLogger((String)"pay");
    private ChooseTemplateScreenListener chooseTemplateScreenListener;
    private LoginAndPasswordScreenListener loginAndPasswordScreenListener;
    private PasswordScreenListener passwordScreenListener;
    private TemplatesScreenListener templatesScreenListener;
    private NameSaveScreenListener nameSaveScreenListener;
    private NestedData nestedData;
    private RestorePoint lastScreen;
    private boolean templateChooseDialog;
    private boolean active;
    private boolean isAddTemplateAfterNewPay;
    private boolean isLoginFieldInContext;
    private boolean skipNameSaveScreen;

    public void init(ApplicationContext context, Environment env) {
        this.context = context;
        this.env = env;
        this.data = new HashMap<String, Object>();
        this.nestedData = null;
        this.lastScreen = null;
    }

    public void start(TemplateModuleListener listener) {
        this.listener = listener;
        this.chooseTemplateScreenListener = new ChooseTemplateScreenListener(this.context);
        this.chooseTemplateScreenListener.setEnvironment(this.env);
        this.loginAndPasswordScreenListener = new LoginAndPasswordScreenListener(this.context);
        this.loginAndPasswordScreenListener.setEnvironment(this.env);
        this.passwordScreenListener = new PasswordScreenListener(this.context);
        this.passwordScreenListener.setEnvironment(this.env);
        this.templatesScreenListener = new TemplatesScreenListener(this.context);
        this.templatesScreenListener.setEnvironment(this.env);
        this.nameSaveScreenListener = new NameSaveScreenListener(this.context);
        this.nameSaveScreenListener.setEnvironment(this.env);
        this.templateChooseDialog = AppDefaults.getInstance().getBooleanProperty("Module.input.template.choose.dialog", true);
        this.active = true;
        this.isAddTemplateAfterNewPay = true;
        this.isLoginFieldInContext = false;
        this.skipNameSaveScreen = false;
        this.chooseTemplate();
    }

    private Object firstKeySkipLoginScreen(Map<String, Object> contextData, String keys) {
        if (keys != null && !contextData.keySet().isEmpty() && !contextData.containsKey(LOGIN_FIELD)) {
            String[] keySet;
            for (String key : keySet = keys.split(";")) {
                if (contextData.get(key) == null) continue;
                InputElement ie = (InputElement)contextData.get(key);
                this.isLoginFieldInContext = true;
                return new InputElement(LOGIN_FIELD, ie.getKeyTitle(), ie.getKeyTitleId(), ie.getOriginalValue(), ie.getValue(), ie.getValueTitle(), ie.getFlags());
            }
        }
        if (contextData.get(LOGIN_FIELD) != null) {
            this.isLoginFieldInContext = true;
        }
        return contextData.get(LOGIN_FIELD);
    }

    public void save(Map<String, Object> contextData, TemplateModuleListener listener) {
        this.finalListener = listener;
        if (this.data.get(LOGIN_FIELD) == null) {
            this.data.put(LOGIN_FIELD, this.firstKeySkipLoginScreen(contextData, AppDefaults.getInstance().getStringValue("Module.input.template.skip.enter.login.keys")));
        }
        if (contextData.get(TEMPLATE_NAME_FIELD) == null && contextData.get("#title") != null) {
            this.skipNameSaveScreen = true;
            this.data.put(TEMPLATE_NAME_FIELD, contextData.get("#title"));
        }
        if (AppDefaults.getInstance().getBooleanProperty("Module.input.template.save.complex", false)) {
            if (this.data.get(LOGIN_FIELD) != null && (this.data.get(TEMPLATE_NAME_FIELD) != null || this.skipNameSaveScreen)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(LOGIN_FIELD, this.data.get(LOGIN_FIELD));
                listener.onResult(map);
            } else {
                this.inputLoginSaveComplex();
            }
        } else if (this.data.get(LOGIN_FIELD) != null && (this.isLoginFieldInContext || !this.isAddTemplateAfterNewPay)) {
            if (this.data.get(TEMPLATE_NAME_FIELD) == null || !this.skipNameSaveScreen) {
                this.inputTemplateNameSave();
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(LOGIN_FIELD, this.data.get(LOGIN_FIELD));
                listener.onResult(map);
            }
        } else {
            this.inputLoginSave();
        }
    }

    private void chooseTemplate() {
        if (this.templateChooseDialog) {
            this.log.info((Object)"Show choose template dialog");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.input.template.choose", (Locale)this.env.getLocale()), 20, DC.cases((int)24, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    TemplateModule.this.isAddTemplateAfterNewPay = userCase != UserCase.Ok;
                    if (userCase == UserCase.Ok) {
                        if (AppDefaults.getInstance().getBooleanProperty("Module.input.template.login.complex", false)) {
                            TemplateModule.this.inputLoginAndPassword();
                        } else {
                            TemplateModule.this.inputLogin();
                        }
                    } else {
                        TemplateModule.this.data.clear();
                        TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
                    }
                }
            });
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this.log.info((Object)"Show choose template screen");
            this.chooseTemplateScreen();
        }
    }

    public void showChooseTemplateScreen() {
        this.chooseTemplateScreen();
    }

    private void chooseTemplateScreen() {
        try {
            ScreenDescription sd = this.getScreenDescription("choose-template");
            this.showScreen(sd, (ScreenListener)this.chooseTemplateScreenListener, true);
            this.lastScreen = RestorePoint.CHOOSE_TEMPLATE;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputLoginAndPassword() {
        try {
            ScreenDescription sd = this.getScreenDescription(SCREEN_LOGIN_PASSWORD_ID);
            this.showScreen(sd, (ScreenListener)this.loginAndPasswordScreenListener, true);
            this.lastScreen = RestorePoint.LOGIN_PASSWORD;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputLogin() {
        try {
            ScreenDescription sd = this.getScreenDescription(SCREEN_LOGIN_ID);
            LoginScreenListener listener = new LoginScreenListener(this.context);
            listener.setEnvironment(this.env);
            this.showScreen(sd, (ScreenListener)listener, true);
            this.lastScreen = RestorePoint.LOGIN;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputPassword() {
        try {
            ScreenDescription sd = this.getScreenDescription(SCREEN_PASSWORD_ID);
            this.showScreen(sd, (ScreenListener)this.passwordScreenListener, true);
            this.lastScreen = RestorePoint.PASSWORD;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void selectTemplate(NestedData nd) {
        try {
            Session.getInstance().getPaymentTemplateState().setSkipInput(false);
            this.data.put(nd.getId(), nd.getData());
            ScreenDescription sd = this.getScreenDescription(SCREEN_TEMPLATES);
            this.showScreen(sd, (ScreenListener)this.templatesScreenListener, true, true);
            this.lastScreen = RestorePoint.TEMPLATES;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputLoginSaveComplex() {
        try {
            ScreenDescription sd = this.getScreenDescription(SCREEN_LOGIN_SAVE_COMPLEX);
            LoginSaveComplexScreenListener saveComplexListener = new LoginSaveComplexScreenListener(this.context);
            saveComplexListener.setEnvironment(this.env);
            this.showScreen(sd, (ScreenListener)saveComplexListener, true);
            this.lastScreen = RestorePoint.LOGIN_SAVE_COMPLEX;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputLoginSave() {
        try {
            ScreenDescription sd = this.getScreenDescription(SCREEN_LOGIN_SAVE);
            LoginSaveScreenListener listener = new LoginSaveScreenListener(this.context);
            listener.setEnvironment(this.env);
            this.showScreen(sd, (ScreenListener)listener, true);
            this.lastScreen = RestorePoint.LOGIN_SAVE;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void inputTemplateNameSave() {
        try {
            if (AppDefaults.getInstance().getBooleanProperty("Module.input.template.namescreen.skip", false)) {
                this.nameSaveScreenListener._onAction("Next", this.data, null);
            } else {
                ScreenDescription sd = this.getScreenDescription(SCREEN_NAME_SAVE);
                this.showScreen(sd, (ScreenListener)this.nameSaveScreenListener, true);
            }
            this.lastScreen = RestorePoint.NAME_SAVE;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
            this.data.clear();
            this.listener.onResult(Collections.EMPTY_MAP);
        }
    }

    private void showScreen(ScreenDescription sd, ScreenListener listener, boolean canBack) throws InitException {
        this.showScreen(sd, listener, canBack, false);
    }

    private void showScreen(ScreenDescription sd, ScreenListener listener, boolean canBack, boolean withDecor) throws InitException {
        CommonScreen cs;
        this.log.info((Object)(">>>>>>" + sd.getType() + "," + sd.getTitle()));
        CommonScreen commonScreen = cs = withDecor ? CommonScreenStore.getScreen((String)sd.getType(), (String)sd.getDecor()) : CommonScreenStore.getScreen((String)sd.getType());
        if (cs == null) {
            throw new InitException("Can't get screen type: " + sd.getType());
        }
        cs.setListener(listener);
        cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)canBack), InitModuleHelper.buildScreenInit(this.env, this.data));
        this.context.showScreen(new ContentScreenAdapterKbr(cs));
    }

    private ScreenDescription getScreenDescription(String id) throws Exception {
        Scenario s = this.utilityHelper.getScenario(this.env.getLocale());
        AdvancedScreenDescription asd = s.getScreenById(id);
        ScreenDescription sd = asd.getDescription();
        this.processButtons(sd, asd.getActionMap());
        return sd;
    }

    private ScreenDescription processButtons(ScreenDescription sd, ActionMap map) {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        for (Action a : map.getActions()) {
            buttons.put(a.getType(), new ButtonInit(a.getTitle()));
        }
        sd.setButtons(buttons);
        return sd;
    }

    public void clearData(Map<String, Object> dataContext) {
    }

    public void redirect(int serviceId, Map<String, Object> customData) {
        Keeper current = CashManager.getDefaultInstance().current();
        this.log.info((Object)"canRedirect: Request for permission to redirect from PaymentModule");
        if (current == null || current.getSum().isEmpty()) {
            this.log.info((Object)"canRedirect: Keeper is empty.");
            MenuItem mi = null;
            try {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId, AppDefaults.getInstance().getBooleanProperty("Module.input.redirect.childs", true));
                MenuUtils.processMenu((MenuVisitor)mbsiv);
                mi = mbsiv.getMenuItem();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            if (mi != null) {
                this.log.info((Object)("Found service: " + mi.getService().getName()));
                if (customData != null) {
                    AppEnvironment.getInstance().open(mi, customData);
                } else {
                    AppEnvironment.getInstance().open(mi);
                }
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Redirect to service " + serviceId + " not found");
                this.log.info((Object)"Service not found, show dialog");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.redirect.notfound", (Locale)this.env.getLocale()), 10, DC.cases((int)8, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                this.context.showDialog((DialogInterface)dialog);
            }
        } else {
            this.log.info((Object)"canRedirect: Current keeper is not empty. Skip redirect");
        }
    }

    public void redirect(int serviceId) {
        this.redirect(serviceId, null);
    }

    @Override
    public void restore() {
        this.active = true;
        if (this.lastScreen != null) {
            switch (this.lastScreen) {
                case CHOOSE_TEMPLATE: {
                    this.chooseTemplateScreen();
                    return;
                }
                case LOGIN: {
                    this.inputLogin();
                    return;
                }
                case PASSWORD: {
                    this.inputPassword();
                    return;
                }
                case LOGIN_PASSWORD: {
                    this.inputLoginAndPassword();
                    return;
                }
                case TEMPLATES: {
                    if (this.nestedData != null) {
                        this.selectTemplate(this.nestedData);
                    } else {
                        this.context.toMainMenu();
                    }
                    return;
                }
                case LOGIN_SAVE_COMPLEX: {
                    this.inputLoginSaveComplex();
                    return;
                }
                case LOGIN_SAVE: {
                    this.inputLoginSave();
                    return;
                }
                case NAME_SAVE: {
                    this.inputTemplateNameSave();
                    return;
                }
            }
        }
        if (this.templateChooseDialog) {
            this.active = true;
            this.listener.onRestore();
        } else {
            this.context.toMainMenu();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private class NameSaveScreenListener
    extends ComplexScreenListener {
        public NameSaveScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> localData, Runnable cancelListener) {
            TemplateModule.this.skipNameSaveScreen = false;
            if (ActionType.isNext((String)action)) {
                TemplateModule.this.data.putAll(localData);
                TemplateModule.this.active = true;
                localData.put(TemplateModule.LOGIN_FIELD, TemplateModule.this.data.get(TemplateModule.LOGIN_FIELD));
                TemplateModule.this.finalListener.onResult(localData);
            } else if (ActionType.isPrev((String)action)) {
                if (TemplateModule.this.data.get(TemplateModule.LOGIN_FIELD) != null && (TemplateModule.this.isLoginFieldInContext || !TemplateModule.this.isAddTemplateAfterNewPay)) {
                    TemplateModule.this.lastScreen = RestorePoint.TEMPLATES;
                    TemplateModule.this.finalListener.onRestore();
                    ModuleHelper.invoke(cancelListener);
                } else {
                    TemplateModule.this.inputLoginSave();
                }
            } else if (ActionType.isExit((String)action)) {
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onCancel();
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.data.clear();
                TemplateModule.this.finalListener.onResult(Collections.EMPTY_MAP);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class LoginSaveScreenListener
    extends ComplexScreenListener {
        public LoginSaveScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                TemplateModule.this.data.putAll(data);
                TemplateModule.this.inputTemplateNameSave();
            } else if (ActionType.isPrev((String)action)) {
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onRestore();
                ModuleHelper.invoke(cancelListener);
            } else if (ActionType.isExit((String)action)) {
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onCancel();
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.data.clear();
                TemplateModule.this.finalListener.onResult(Collections.EMPTY_MAP);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class LoginSaveComplexScreenListener
    extends ComplexScreenListener {
        public LoginSaveComplexScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                TemplateModule.this.data.putAll(data);
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onResult(data);
            } else if (ActionType.isPrev((String)action)) {
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onRestore();
                ModuleHelper.invoke(cancelListener);
            } else if (ActionType.isExit((String)action)) {
                TemplateModule.this.active = true;
                TemplateModule.this.finalListener.onCancel();
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.data.clear();
                TemplateModule.this.finalListener.onResult(Collections.EMPTY_MAP);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class TemplatesScreenListener
    extends ComplexScreenListener {
        public TemplatesScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ModuleHelper.invoke(cancelListener);
            if (ActionType.isNext((String)action)) {
                Session.getInstance().getPaymentTemplateState().setSkipInput(data.get("template-id") != null);
                TemplateModule.this.listener.onResult(data);
            } else if (ActionType.isPrev((String)action)) {
                if (AppDefaults.getInstance().getBooleanProperty("Module.input.template.login.complex", false)) {
                    TemplateModule.this.inputLoginAndPassword();
                } else {
                    TemplateModule.this.inputPassword();
                }
            } else if ("Redirect".equalsIgnoreCase(action)) {
                Session.getInstance().getPaymentTemplateState().setSkipInput(true);
                Object serviceObject = data.get("#service-id");
                if (serviceObject instanceof Integer) {
                    TemplateModule.this.redirect((Integer)serviceObject, data);
                } else {
                    TemplateModule.this.log.error((Object)"#service-id is not String or Integer");
                }
            } else if (ActionType.isExit((String)action)) {
                TemplateModule.this.listener.onMainMenu();
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class LoginScreenListener
    extends ComplexScreenListener {
        public LoginScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                TemplateModule.this.data.putAll(data);
                TemplateModule.this.inputPassword();
            } else if (ActionType.isPrev((String)action)) {
                if (TemplateModule.this.templateChooseDialog) {
                    TemplateModule.this.lastScreen = null;
                    TemplateModule.this.listener.onRestore();
                } else {
                    TemplateModule.this.chooseTemplateScreen();
                }
                ModuleHelper.invoke(cancelListener);
            } else if (ActionType.isExit((String)action)) {
                TemplateModule.this.lastScreen = null;
                TemplateModule.this.listener.onRestore();
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.data.clear();
                TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class PasswordScreenListener
    extends LoginAndPasswordScreenListener {
        public PasswordScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            if (ActionType.isPrev((String)action)) {
                TemplateModule.this.inputLogin();
            } else if (ActionType.isPinRestore((String)action)) {
                TemplateModule.this.data.putAll(data);
                final DialogListener dialogListener = new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        ModuleHelper.invoke(cancelListener);
                    }
                };
                TemplateModule.this.context.getTaskExecutor().execute(new OnlineRequest(TemplateModule.this.context, (short)TemplateModule.this.env.getMenuItem().getService().getId(), "pin-recover", StoreHelper.convertD((Map)TemplateModule.this.data), TemplateModule.this.env.getLocale(), new RequestResultListener(){

                    @Override
                    public void onResult(int serverError, int serviceError, Data result) {
                        TemplateModule.this.log.info((Object)("Request result: " + serverError + " " + serviceError + " " + result));
                        String resultString = B.get((String)(serverError == 0 && serviceError == 0 ? "Module.input.template.restore.pin.success" : "Module.input.template.restore.pin.error"), (Locale)TemplateModule.this.env.getLocale());
                        DialogScreen ds = ComponentFactory.getInstance().createDialog(serverError == 0 && serviceError == 0 ? DialogType.Info : DialogType.Error, resultString, 10, DC.cases((int)8, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                        ds.addListener(dialogListener);
                        TemplateModule.this.context.showDialog((DialogInterface)ds);
                    }

                    @Override
                    public void onException(Exception ex) {
                        TemplateModule.this.log.error((Object)ex, (Throwable)ex);
                        DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.template.restore.pin.other.error", (Locale)TemplateModule.this.env.getLocale()), 10, DC.cases((int)8, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                        ds.addListener(dialogListener);
                        TemplateModule.this.context.showDialog((DialogInterface)ds);
                    }
                }));
            } else {
                super._onAction(action, data, cancelListener);
            }
        }

        @Override
        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class LoginAndPasswordScreenListener
    extends ComplexScreenListener {
        public LoginAndPasswordScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                TemplateModule.this.data.putAll(data);
                TemplateModule.this.log.info((Object)("Start request: " + TemplateModule.this.data));
                TemplateModule.this.context.getTaskExecutor().execute(new OnlineRequest(TemplateModule.this.context, (short)TemplateModule.this.env.getMenuItem().getService().getId(), TemplateModule.SCREEN_LOGIN_ID, StoreHelper.convertD((Map)TemplateModule.this.data), TemplateModule.this.env.getLocale(), new RequestResultListener(){

                    @Override
                    public void onResult(final int serverError, int serviceError, Data result) {
                        TemplateModule.this.log.info((Object)("Request result: " + serverError + " " + serviceError + " " + result));
                        if (serverError == 0 && serviceError == 0 && result.getNestedData() != null) {
                            TemplateModule.this.nestedData = result.getNestedData();
                            TemplateModule.this.selectTemplate(result.getNestedData());
                        } else {
                            String message = B.get((String)"Module.input.template.no-templates", (Locale)TemplateModule.this.env.getLocale());
                            DisplayedUserCase[] cases = DC.cases((int)24, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]);
                            UserCase defaultUC = UserCase.Ok;
                            if (serverError == 1 || serviceError == 1) {
                                message = B.get((String)"Module.input.template.login.error", (Locale)TemplateModule.this.env.getLocale());
                                cases = DC.cases((int)23, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]);
                                defaultUC = UserCase.Cancel;
                                if (serverError == 1) {
                                    cases = DC.cases((int)36, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]);
                                    message = B.get((String)"Module.input.template.error", (Locale)TemplateModule.this.env.getLocale());
                                }
                            }
                            DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 10, cases, defaultUC);
                            ds.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    if (userCase == UserCase.Ok) {
                                        TemplateModule.this.data.clear();
                                        TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
                                    } else {
                                        if (serverError == 1) {
                                            TemplateModule.this.lastScreen = null;
                                            TemplateModule.this.listener.onMainMenu();
                                        }
                                        ModuleHelper.invoke(cancelListener);
                                    }
                                }
                            });
                            TemplateModule.this.context.showDialog((DialogInterface)ds);
                        }
                    }

                    @Override
                    public void onException(Exception ex) {
                        TemplateModule.this.log.error((Object)ex, (Throwable)ex);
                        ProblemNotifier.getDefaultNotifier().onProblemOnce("Templates " + ex.getMessage());
                        DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.template.error", (Locale)TemplateModule.this.env.getLocale()), 10, DC.cases((int)36, (Locale)TemplateModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                        ds.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                if (userCase == UserCase.Ok) {
                                    TemplateModule.this.data.clear();
                                    TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
                                } else {
                                    TemplateModule.this.lastScreen = null;
                                    TemplateModule.this.listener.onMainMenu();
                                    ModuleHelper.invoke(cancelListener);
                                }
                            }
                        });
                        TemplateModule.this.context.showDialog((DialogInterface)ds);
                    }
                }));
            } else if (ActionType.isPrev((String)action)) {
                if (TemplateModule.this.templateChooseDialog) {
                    TemplateModule.this.lastScreen = null;
                    TemplateModule.this.listener.onRestore();
                } else {
                    TemplateModule.this.chooseTemplateScreen();
                }
                ModuleHelper.invoke(cancelListener);
            } else {
                TemplateModule.this.data.clear();
                TemplateModule.this.listener.onCancel();
                ModuleHelper.invoke(cancelListener);
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private class ChooseTemplateScreenListener
    extends ComplexScreenListener {
        public ChooseTemplateScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                Object obj;
                if (data != null && (obj = data.get("choose-template")) instanceof InputElement) {
                    InputElement ie = (InputElement)obj;
                    if ("0".equals(ie.getValue())) {
                        TemplateModule.this.isAddTemplateAfterNewPay = false;
                        if (AppDefaults.getInstance().getBooleanProperty("Module.input.template.login.complex", false)) {
                            TemplateModule.this.inputLoginAndPassword();
                        } else {
                            TemplateModule.this.inputLogin();
                        }
                    } else {
                        if ("1".equals(ie.getValue())) {
                            TemplateModule.this.data.clear();
                            TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
                            return;
                        }
                        if ("2".equals(ie.getValue())) {
                            TemplateModule.this.listener.onCalculate();
                        }
                    }
                }
            } else {
                if (ActionType.isPrev((String)action)) {
                    TemplateModule.this.listener.onRestore();
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                if (ActionType.isExit((String)action)) {
                    TemplateModule.this.listener.onMainMenu();
                    ModuleHelper.invoke(cancelListener);
                } else if (ActionType.isEdit((String)action)) {
                    cancelListener.run();
                    TemplateModule.this.listener.onOffer();
                } else {
                    TemplateModule.this.data.clear();
                    TemplateModule.this.listener.onResult(Collections.EMPTY_MAP);
                }
            }
        }

        public void onRedirect(int serviceId) {
            TemplateModule.this.redirect(serviceId);
        }
    }

    private static enum RestorePoint {
        CHOOSE_TEMPLATE,
        LOGIN,
        PASSWORD,
        LOGIN_PASSWORD,
        TEMPLATES,
        LOGIN_SAVE_COMPLEX,
        LOGIN_SAVE,
        NAME_SAVE;

    }
}

