/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.site;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.advanced.PrinterAdapter;
import ru.softlogic.provider.ProviderType;

public class LocalSiteInputModule
extends BaseInputModule {
    private PrinterAdapter printer;

    public LocalSiteInputModule(ApplicationContext context) {
        super(context);
        this.printer = new PrinterAdapter(context.getPrinterQueue());
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        try {
            CommonScreen cs = CommonScreenStore.getScreen((String)"site-provider");
            cs.init(new ScreenDescription(), InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
            cs.setListener((ScreenListener)new LocalScreenListener());
            this.context.showScreen(new ContentScreenAdapter(cs));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                if (data.get("template") != null) {
                    String template = (String)data.get("template");
                    LocalSiteInputModule.this.printer.printCustom(template, new HashMap<String, Object>());
                } else if (data.get("redirect") != null) {
                    String redirect = (String)data.get("redirect");
                    if (redirect.trim().matches("^\\d+$")) {
                        try {
                            LocalSiteInputModule.this._redirect(Integer.parseInt(redirect));
                        }
                        catch (Exception ex) {
                            LocalSiteInputModule.this.log.error((Object)ex);
                        }
                    } else {
                        try {
                            AppEnvironment.getInstance().open(ProviderType.valueOf((String)redirect));
                        }
                        catch (Exception ex) {
                            LocalSiteInputModule.this.log.error((Object)ex);
                        }
                    }
                }
            } else if ("Prev".equals(action)) {
                LocalSiteInputModule.this.back();
            } else {
                LocalSiteInputModule.this.cancel(null);
            }
        }
    }
}

