/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.promo;

import i18n.B;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.module.utils.CancelDialogListener;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.UsersUtil;

public class PromoInputModule
extends BaseInputModule {
    private Environment environment;

    public PromoInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        try {
            Form f = FormHelper.parseCustom(new File(PathUtils.getAppHome() + "/resources/utility/promo.xml"), environment.getLocale());
            if (f.getScreenSequence().getScreens().size() != 1) {
                throw new ParseException("Wrong number of screens");
            }
            CommonScreen cs = CommonScreenStore.getScreen((String)"letter");
            cs.init(ScreenHelper.processBack((ScreenDescription)((ScreenDescription)f.getScreenSequence().getScreens().get(0)), (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
            cs.setListener((ScreenListener)new LocalScreenListener());
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
        catch (ParseException ex) {
            throw new DescriptionException(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                InputElement login = (InputElement)data.get("login");
                InputElement password = (InputElement)data.get("password");
                ServerUser su = UsersUtil.authentication(login.getValue(), password.getValue());
                if (su != null && "PROMOTER".equals(su.getRole())) {
                    PromoInputModule.this.context.getServerConnector().sendEvent(new Event(EventType.PromoterControl, "login=" + su.getLogin() + ", fio=" + su.getFio()));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.promo.success", (Locale)PromoInputModule.this.environment.getLocale()), 10, DC.cases((int)8, (Locale)PromoInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(PromoInputModule.this));
                    PromoInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.promo.error", (Locale)PromoInputModule.this.environment.getLocale()), 10, DC.cases((int)8, (Locale)PromoInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new CancelDialogListener(cancelListener));
                    PromoInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            } else {
                PromoInputModule.this.cancel(null);
            }
        }
    }
}

