/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.paystat;

import i18n.B;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.screen.ScreenPopupDialog;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.chcopy.RequestAccountTask;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.parser.ParseException;
import ru.softlogic.srv.api.oth.FindOperationResult;
import ru.softlogic.srv.connector.ConnectorException;

public class AdvPayStatusInputModule
extends BaseInputModule {
    private Environment environment;
    private Runnable cancel;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");

    public AdvPayStatusInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        try {
            Form f = FormHelper.parseUtility("paystatus", environment.getLocale());
            List screens = f.getScreenSequence().getScreens();
            if (screens.size() != 1) {
                throw new ParseException("Wrong number of screens");
            }
            int fsize = ((ScreenDescription)screens.get(0)).getSequence().getFields().size();
            if (fsize < 4 || fsize > 6) {
                throw new ParseException("Wrong number of fields: " + fsize);
            }
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("point", new InputElement("point", "point", "" + environment.getPoint().getId()));
            ScreenDescription sd = (ScreenDescription)screens.get(0);
            CommonScreen cs = CommonScreenStore.getScreen((String)"letter", (String)sd.getDecor());
            cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, obj));
            cs.setListener((ScreenListener)new LocalScreenListener());
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
        catch (ParseException ex) {
            throw new DescriptionException(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private class RequestTask
    implements Task {
        private String account;
        private Integer sum;
        private String date;
        private String bigCheckNumber;

        public RequestTask(String bigCheckNumber, String date, String account, Integer sum) {
            this.account = account;
            this.sum = sum;
            this.date = date;
            this.bigCheckNumber = bigCheckNumber;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait");
        }

        @Override
        public Object execute() {
            AdvPayStatusInputModule.this.log.info((Object)("Make request, data=" + this.account + ", " + this.sum + ", " + this.date));
            try {
                if (this.bigCheckNumber != null && this.bigCheckNumber.length() == 12) {
                    this.date = null;
                    this.account = null;
                    this.sum = null;
                } else if (this.date != null && this.account != null && this.sum != null) {
                    this.bigCheckNumber = null;
                }
                return AdvPayStatusInputModule.this.context.getServerConnector().findOperationAdv(this.bigCheckNumber, this.date, this.account, this.sum);
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            AdvPayStatusInputModule.this.log.info(object);
            if (object instanceof FindOperationResult) {
                final FindOperationResult fr = (FindOperationResult)object;
                DialogScreen dialog = fr.getState() == 60 ? ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.paystat.success"), fr.getService()), 20, DC.cases((int)13), UserCase.Ok) : ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)("Provider.paystat.state." + fr.getState())), AdvPayStatusInputModule.this.environment.getDealer().getSupport()), 20, DC.cases((int)23), UserCase.Cancel);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        if (UserCase.Ok.equals((Object)userCase)) {
                            RequestAccountTask requestAccountTask = new RequestAccountTask(AdvPayStatusInputModule.this.environment, AdvPayStatusInputModule.this.context, "" + fr.getIdOperation(), null, AdvPayStatusInputModule.this.cancel);
                            AdvPayStatusInputModule.this.context.getTaskExecutor().execute(requestAccountTask);
                        } else if (fr.getState() < 0) {
                            ModuleHelper.invoke(AdvPayStatusInputModule.this.cancel);
                        } else {
                            AdvPayStatusInputModule.this.cancel(null);
                        }
                    }
                });
                AdvPayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                Exception ex = (Exception)object;
                AdvPayStatusInputModule.this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u043d\u043b\u0430\u0439\u043d \u0437\u0430\u043f\u0440\u043e\u0441\u0435", (Throwable)ex);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Request.failure.connect"), 10, DC.cases((int)1), UserCase.Ok);
                AdvPayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                ModuleHelper.invoke(AdvPayStatusInputModule.this.cancel);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
            CommonScreen sc = ComponentFactory.getInstance().create(sd.getType(), sd.getDecor());
            try {
                if (sc != null) {
                    sc.init(sd, si);
                    AdvPayStatusInputModule.this.context.showDialog((DialogInterface)new ScreenPopupDialog(sc, 30, "Exit", true, listener));
                    return;
                }
            }
            catch (InitException initException) {
                // empty catch block
            }
            listener.onAction("Exit", Collections.EMPTY_MAP, null);
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            AdvPayStatusInputModule.this.cancel = cancelListener;
            if (ActionType.isNext((String)action)) {
                Date d;
                AdvPayStatusInputModule.this.log.info(data);
                InputElement account = (InputElement)data.get("account");
                InputElement sm = (InputElement)data.get("sum");
                InputElement date = (InputElement)data.get("date");
                InputElement doc = (InputElement)data.get("doc");
                String sumValue = sm.getValue();
                Integer sum = sumValue != null && !sumValue.isEmpty() ? Integer.valueOf(Math.round(Float.parseFloat(sumValue) * 100.0f)) : null;
                try {
                    GregorianCalendar cal;
                    if (date.getValue().matches("\\d+")) {
                        cal = new GregorianCalendar();
                        ((Calendar)cal).add(6, -Integer.parseInt(date.getValue()));
                        d = cal.getTime();
                    } else {
                        d = sdf.parse(date.getValue());
                    }
                    cal = new GregorianCalendar();
                    if (d.after(cal.getTime())) {
                        DialogScreen dialog = this.createErrorDialog("Provider.paystat.date.error");
                        AdvPayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                        ModuleHelper.invoke(AdvPayStatusInputModule.this.cancel);
                        return;
                    }
                    ((Calendar)cal).add(1, -2);
                    if (d.before(cal.getTime())) {
                        DialogScreen dialog = this.createErrorDialog("Provider.paystat.date.error");
                        AdvPayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                        ModuleHelper.invoke(AdvPayStatusInputModule.this.cancel);
                        return;
                    }
                }
                catch (java.text.ParseException ex) {
                    DialogScreen dialog = this.createErrorDialog("Provider.paystat.date.failure");
                    AdvPayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                    ModuleHelper.invoke(AdvPayStatusInputModule.this.cancel);
                    return;
                }
                String bigDocNum = null;
                if (doc != null) {
                    bigDocNum = doc.getValue();
                }
                AdvPayStatusInputModule.this.context.getTaskExecutor().execute(new RequestTask(bigDocNum, sdf.format(d), account.getValue(), sum));
            } else {
                AdvPayStatusInputModule.this.cancel(null);
            }
        }

        private DialogScreen createErrorDialog(String textCode) {
            return ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)textCode), 10, DC.cases((int)1), UserCase.Ok);
        }
    }
}

