/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntssnack;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.ThreadUtil;
import snack.machine.api.SnackMachine;
import snack.machine.model.StatusSM;

public class SnackMachineStatisticSender
implements Runnable {
    private static final long TIMEOUT = 1800000L;
    private ClientInterface clientInterface;
    private Integer lastStatus;
    private Logger log = Logger.getLogger((String)"app");

    public SnackMachineStatisticSender(ClientInterface clientInterface) {
        this.log.setAdditivity(false);
        SnackMachine.setDefaultInstance((SnackMachine)new SnackMachine());
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        SnackMachine sm = SnackMachine.getDefaultInstance();
        DeviceStatus ds = new DeviceStatus(Short.valueOf(DeviceClass.SnackDispenser.getCode()), 0);
        this.clientInterface.sendStatus(ds);
        DeviceInfo di = new DeviceInfo(DeviceType.SimpleSnackMachine);
        di.setPort("127.0.0.1:2180");
        this.clientInterface.send(di);
        if (sm != null) {
            while (!Thread.currentThread().isInterrupted()) {
                block6: {
                    try {
                        StatusSM status = sm.getStatus();
                        ds = status.getStatusError() != 0 ? new DeviceStatus(Short.valueOf(DeviceClass.SnackDispenser.getCode()), 4) : new DeviceStatus(Short.valueOf(DeviceClass.SnackDispenser.getCode()), 0);
                        if (this.lastStatus == null || this.lastStatus.intValue() != ds.getStatus()) {
                            this.lastStatus = ds.getStatus();
                            this.clientInterface.sendStatus(ds);
                        }
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                        ds = new DeviceStatus(Short.valueOf(DeviceClass.SnackDispenser.getCode()), 1);
                        if (this.lastStatus != null && this.lastStatus.intValue() == ds.getStatus()) break block6;
                        this.lastStatus = ds.getStatus();
                        this.clientInterface.sendStatus(ds);
                    }
                }
                ThreadUtil.sleep((long)1800000L);
            }
        } else {
            this.log.error((Object)"No instance of SnackMachine");
        }
    }
}

