/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntssnack;

import i18n.B;
import java.util.Locale;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntssnack.SnackContextStub;
import ru.softlogic.module.input.ntssnack.StatusActionListener;
import ru.softlogic.module.input.ntssnack.StatusTask;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import snack.machine.api.SnackMachine;
import snack.machine.model.Answer.ResNumCntAnswer;
import snack.machine.model.Snack;

public class NtsSnackProcessingModule
extends ObsoleteProcessingModule {
    public static final String SNACK_KEY = "#snack.product";
    private Snack snack;
    private Locale locale;
    private SnackContextStub snackContext;

    public NtsSnackProcessingModule(ApplicationContext context) {
        super(context);
        this.snackContext = new SnackContextStub(context, "snack-final");
    }

    @Override
    protected void _process(final Environment environment) {
        this.locale = environment.getLocale();
        try {
            if (!Session.getInstance().getPack().isCancel() && Session.getInstance().getPack().getPaymentType() == 0) {
                Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                this.snack = (Snack)payment.getData().get(SNACK_KEY);
                StatusActionListener actionListener = new StatusActionListener(){

                    @Override
                    public void onSuccess() {
                        NtsSnackProcessingModule.super._process(environment);
                    }

                    @Override
                    public void onError(final Object object) {
                        String msg = B.get((String)"Module.processing.snack.error", (Locale)NtsSnackProcessingModule.this.locale);
                        if (object instanceof ResNumCntAnswer[]) {
                            ResNumCntAnswer[] answers = (ResNumCntAnswer[])object;
                            msg = B.get((String)("Module.processing.snack.dispense.error." + answers[1].getResult()), (Locale)NtsSnackProcessingModule.this.locale, (String)B.get((String)"Module.processing.snack.dispense.error", (Locale)NtsSnackProcessingModule.this.locale));
                        }
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, msg, 10, DC.cases((int)8), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                NtsSnackProcessingModule.this.cancelPay(object, environment);
                            }
                        });
                        NtsSnackProcessingModule.this.context.showDialog((DialogInterface)dialog);
                    }
                };
                this.snackContext.getTaskExecutor().execute(new LocalWait4FinishAction(actionListener, B.get((String)"Module.processing.snack.dispense.wait", (Locale)this.locale), this.locale));
            } else {
                log.info((Object)"No need to dispense snack");
                super._process(environment);
            }
        }
        catch (Exception ex) {
            this.cancelPay(ex, environment);
        }
    }

    private void cancelPay(Object obj, Environment env) {
        String paymentModuleName = null;
        if (env.getMenuItem() != null && env.getMenuItem().getService() != null && env.getMenuItem().getService().getModules() != null && env.getMenuItem().getService().getModules().getPayment() != null && !env.getMenuItem().getService().getModules().getPayment().isEmpty()) {
            paymentModuleName = env.getMenuItem().getService().getModules().getPayment();
        }
        if ("cashless-auto".equals(paymentModuleName)) {
            log.info((Object)"Cancel pay: paymentModuleName = cashless-auto");
            log.info((Object)"Go to main menu");
            this.context.toMainMenu();
            log.info((Object)B.get((String)"Module.finish", (Locale)this.locale));
        } else {
            ModuleHelper.cancelPack(Session.getInstance().getPack());
            ProblemNotifier.notifyProblem((String)("Error in NtsSnackProcessingModule: " + obj));
            NtsSnackProcessingModule.super._process(env);
        }
    }

    private class LocalWait4FinishAction
    extends StatusTask {
        public LocalWait4FinishAction(StatusActionListener actionListener, String message, Locale locale) {
            super(actionListener, message, locale);
        }

        @Override
        public Object execute() {
            ResNumCntAnswer[] object;
            try {
                object = SnackMachine.getDefaultInstance().dispenseSnack(NtsSnackProcessingModule.this.snack.getId(), NtsSnackProcessingModule.this.snack.getCountToDispense());
            }
            catch (Exception ex) {
                object = ex;
            }
            return object;
        }
    }
}

