/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntssnack;

import i18n.B;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByPropertyVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.DigitalFilter;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.ntssnack.NtsSnackProcessingModule;
import ru.softlogic.module.input.ntssnack.SnackContextStub;
import ru.softlogic.module.input.ntssnack.StatusActionListener;
import ru.softlogic.module.input.ntssnack.StatusTask;
import ru.softlogic.reference.menu.MenuItem;
import snack.machine.api.SnackMachine;
import snack.machine.model.Snack;
import snack.machine.model.StatusSM;

public class NtsSnackInputModule
extends BaseInputModule {
    private Environment environment;
    private Restorable parent;
    private Map<String, Snack> snacks;
    private CommonScreen currentScreen;
    private Locale locale;
    private SnackContextStub snackContext;
    private StatusActionListener statusActionListener = new LocalStatusListener();
    private String paymentModuleName;
    private List<MenuItem> menuItems;
    private MenuItem currentMenuItem;

    public NtsSnackInputModule(ApplicationContext context) {
        super(context);
        this.snackContext = new SnackContextStub(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.log.info((Object)"Start snack sale");
        this.environment = environment;
        this.parent = parent;
        this.locale = environment.getLocale();
        environment.setProcessingModule(new NtsSnackProcessingModule((ApplicationContext)this.context));
        this.snackContext.getTaskExecutor().execute(new StatusTask(this.statusActionListener, B.get((String)"Module.input.snack.request.wait", (Locale)this.locale), this.locale));
        this.paymentModuleName = null;
        if (environment.getMenuItem() != null && environment.getMenuItem().getService() != null && environment.getMenuItem().getService().getModules() != null && environment.getMenuItem().getService().getModules().getPayment() != null && !environment.getMenuItem().getService().getModules().getPayment().isEmpty()) {
            this.paymentModuleName = environment.getMenuItem().getService().getModules().getPayment();
        }
        this.log.info((Object)("Redirect data: " + environment.getInitData()));
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.currentScreen.onEvent(null);
        this.context.showScreen(new ContentScreenAdapter(this.currentScreen));
    }

    @Override
    public void cancel(Intent intent) {
        super.cancel(intent);
    }

    private void showAvailableProducts() {
        this.log.info((Object)"Show select product screen");
        if (this.snacks != null && !this.snacks.isEmpty()) {
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Snack s : this.snacks.values()) {
                SelectorItem si = new SelectorItem("" + s.getSnackName(), "" + s.getId());
                HashMap<String, Snack> data = new HashMap<String, Snack>();
                s.setAvailable(s.getCount() > 0);
                data.put("#snack.product", s);
                si.setCustomData(data);
                si.setData(new Data());
                si.getData().setSum(new TransactionSum((float)s.getCost()));
                items.add(si);
            }
            SelectorField sf = new SelectorField();
            sf.setStore((ItemsStore)new StaticStore(items));
            LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
            fields.add(sf);
            ScreenDescription sd = new ScreenDescription("selector-snack");
            sd.setTitle(B.get((String)"Module.input.snack.products.title", (Locale)this.locale));
            sd.setDecor("snack-image");
            sd.setSequence(new FieldSequence(fields));
            sd.setButtons(InitModuleHelper.createKeyMap());
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            try {
                cs.init(sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalSelectProductListener());
                this.context.showScreen(new ContentScreenAdapter(cs));
                this.currentScreen = cs;
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.snack.products.empty", (Locale)this.locale));
        }
    }

    private void preparePayment(Snack snack) {
        Double paySum;
        this.log.info((Object)"Prepare payment");
        this.currentMenuItem = null;
        for (MenuItem mi : this.menuItems) {
            if (!("" + snack.getId()).equals(mi.getService().getProperties().get("snack-id"))) continue;
            this.currentMenuItem = mi;
            break;
        }
        Keyboard kbrd = new Keyboard(KeyboardType.Digital);
        NumericField nf = new NumericField();
        nf.setId("count");
        nf.setTitle(B.get((String)"Module.input.snack.product.count", (Locale)this.locale));
        nf.setKeyboard(kbrd);
        nf.setFilter((Filter)new DigitalFilter(false));
        nf.setFormatter((Formatter)new VoidFormatter());
        nf.setDataFormatter((Formatter)new VoidFormatter());
        nf.setModificator((Modificator)new VoidModificator());
        nf.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range(1.0f, (float)snack.getCount()))));
        nf.setUnitCount(1);
        nf.setDecimalCount(1);
        nf.setDefaultValue("1");
        FieldSequence fs = new FieldSequence();
        fs.setFields(Arrays.asList(nf));
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("snack-count");
        ssd.setTitle(snack.getSnackName());
        ssd.setSequence(fs);
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        ssd.setButtons(buttons);
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.log.info((Object)("Redirect data: " + this.environment.getInitData()));
        if (this.environment.getInitData() != null) {
            ModuleHelper.fillStore(this.environment.getInitData(), data);
        }
        data.put("id1", new InputElement("id1", B.get((String)"Module.input.snack.product.name", (Locale)this.locale), "" + snack.getSnackName()));
        data.put("id2", new InputElement("id2", B.get((String)"Module.input.snack.product.cost", (Locale)this.locale), "" + snack.getCost()));
        data.put("count", new InputElement("count", B.get((String)"Module.input.snack.product.count", (Locale)this.locale), "1"));
        data.put("#snack.product", snack);
        data.put("#snack-id", String.valueOf(snack.getId()));
        Sum operationSum = null;
        Object obj = data.get("#newsum");
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            try {
                operationSum = new Sum(Integer.parseInt(ie.getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (operationSum == null && (paySum = Double.valueOf(snack.getCost())) != null) {
            operationSum = new Sum(paySum.doubleValue());
        }
        if (this.currentMenuItem != null) {
            this._startPayment(this.environment, ssd, data, operationSum, this.currentMenuItem.getService(), this.currentMenuItem.getCommission());
        } else {
            this._startPayment(this.environment, ssd, data, operationSum, null, null);
        }
    }

    private void showError(Object object) {
        String message = "";
        String eventMessage = "";
        if (object == null) {
            message = B.get((String)"Module.input.snack.message.error", (Locale)this.locale);
            eventMessage = B.get((String)"Module.input.snack.message.error", (Locale)Locale.ENGLISH);
        } else if (object instanceof Exception) {
            message = B.get((String)"Module.input.snack.message.error.connection", (Locale)this.locale);
            eventMessage = B.get((String)"Module.input.snack.message.error.connection", (Locale)Locale.ENGLISH);
        } else if (object instanceof StatusSM) {
            StatusSM ssm = (StatusSM)object;
            if (ssm.getMode() != 2) {
                message = B.get((String)("Module.input.snack.message.error.mode." + ssm.getMode()), (Locale)this.locale);
                message = message + '\n';
                eventMessage = B.get((String)("Module.input.snack.message.error.mode." + ssm.getMode()), (Locale)Locale.ENGLISH);
                eventMessage = eventMessage + '\n';
            }
            if (ssm.getStatusError() != 0) {
                message = message + B.get((String)("Module.input.snack.message.error.status." + ssm.getStatusError()), (Locale)this.locale, (String)B.get((String)"Module.input.snack.message.error.status", (Locale)this.locale));
                eventMessage = eventMessage + B.get((String)("Module.input.snack.message.error.status." + ssm.getStatusError()), (Locale)Locale.ENGLISH, (String)B.get((String)"Module.input.snack.message.error.status", (Locale)Locale.ENGLISH));
            }
            this.log.info((Object)message);
            if (message.trim().isEmpty()) {
                return;
            }
        } else if (object instanceof String) {
            message = (String)object;
        }
        ProblemNotifier.getDefaultNotifier().onProblem("" + eventMessage);
        this.log.info((Object)"Show error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, message, 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener((DialogListener)new LocalExitDialogListener());
        this.context.showDialog((DialogInterface)dialog);
    }

    private class LocalStatusListener
    implements StatusActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void onSuccess() {
            NtsSnackInputModule.this.snackContext.getTaskExecutor().execute(new GetSnackTask());
        }

        @Override
        public void onError(Object object) {
            NtsSnackInputModule.this.showError(object);
        }
    }

    private class LocalExitDialogListener
    implements DialogListener {
        public void dialogClosed(UserCase userCase) {
            NtsSnackInputModule.this.cancel(null);
        }
    }

    private class GetSnackTask
    implements Task {
        @Override
        public String getMessage() {
            return B.get((String)"Module.input.snack.products.request.wait", (Locale)NtsSnackInputModule.this.locale);
        }

        @Override
        public Object execute() {
            Serializable object;
            try {
                object = SnackMachine.getDefaultInstance().getSnacks();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NtsSnackInputModule.this.log.error((Object)ex, (Throwable)ex);
                object = ex;
            }
            return object;
        }

        @Override
        public void onResult(Object object) {
            NtsSnackInputModule.this.log.info((Object)("Recived answer: " + object));
            if (object != null) {
                if (object instanceof Exception) {
                    NtsSnackInputModule.this.showError(object);
                } else if (object instanceof Map) {
                    NtsSnackInputModule.this.snacks = (HashMap)object;
                    MenuByPropertyVisitor visitor = new MenuByPropertyVisitor("snack-id");
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    NtsSnackInputModule.this.menuItems = visitor.getItems();
                    if (NtsSnackInputModule.this.snacks != null && !NtsSnackInputModule.this.menuItems.isEmpty()) {
                        Iterator iterator = NtsSnackInputModule.this.snacks.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (entry.getValue() == null) {
                                iterator.remove();
                                continue;
                            }
                            boolean found = false;
                            for (MenuItem mi : NtsSnackInputModule.this.menuItems) {
                                if (!("" + ((Snack)entry.getValue()).getId()).equals(mi.getService().getProperties().get("snack-id"))) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            iterator.remove();
                        }
                    }
                    NtsSnackInputModule.this.showAvailableProducts();
                }
            }
        }
    }

    private class LocalSelectProductListener
    extends ScreenAdapter {
        private LocalSelectProductListener() {
        }

        public final void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtsSnackInputModule.this.cancelListener = cancelListener;
            NtsSnackInputModule.this.log.info((Object)("Selector action: " + action));
            NtsSnackInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
                NtsSnackInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Snack snack = (Snack)data.get("#snack.product");
                if (snack != null && snack.isAvailable()) {
                    NtsSnackInputModule.this.preparePayment(snack);
                } else {
                    NtsSnackInputModule.this.log.info((Object)"Show warning screen");
                    String invalidID = snack != null ? "" + snack.getId() : (String)data.get("#invalid-snack-id");
                    NtsSnackInputModule.this.log.info((Object)("" + invalidID + " is not available"));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.snack.product.available.false", (Locale)NtsSnackInputModule.this.locale), 3, DC.cases((int)8, (Locale)NtsSnackInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            ModuleHelper.invoke(cancelListener);
                        }
                    });
                    NtsSnackInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onLocale(Locale locale) {
            if (NtsSnackInputModule.this.environment != null) {
                NtsSnackInputModule.this.environment.setLocale(locale);
            }
        }
    }
}

