/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntspay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import ru.softlogic.cash.Sum;

public class SumFormatter {
    public static String format(Sum sum) {
        if (sum == null) {
            return "";
        }
        if ("RO".equalsIgnoreCase(Locale.getDefault().getCountry())) {
            return SumFormatter.format(sum.getBasicSum(), true) + " RON";
        }
        return sum.toString();
    }

    public static String formatEur(Sum sum) {
        if (sum == null) {
            return "";
        }
        if ("RO".equalsIgnoreCase(Locale.getDefault().getCountry())) {
            return SumFormatter.format(sum.getBasicSum(), false) + " \u20ac";
        }
        return sum.toString();
    }

    public static String formatEur(Sum sum, boolean round) {
        if (sum == null) {
            return "";
        }
        if ("RO".equalsIgnoreCase(Locale.getDefault().getCountry())) {
            return SumFormatter.format(sum.getBasicSum(), round) + " \u20ac";
        }
        return sum.toString();
    }

    private static String format(int sum, boolean round) {
        DecimalFormat df = new DecimalFormat();
        if (round) {
            if (sum % 100 == 0) {
                df.setMaximumFractionDigits(0);
                df.setMinimumFractionDigits(0);
            } else {
                df.setMaximumFractionDigits(2);
                df.setMinimumFractionDigits(2);
            }
        } else {
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
        }
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)sum / 100.0);
    }
}

