/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntspay;

import ru.softlogic.app.MathCommissionCalculator;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;

public class NtspayPayDetector {
    private Service service;
    private Commission commission;
    private Sum min;
    private Sum provSum;
    private double rate;
    private double nds;

    public NtspayPayDetector(Service service, Commission commission, Sum min, Sum provSum, double rate, double nds) {
        this.service = service;
        this.commission = commission;
        this.min = min;
        this.provSum = provSum;
        this.rate = rate;
        this.nds = nds;
    }

    public Sum getMin() {
        return this.min;
    }

    public void setMin(Sum min) {
        this.min = min;
    }

    public SumResult calculate(Keeper keeper) {
        return MathCommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Sum)this.provSum, (double)this.rate, (double)this.nds);
    }

    public boolean canPay(SumResult sr) {
        return !sr.getOutProv().isEmpty() && sr.getOutProv().compareTo(this.min) >= 0;
    }
}

