/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntspay;

import i18n.B;
import java.awt.EventQueue;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.MathCommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.currency.CurrencyUtil;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.intent.BackIntent;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntspay.NtspayCurrencyKeeperListener;
import ru.softlogic.module.input.ntspay.NtspayPayDetector;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class NtspayCurrencyPaymentModule
extends BasePaymentModule {
    private BasePinCodeScreen pinScreen = (BasePinCodeScreen)ComponentFactory.getInstance().createDialogPanel("cbc");
    private ScreenListener listener = new LocalScreenListener();
    private Logger log = Logger.getLogger((String)"pay");
    private Runnable cancelListener;
    private NtspayCurrencyKeeperListener keeperListener;
    private NtspayPayDetector payDetector;
    private Keeper cbcKeeper;
    private Sum max;
    private Sum operProvider;
    private Service service;
    private ServiceLimit payToolServiceLimit;
    private double nds;

    public NtspayCurrencyPaymentModule(ApplicationContext context) {
        super(context);
        try {
            this.nds = Double.parseDouble(AppDefaults.getInstance().getProperty("nds", "0.24"));
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.nds = 0.24;
        }
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Session.getInstance().setCorrectPack(Session.getInstance().getPack());
        this.environment = environment;
        this.cbcKeeper = null;
        this.log.info((Object)"Open ntspay payment module");
        PackUtility.printPack("Payment pack", Session.getInstance().getPack());
        MenuItem mi = environment.getMenuItem();
        this.service = Session.getInstance().getPack().getService() == null ? mi.getService() : Session.getInstance().getPack().getService();
        Commission c = Session.getInstance().getPack().getCommission() == null ? mi.getCommission() : Session.getInstance().getPack().getCommission();
        Sum min = this.service.getMinSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.service.getMaxSum();
        }
        this.operProvider = Session.getInstance().getPack().getOperationSum();
        this.log.info((Object)("Service currency: " + this.service.getCurrencyCode()));
        Double rate = CurrencyUtil.getRate((String)this.service.getCurrencyCode(), (int)this.service.getId());
        this.log.info((Object)("Currency rate: " + rate));
        if (this.service.getCurrencyCode() != null && !this.service.getCurrencyCode().isEmpty() && rate == null) {
            ProblemNotifier.notifyProblem((String)("Can't get currency rate: " + this.service.getCurrencyCode()));
            this.cancel(null);
            return;
        }
        if (min == null) {
            min = new Sum();
        }
        this.log.info((Object)("min sum=" + min + ", max=" + this.max + ", operation sum=" + this.operProvider));
        if (min != null && this.operProvider != null && this.operProvider.compareTo(min) < 0) {
            this.log.info((Object)("Fix min sum to=" + this.operProvider));
            min = this.operProvider;
        }
        Sum requireSum = null;
        if (this.operProvider != null && !this.operProvider.isEmpty()) {
            requireSum = MathCommissionCalculator.calculateMin((Sum)this.operProvider, (double)rate, (double)this.nds, (Commission)c);
        }
        if (requireSum == null && min != null && min.equals((Object)this.max)) {
            requireSum = MathCommissionCalculator.calculateMinNonNominal((Sum)min, (double)rate, (double)this.nds, (Commission)mi.getCommission());
        }
        if (requireSum == null && min != null && !min.isEmpty()) {
            requireSum = MathCommissionCalculator.calculateMinNonNominal((Sum)min, (double)rate, (double)this.nds, (Commission)mi.getCommission());
        }
        if (requireSum != null) {
            this.log.info((Object)("Required sum: " + requireSum));
        }
        sumScreen.setListener(this.listener);
        this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)sumScreen));
        this.payDetector = new NtspayPayDetector(this.service, c, min, this.operProvider, rate, this.nds);
        this.keeperListener = new NtspayCurrencyKeeperListener(sumScreen, requireSum, this.operProvider, this.service, this.payDetector, this.service.isAutoFinishPayment(), this.listener);
        this.enableCashManager(Session.getInstance().getCurrentKeeper());
    }

    @Override
    public void cancel(Intent intent) {
        this._cancel(intent);
    }

    private void enableCashManager(Keeper parent) {
        if (parent != null) {
            this.log.info((Object)("Enable cash manager with keeper: " + parent));
        }
        CashManager.getDefaultInstance().enable(parent, this.max, this.environment.getAllowedNotes(), this.environment.getAllowedCoins(), (KeeperObserver)this.keeperListener, CashMobuleHelper.getAllowDevices(this.service, parent == null ? false : !parent.getCashBackCards().isEmpty()), false);
    }

    private void _cancel(Intent intent) {
        boolean timeout;
        this.log.info((Object)"Cancel was requested on payment module");
        Keeper current = CashManager.getDefaultInstance().current();
        boolean bl = timeout = intent.getType() == 0;
        if (current.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            final Keeper keeper = CashManager.getDefaultInstance().disable();
            if (keeper.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process intent");
                Session.getInstance().getPack().setKeeper(keeper);
                intent.process();
            } else {
                this.log.info((Object)("New keeper state: " + keeper));
                if (intent.getType() == 3) {
                    this.log.info((Object)"Can't do back action. Enable devices again");
                    this.enableCashManager(keeper);
                } else if (this.payDetector.canPay(this.payDetector.calculate(keeper))) {
                    this.log.info((Object)"Payment can be processed, ask question");
                    final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    NtspayCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                    if (userCase == UserCase.Cancel) {
                                        NtspayCurrencyPaymentModule.this.log.info((Object)"Process cancel");
                                        NtspayCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                                    } else {
                                        NtspayCurrencyPaymentModule.this.log.info((Object)"Enable devices again");
                                        NtspayCurrencyPaymentModule.this.enableCashManager(keeper);
                                        NtspayCurrencyPaymentModule.this.cancelListener.run();
                                    }
                                }
                            });
                            dialog.show(NtspayCurrencyPaymentModule.this.context.getShell());
                        }
                    });
                } else {
                    this.log.info((Object)"Payment can't be processed. Cancel payment");
                    this.process(keeper, UserCase.Cancel, timeout);
                }
            }
        } else {
            this.log.info((Object)"Keeper is not empty. Disable cash devices");
            if (this.payDetector.canPay(this.payDetector.calculate(current))) {
                this.log.info((Object)"The amount is sufficient for the payment, ask question");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)4, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                NtspayCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                NtspayCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                            }
                        });
                        dialog.show(NtspayCurrencyPaymentModule.this.context.getShell());
                    }
                });
            } else {
                this.log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                MediaPlayer.getInstance().play("under_min_sum.mp3");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.payment.cancel.continue", (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                NtspayCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                if (userCase == UserCase.Cancel) {
                                    NtspayCurrencyPaymentModule.this.log.info((Object)"Disable cash devices");
                                    NtspayCurrencyPaymentModule.this.process(keeper, userCase, timeout);
                                } else {
                                    NtspayCurrencyPaymentModule.this.enableCashManager(keeper);
                                    NtspayCurrencyPaymentModule.this.cancelListener.run();
                                }
                            }
                        });
                        dialog.show(NtspayCurrencyPaymentModule.this.context.getShell());
                    }
                });
            }
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        this.log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = this.payDetector.calculate(keeper);
        if (Session.getInstance().getPack().getService().getDivideSum() != null && !Session.getInstance().getPack().getService().getDivideSum().isEmpty() && userCase == UserCase.Ok && pkg.getPayments().size() == 1) {
            Sum totalInput = new Sum(sumResult.getOut());
            Sum divSum = Session.getInstance().getPack().getService().getDivideSum();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getBasicSum() / divSum.getBasicSum();
            if (!totalInput.divRest(divSum).isEmpty()) {
                ++count;
            }
            --count;
            Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                Session.getInstance().getPack().getPayments().add(payment1);
            }
            Session.getInstance().getPack().setSumDistributionType("consistent");
        }
        if (pkg.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                if (this.operProvider != null && sumResult.getChange() != null && !sumResult.getChange().isEmpty()) {
                    MenuItem mi = null;
                    Double rate = null;
                    try {
                        MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(((Integer)this.service.getChildServices().get(0)).intValue(), false);
                        MenuUtils.processMenu((MenuVisitor)visitor);
                        mi = visitor.getMenuItem();
                        rate = CurrencyUtil.getRate((String)mi.getService().getCurrencyCode(), (int)mi.getService().getId());
                    }
                    catch (Exception visitor) {
                        // empty catch block
                    }
                    if (mi != null && rate != null) {
                        this.log.info((Object)("Found chind menu item: " + mi));
                        Sum min = null;
                        Sum max = null;
                        if (this.payToolServiceLimit != null) {
                            if (this.payToolServiceLimit.getMinSum() != null && !this.payToolServiceLimit.getMinSum().isEmpty()) {
                                min = this.payToolServiceLimit.getMinSum();
                            }
                            if (this.payToolServiceLimit.getMaxSum() != null && !this.payToolServiceLimit.getMaxSum().isEmpty()) {
                                max = this.payToolServiceLimit.getMaxSum();
                            }
                        } else {
                            if (mi.getService().getMinSum() != null && !mi.getService().getMinSum().isEmpty()) {
                                min = mi.getService().getMinSum();
                            }
                            if (mi.getService().getMaxSum() != null && !mi.getService().getMaxSum().isEmpty()) {
                                max = mi.getService().getMaxSum();
                            }
                        }
                        SumResult dsr = MathCommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)mi.getCommission(), null, (double)rate, (double)this.nds);
                        boolean ask = true;
                        if (dsr.getOutProv().isEmpty()) {
                            this.log.info((Object)"Derect sum empty. Skip");
                            ask = false;
                        } else if (min != null && min.compareTo(dsr.getOutProv()) > 0) {
                            this.log.info((Object)"Min derect sum bigger. Skip");
                            ask = false;
                        } else if (max != null && max.compareTo(dsr.getOutProv()) < 0) {
                            this.log.info((Object)"Max derect sum lower. Skip");
                            ask = false;
                        }
                        if (ask) {
                            AppEnvironment.getInstance().open(mi, ModuleHelper.clearSum(p.getData()));
                            this.cancelListener.run();
                            return;
                        }
                    }
                    p.setSumOut(sumResult.getOut());
                    pkg.setSumResult(sumResult);
                    pkg.setCancel(false);
                } else {
                    p.setSumOut(sumResult.getOut());
                    pkg.setSumResult(sumResult);
                    pkg.setCancel(false);
                }
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private class DialogRunnable
    implements Runnable {
        private String text;

        public DialogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, this.text, 10, DC.cases((int)1, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    NtspayCurrencyPaymentModule.this.enableCashManager(NtspayCurrencyPaymentModule.this.cbcKeeper);
                    NtspayCurrencyPaymentModule.this.cbcKeeper = null;
                }
            });
            NtspayCurrencyPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class PincodeActivator
    implements Task {
        private String pin;

        public PincodeActivator(String pin) {
            this.pin = pin;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.cbc.wait");
        }

        @Override
        public Object execute() {
            Sum localMaxSum;
            Sum sum = localMaxSum = NtspayCurrencyPaymentModule.this.payToolServiceLimit != null ? NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMaxSum() : NtspayCurrencyPaymentModule.this.max;
            if (localMaxSum == null || localMaxSum.isEmpty()) {
                NtspayCurrencyPaymentModule.this.log.info((Object)"Max sum is not specify. Return error");
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            if (localMaxSum.compareTo(NtspayCurrencyPaymentModule.this.cbcKeeper.getSum()) <= 0) {
                NtspayCurrencyPaymentModule.this.log.info((Object)("Keeper reached max sum. Return error. Max=" + localMaxSum + ", keeper=" + NtspayCurrencyPaymentModule.this.cbcKeeper.getSum()));
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            Sum rest = localMaxSum.sub(NtspayCurrencyPaymentModule.this.cbcKeeper.getSum());
            NtspayCurrencyPaymentModule.this.log.info((Object)("Maximum nominal: " + localMaxSum));
            NtspayCurrencyPaymentModule.this.log.info((Object)("Allowed rest: " + rest));
            try {
                return NtspayCurrencyPaymentModule.this.context.getServerConnector().acivateCashBackCard(this.pin, new Sum(), localMaxSum.sub(NtspayCurrencyPaymentModule.this.cbcKeeper.getSum()), SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            NtspayCurrencyPaymentModule.this.log.info((Object)("Result: " + object));
            String text = null;
            if (object instanceof ActivationResult) {
                ActivationResult ar = (ActivationResult)object;
                if (ar.getError() == ActivationResultType.Ok) {
                    CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
                    cbc.setNominal(ar.getRest());
                    cbc.setRef(ar.getIdOperation());
                    NtspayCurrencyPaymentModule.this.cbcKeeper.addCashBackCard(cbc);
                    NtspayCurrencyPaymentModule.this.enableCashManager(NtspayCurrencyPaymentModule.this.cbcKeeper);
                    NtspayCurrencyPaymentModule.this.cbcKeeper = null;
                    return;
                }
                text = B.get((String)("Request.cbc.err." + ar.getError()), (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale());
            } else {
                text = B.get((String)("Request.cbc.err." + ActivationResultType.ErrNetwork), (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale());
            }
            EventQueue.invokeLater(new DialogRunnable(text));
        }
    }

    private class LocalPinCodeListener
    implements CustomDialogListener {
        private LocalPinCodeListener() {
        }

        public void onClose(Object type) {
            ModuleHelper.invoke(NtspayCurrencyPaymentModule.this.cancelListener);
            if (type != null) {
                String pincode = (String)type;
                NtspayCurrencyPaymentModule.this.log.info((Object)("Input pincode: " + pincode));
                NtspayCurrencyPaymentModule.this.cancelListener.run();
                NtspayCurrencyPaymentModule.this.context.getTaskExecutor().execute(new PincodeActivator(pincode));
            } else {
                NtspayCurrencyPaymentModule.this.log.info((Object)"Close pincode screen");
                NtspayCurrencyPaymentModule.this.enableCashManager(NtspayCurrencyPaymentModule.this.cbcKeeper);
                NtspayCurrencyPaymentModule.this.cbcKeeper = null;
                NtspayCurrencyPaymentModule.this.context.getShell().showPopup(null);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtspayCurrencyPaymentModule.this.log.info((Object)("Action on sum screen: " + action));
            NtspayCurrencyPaymentModule.this.cancelListener = cancelListener;
            if (ActionType.isCbc((String)action)) {
                NtspayCurrencyPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                NtspayCurrencyPaymentModule.this.log.info((Object)("Keeper: " + NtspayCurrencyPaymentModule.this.cbcKeeper));
                if (!CashMobuleHelper.isAllowCBC(NtspayCurrencyPaymentModule.this.service, !NtspayCurrencyPaymentModule.this.cbcKeeper.getCashSum().isEmpty())) {
                    NtspayCurrencyPaymentModule.this.log.info((Object)"CBC disable for this service ");
                    NtspayCurrencyPaymentModule.this.enableCashManager(NtspayCurrencyPaymentModule.this.cbcKeeper);
                    if (cancelListener != null) {
                        cancelListener.run();
                    }
                    return;
                }
                NtspayCurrencyPaymentModule.this.pinScreen.init(NtspayCurrencyPaymentModule.this.environment.getLocale());
                CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)NtspayCurrencyPaymentModule.this.pinScreen, Math.min(30, NtspayCurrencyPaymentModule.this.getInactivityTimeout() - 5), null, true);
                cpd.addListener((CustomDialogListener)new LocalPinCodeListener());
                NtspayCurrencyPaymentModule.this.context.showDialog((DialogInterface)cpd);
            } else if (ActionType.isExit((String)action)) {
                NtspayCurrencyPaymentModule.this.cancel(new ExitIntent(NtspayCurrencyPaymentModule.this.context, 2));
            } else if (ActionType.isPrev((String)action)) {
                NtspayCurrencyPaymentModule.this.cancel(new BackIntent(NtspayCurrencyPaymentModule.this.environment.getInputModule()));
            } else if (ActionType.isNext((String)action)) {
                NtspayCurrencyPaymentModule.this.log.info((Object)"Disable devices again");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                if (keeper.getSum().isEmpty()) {
                    NtspayCurrencyPaymentModule.this.log.info((Object)"Enable devices again");
                    NtspayCurrencyPaymentModule.this.enableCashManager(keeper);
                    cancelListener.run();
                } else {
                    SumResult sr = NtspayCurrencyPaymentModule.this.payDetector.calculate(keeper);
                    if (NtspayCurrencyPaymentModule.this.payDetector.canPay(sr)) {
                        NtspayCurrencyPaymentModule.this.process(keeper, UserCase.Ok, false);
                    } else {
                        if (NtspayCurrencyPaymentModule.this.operProvider != null) {
                            MenuItem mi = null;
                            Double rate = null;
                            try {
                                MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(((Integer)NtspayCurrencyPaymentModule.this.service.getChildServices().get(0)).intValue(), false);
                                MenuUtils.processMenu((MenuVisitor)visitor);
                                mi = visitor.getMenuItem();
                                rate = CurrencyUtil.getRate((String)mi.getService().getCurrencyCode(), (int)mi.getService().getId());
                            }
                            catch (Exception visitor) {
                                // empty catch block
                            }
                            if (mi != null && rate != null) {
                                NtspayCurrencyPaymentModule.this.log.info((Object)("Found chind menu item: " + mi));
                                Sum min = null;
                                Sum max = null;
                                if (NtspayCurrencyPaymentModule.this.payToolServiceLimit != null) {
                                    if (NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMinSum() != null && !NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMinSum().isEmpty()) {
                                        min = NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMinSum();
                                    }
                                    if (NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMaxSum() != null && !NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMaxSum().isEmpty()) {
                                        max = NtspayCurrencyPaymentModule.this.payToolServiceLimit.getMaxSum();
                                    }
                                } else {
                                    if (mi.getService().getMinSum() != null && !mi.getService().getMinSum().isEmpty()) {
                                        min = mi.getService().getMinSum();
                                    }
                                    if (mi.getService().getMaxSum() != null && !mi.getService().getMaxSum().isEmpty()) {
                                        max = mi.getService().getMaxSum();
                                    }
                                }
                                SumResult dsr = MathCommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)mi.getCommission(), null, (double)rate, (double)NtspayCurrencyPaymentModule.this.nds);
                                boolean ask = true;
                                if (dsr.getOutProv().isEmpty()) {
                                    NtspayCurrencyPaymentModule.this.log.info((Object)"Derect sum empty. Skip");
                                    ask = false;
                                } else if (min != null && min.compareTo(dsr.getOutProv()) > 0) {
                                    NtspayCurrencyPaymentModule.this.log.info((Object)"Min derect sum bigger. Skip");
                                    ask = false;
                                } else if (max != null && max.compareTo(dsr.getOutProv()) < 0) {
                                    NtspayCurrencyPaymentModule.this.log.info((Object)"Max derect sum lower. Skip");
                                    ask = false;
                                }
                                if (ask) {
                                    AppEnvironment.getInstance().open(mi, ModuleHelper.clearSum(((Payment)Session.getInstance().getPack().getPayments().get(0)).getData()));
                                    cancelListener.run();
                                    return;
                                }
                            }
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.getchange", (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale()), 20, DC.cases((int)21, (Locale)NtspayCurrencyPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        NtspayCurrencyPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                        if (userCase == UserCase.Cancel) {
                                            NtspayCurrencyPaymentModule.this.log.info((Object)"Process cancel");
                                            NtspayCurrencyPaymentModule.this.process(keeper, userCase, false);
                                        } else {
                                            NtspayCurrencyPaymentModule.this.log.info((Object)"Enable devices again");
                                            NtspayCurrencyPaymentModule.this.enableCashManager(keeper);
                                            cancelListener.run();
                                        }
                                    }
                                });
                                dialog.show(NtspayCurrencyPaymentModule.this.context.getShell());
                            }
                        });
                    }
                }
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Unknown action on sumscreen: " + action);
            }
        }
    }
}

