/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntspay;

import i18n.B;
import java.awt.EventQueue;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.intent.BackIntent;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BaseKeeperListener;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class NtspayCashPaymentModule
extends BasePaymentModule {
    private BasePinCodeScreen pinScreen = (BasePinCodeScreen)ComponentFactory.getInstance().createDialogPanel("cbc");
    private ScreenListener listener = new LocalScreenListener();
    private Logger log = Logger.getLogger((String)"pay");
    private Runnable cancelListener;
    private BaseKeeperListener keeperListener;
    private PayDetector payDetector;
    private Keeper cbcKeeper;
    private Sum max;
    private Sum maxPay;
    private ServiceLimit payToolServiceLimit;
    private Service service;

    public NtspayCashPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public int getInactivityTimeout() {
        if (this.service != null && this.service.getAutoProcessDueToInactivity() != null && this.service.getAutoProcessDueToInactivity() >= 20 && this.service.getAutoProcessDueToInactivity() <= 120 && this.payDetector.canPay(this.payDetector.calculate(CashManager.getDefaultInstance().current()))) {
            return this.service.getAutoProcessDueToInactivity();
        }
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Session.getInstance().setCorrectPack(Session.getInstance().getPack());
        this.environment = environment;
        this.context.setModule(this);
        this.cbcKeeper = null;
        this.log.info((Object)"Open payment module");
        Pack pack = Session.getInstance().getPack();
        PackUtility.printPack("Payment pack", pack);
        MenuItem mi = environment.getMenuItem();
        this.service = pack.getService() == null ? mi.getService() : pack.getService();
        Commission c = pack.getCommission() == null ? mi.getCommission() : pack.getCommission();
        Sum min = this.service.getMinSum();
        this.maxPay = pack.getMaxSum() != null ? pack.getMaxSum() : this.service.getMaxSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.service.getMaxSum();
        }
        Sum opr = pack.getOperationSum();
        if (min == null) {
            min = new Sum();
        }
        this.log.info((Object)("min sum=" + min + ", max=" + this.max + ", max payment sum=" + this.maxPay + ",max input sum=" + this.service.getMaxInputSum() + ", operation sum=" + opr));
        if (min != null && opr != null && opr.compareTo(min) < 0) {
            this.log.info((Object)("Fix min sum to=" + opr));
            min = opr;
        }
        Sum requireSum = null;
        if (opr != null && !opr.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)opr, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
        }
        if (requireSum == null && min.equals((Object)this.max)) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
            requireSum = this.roundRequireSum(requireSum);
        }
        if (requireSum == null && min != null && !min.isEmpty()) {
            requireSum = CommissionCalculator.calculate((Sum)min, (Commission)c, (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
            requireSum = this.roundRequireSum(requireSum);
        }
        if (requireSum != null) {
            this.log.info((Object)("Required sum: " + requireSum));
        }
        sumScreen.setListener(this.listener);
        this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)sumScreen));
        this.payDetector = new PayDetector(this.service, c, min, this.maxPay, opr, environment.getDateOfStartPayment(), null, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        this.keeperListener = new BaseKeeperListener(this.context, environment.getLocale(), sumScreen, requireSum, pack.getMinSum(), this.service, this.payDetector, this.service.isAutoFinishPayment(), this.listener, pack.isAllowReturn());
        this.enableCashManager(Session.getInstance().getCurrentKeeper());
        MediaPlayer.getInstance().play("pay_data.mp3");
    }

    @Override
    public void cancel(Intent intent) {
        this._cancel(intent);
    }

    private void enableCashManager(Keeper parent) {
        if (parent != null) {
            this.log.info((Object)("Enable cash manager with keeper: " + parent));
        }
        CashManager.getDefaultInstance().enable(parent, this.max, this.environment.getAllowedNotes(), this.environment.getAllowedCoins(), (KeeperObserver)this.keeperListener, CashMobuleHelper.getAllowDevices(this.service, parent == null ? false : !parent.getCashBackCards().isEmpty()), false);
    }

    private void _cancel(Intent intent) {
        boolean timeout;
        this.log.info((Object)"Cancel was requested on payment module");
        Keeper current = CashManager.getDefaultInstance().current();
        boolean bl = timeout = intent.getType() == 0;
        if (current.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            final Keeper keeper = CashManager.getDefaultInstance().disable();
            if (keeper.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process intent");
                Session.getInstance().getPack().setKeeper(keeper);
                intent.process();
            } else {
                this.log.info((Object)("New keeper state: " + keeper));
                if (intent.getType() == 3) {
                    this.log.info((Object)"Can't do back action. Enable devices again");
                    this.enableCashManager(keeper);
                    ModuleHelper.invoke(this.cancelListener);
                } else if (this.payDetector.canPay(this.payDetector.calculate(keeper))) {
                    this.log.info((Object)"Payment can be processed, ask question");
                    final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MediaPlayer.getInstance().play("under_min_sum.mp3");
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)NtspayCashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)NtspayCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    NtspayCashPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                    if (userCase == UserCase.Cancel) {
                                        NtspayCashPaymentModule.this.log.info((Object)"Process cancel");
                                        NtspayCashPaymentModule.this.process(keeper, userCase, timeout);
                                    } else {
                                        NtspayCashPaymentModule.this.log.info((Object)"Enable devices again");
                                        NtspayCashPaymentModule.this.enableCashManager(keeper);
                                        ModuleHelper.invoke(NtspayCashPaymentModule.this.cancelListener);
                                    }
                                }
                            });
                            dialog.show(NtspayCashPaymentModule.this.context.getShell());
                        }
                    });
                } else {
                    this.log.info((Object)"Payment can't be processed. Cancel payment");
                    this.process(keeper, UserCase.Cancel, timeout);
                }
            }
        } else {
            this.log.info((Object)"Keeper is not empty. Disable cash devices");
            if (this.payDetector.canPay(this.payDetector.calculate(current))) {
                String messageId;
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                this.log.info((Object)"The amount is sufficient for the payment, ask question");
                String string = messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                if (intent.getType() == 3) {
                    Session.getInstance().getPack().setKeeper(keeper);
                    intent.process();
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)NtspayCashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)4, (Locale)NtspayCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    NtspayCashPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                    NtspayCashPaymentModule.this.process(keeper, userCase, timeout);
                                }
                            });
                            dialog.show(NtspayCashPaymentModule.this.context.getShell());
                        }
                    });
                }
            } else {
                this.log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                if (intent.getType() == 3) {
                    Session.getInstance().getPack().setKeeper(keeper);
                    intent.process();
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.payment.cancel.continue", (Locale)NtspayCashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)NtspayCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    NtspayCashPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                    if (userCase == UserCase.Cancel) {
                                        NtspayCashPaymentModule.this.log.info((Object)"Disable cash devices");
                                        NtspayCashPaymentModule.this.process(keeper, userCase, timeout);
                                    } else {
                                        NtspayCashPaymentModule.this.enableCashManager(keeper);
                                        ModuleHelper.invoke(NtspayCashPaymentModule.this.cancelListener);
                                    }
                                }
                            });
                            dialog.show(NtspayCashPaymentModule.this.context.getShell());
                        }
                    });
                }
            }
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        this.log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = this.payDetector.calculate(keeper);
        if (this.service.getDivideSum() != null && !this.service.getDivideSum().isEmpty() && userCase == UserCase.Ok && pkg.getPayments().size() == 1) {
            Sum totalInput = new Sum(sumResult.getOut());
            Sum divSum = this.service.getDivideSum();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getBasicSum() / divSum.getBasicSum();
            if (!totalInput.divRest(divSum).isEmpty()) {
                ++count;
            }
            --count;
            Payment payment = (Payment)pkg.getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                pkg.getPayments().add(payment1);
            }
            pkg.setSumDistributionType("consistent");
        }
        if (pkg.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                p.setSumOut(sumResult.getOut());
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private Sum roundRequireSum(Sum requireSum) {
        int ost;
        CashUnit[] cashUnits;
        if (requireSum == null) {
            return requireSum;
        }
        if (CashDeviceManager.getInstance().getDefaultCoinValidator() == null && (cashUnits = CashFactory.getDefaultInstance().getCashUnits()) != null && cashUnits.length > 0 && (ost = requireSum.getBasicSum() % cashUnits[0].getNominal().getBasicSum()) > 0) {
            return requireSum.add(cashUnits[0].getNominal().sub(new Sum(ost)));
        }
        return requireSum;
    }

    private class DialogRunnable
    implements Runnable {
        private String text;

        public DialogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, this.text, 10, DC.cases((int)1, (Locale)NtspayCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    NtspayCashPaymentModule.this.enableCashManager(NtspayCashPaymentModule.this.cbcKeeper);
                    NtspayCashPaymentModule.this.cbcKeeper = null;
                }
            });
            NtspayCashPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class PincodeActivator
    implements Task {
        private String pin;

        public PincodeActivator(String pin) {
            this.pin = pin;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.cbc.wait");
        }

        @Override
        public Object execute() {
            Sum localMaxSum;
            Sum sum = localMaxSum = NtspayCashPaymentModule.this.payToolServiceLimit != null ? NtspayCashPaymentModule.this.payToolServiceLimit.getMaxSum() : NtspayCashPaymentModule.this.max;
            if (localMaxSum == null || localMaxSum.isEmpty()) {
                NtspayCashPaymentModule.this.log.info((Object)"Max sum is not specify. Return error");
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            if (localMaxSum.compareTo(NtspayCashPaymentModule.this.cbcKeeper.getSum()) <= 0) {
                NtspayCashPaymentModule.this.log.info((Object)("Keeper reached max sum. Return error. Max=" + localMaxSum + ", keeper=" + NtspayCashPaymentModule.this.cbcKeeper.getSum()));
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            Sum rest = localMaxSum.sub(NtspayCashPaymentModule.this.cbcKeeper.getSum());
            NtspayCashPaymentModule.this.log.info((Object)("Maximum nominal: " + localMaxSum));
            NtspayCashPaymentModule.this.log.info((Object)("Allowed rest: " + rest));
            try {
                return NtspayCashPaymentModule.this.context.getServerConnector().acivateCashBackCard(this.pin, new Sum(), localMaxSum.sub(NtspayCashPaymentModule.this.cbcKeeper.getSum()), SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            NtspayCashPaymentModule.this.log.info((Object)("Result: " + object));
            String text = null;
            if (object instanceof ActivationResult) {
                ActivationResult ar = (ActivationResult)object;
                if (ar.getError() == ActivationResultType.Ok) {
                    CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
                    cbc.setNominal(ar.getRest());
                    cbc.setRef(ar.getIdOperation());
                    NtspayCashPaymentModule.this.cbcKeeper.addCashBackCard(cbc);
                    NtspayCashPaymentModule.this.enableCashManager(NtspayCashPaymentModule.this.cbcKeeper);
                    NtspayCashPaymentModule.this.cbcKeeper = null;
                    return;
                }
                text = B.get((String)("Request.cbc.err." + ar.getError()), (Locale)NtspayCashPaymentModule.this.environment.getLocale());
            } else {
                text = B.get((String)("Request.cbc.err." + ActivationResultType.ErrNetwork), (Locale)NtspayCashPaymentModule.this.environment.getLocale());
            }
            EventQueue.invokeLater(new DialogRunnable(text));
        }
    }

    private class LocalPinCodeListener
    implements CustomDialogListener {
        private LocalPinCodeListener() {
        }

        public void onClose(Object type) {
            ModuleHelper.invoke(NtspayCashPaymentModule.this.cancelListener);
            if (type != null) {
                String pincode = (String)type;
                NtspayCashPaymentModule.this.log.info((Object)("Input pincode: " + pincode));
                ModuleHelper.invoke(NtspayCashPaymentModule.this.cancelListener);
                NtspayCashPaymentModule.this.context.getTaskExecutor().execute(new PincodeActivator(pincode));
            } else {
                NtspayCashPaymentModule.this.log.info((Object)"Close pincode screen");
                ModuleHelper.invoke(NtspayCashPaymentModule.this.cancelListener);
                NtspayCashPaymentModule.this.enableCashManager(NtspayCashPaymentModule.this.cbcKeeper);
                NtspayCashPaymentModule.this.cbcKeeper = null;
                NtspayCashPaymentModule.this.context.getShell().showPopup(null);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtspayCashPaymentModule.this.log.info((Object)("Action on sum screen: " + action));
            NtspayCashPaymentModule.this.cancelListener = cancelListener;
            if (ActionType.isCbc((String)action)) {
                NtspayCashPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                NtspayCashPaymentModule.this.log.info((Object)("Keeper: " + NtspayCashPaymentModule.this.cbcKeeper));
                if (!CashMobuleHelper.isAllowCBC(NtspayCashPaymentModule.this.service, !NtspayCashPaymentModule.this.cbcKeeper.getCashSum().isEmpty())) {
                    NtspayCashPaymentModule.this.log.info((Object)"CBC disable for this service ");
                    NtspayCashPaymentModule.this.enableCashManager(NtspayCashPaymentModule.this.cbcKeeper);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                NtspayCashPaymentModule.this.pinScreen.init(NtspayCashPaymentModule.this.environment.getLocale());
                CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)NtspayCashPaymentModule.this.pinScreen, Math.min(30, NtspayCashPaymentModule.this.getInactivityTimeout() - 5), null, true);
                cpd.addListener((CustomDialogListener)new LocalPinCodeListener());
                NtspayCashPaymentModule.this.context.showDialog((DialogInterface)cpd);
            } else if (ActionType.isExit((String)action)) {
                NtspayCashPaymentModule.this.cancel(new ExitIntent(NtspayCashPaymentModule.this.context, 2));
            } else if (ActionType.isPrev((String)action)) {
                NtspayCashPaymentModule.this.cancel(new BackIntent(NtspayCashPaymentModule.this.environment.getInputModule()));
            } else if (ActionType.isNext((String)action)) {
                NtspayCashPaymentModule.this.log.info((Object)"Disable devices again");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                if (keeper.getSum().isEmpty()) {
                    NtspayCashPaymentModule.this.log.info((Object)"Enable devices again");
                    NtspayCashPaymentModule.this.enableCashManager(keeper);
                    ModuleHelper.invoke(cancelListener);
                } else {
                    SumResult sr = NtspayCashPaymentModule.this.payDetector.calculate(keeper);
                    if (NtspayCashPaymentModule.this.payDetector.canPay(sr)) {
                        NtspayCashPaymentModule.this.process(keeper, UserCase.Ok, false);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MediaPlayer.getInstance().play("under_min_sum.mp3");
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.getchange", (Locale)NtspayCashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)2, (Locale)NtspayCashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        NtspayCashPaymentModule.this.log.info((Object)("User make choise " + userCase));
                                        if (userCase == UserCase.Cancel) {
                                            NtspayCashPaymentModule.this.log.info((Object)"Process cancel");
                                            NtspayCashPaymentModule.this.process(keeper, userCase, false);
                                        } else {
                                            NtspayCashPaymentModule.this.log.info((Object)"Enable devices again");
                                            NtspayCashPaymentModule.this.enableCashManager(keeper);
                                            ModuleHelper.invoke(cancelListener);
                                        }
                                    }
                                });
                                dialog.show(NtspayCashPaymentModule.this.context.getShell());
                            }
                        });
                    }
                }
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Unknown action on sumscreen: " + action);
            }
        }

        public void onLocale(Locale locale) {
            NtspayCashPaymentModule.this.environment.setLocale(locale);
        }
    }
}

