/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import i18n.B;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.UpdateCustomFullnessTask;

public class UpdateFullnessScreenListener
extends ScreenAdapter {
    private Restorable parent;
    private ApplicationContext context;
    private Environment env;
    private Runnable cancelListener;
    private Map<String, Object> data;
    private CoffeeContextStub coffeeContext;

    public UpdateFullnessScreenListener(Restorable parent, ApplicationContext context, Environment env) {
        this.parent = parent;
        this.context = context;
        this.env = env;
        this.coffeeContext = new CoffeeContextStub(context);
    }

    public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.cancelListener = cancelListener;
        this.data = data;
        if (ActionType.isNext((String)action)) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.message.update-fullness.mode", (Locale)this.env.getLocale()), 10, DC.cases((int)28), UserCase.Ok);
            dialog.addListener((DialogListener)new LocalDialogListener());
            this.context.showDialog((DialogInterface)dialog);
        } else if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
            this.parent.restore();
        } else {
            ModuleHelper.invoke(cancelListener);
        }
    }

    public void onLocale(Locale locale) {
    }

    public void onRedirect(int serviceId) {
    }

    private class LocalDialogListener
    implements DialogListener {
        private LocalDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            try {
                InputElement container = (InputElement)UpdateFullnessScreenListener.this.data.get("container");
                InputElement fullness = (InputElement)UpdateFullnessScreenListener.this.data.get("fullness");
                InputElement currFullness = (InputElement)UpdateFullnessScreenListener.this.data.get("curr-fullness");
                InputElement currRange = (InputElement)UpdateFullnessScreenListener.this.data.get("curr-range");
                double curr = Double.parseDouble(currFullness.getValue());
                if (userCase == UserCase.Cancel) {
                    curr = 0.0;
                }
                UpdateFullnessScreenListener.this.coffeeContext.getTaskExecutor().execute(new UpdateCustomFullnessTask(UpdateFullnessScreenListener.this.parent, UpdateFullnessScreenListener.this.context, UpdateFullnessScreenListener.this.env, Integer.parseInt(container.getValue()) - 1, Double.parseDouble(fullness.getValue()) * (double)Integer.parseInt(currRange.getValue()), curr));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ModuleHelper.invoke(UpdateFullnessScreenListener.this.cancelListener);
            }
        }
    }
}

