/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.StatusCM;
import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.FullnessUpdateTask;
import ru.softlogic.system.util.ErrorStringUtil;

public class UpdateCustomFullnessTask
implements Task {
    private Restorable parent;
    private ApplicationContext context;
    private Environment env;
    private Logger log;
    private int container;
    private double fullness;
    private double currFullness;
    private CoffeeContextStub coffeeContext;

    public UpdateCustomFullnessTask(Restorable parent, ApplicationContext context, Environment env, int container, double fullness, double currFullness) {
        this.parent = parent;
        this.context = context;
        this.log = Logger.getLogger((String)"pay");
        this.container = container;
        this.fullness = fullness;
        this.currFullness = currFullness;
        this.env = env;
        this.coffeeContext = new CoffeeContextStub(context);
    }

    @Override
    public String getMessage() {
        return B.get((String)"Module.input.coffee.request.wait", (Locale)this.env.getLocale());
    }

    @Override
    public Object execute() {
        this.log.info((Object)"Start coffemat status task");
        try {
            StatusCM status = CoffeeMachine.getDefaultInstance().getStatus();
            if (status.getMode() != 0 && status.getMode() != -1 && status.getStatus() != 1001) {
                this.log.info((Object)("Update fullness CONT=" + this.container + " FULL=" + this.fullness + " CURR-FULL=" + this.currFullness));
                CoffeeMachine.getDefaultInstance().updateFullness(this.container, this.fullness + this.currFullness);
                return B.get((String)"Module.input.coffee.message.update-fullness.success", (Locale)this.env.getLocale());
            }
            return status;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)("Recived answer: " + object));
        if (object != null && object instanceof StatusCM) {
            StatusCM statusCM = (StatusCM)object;
            if (statusCM.getMode() == 0 || statusCM.getMode() == -1 || statusCM.getStatus() == 1001) {
                this.log.info((Object)"Status error ");
                this.showError(object);
            } else {
                this.log.info((Object)"Status ok ");
            }
        } else {
            this.showError(object);
        }
    }

    private void showError(Object object) {
        ProblemNotifier.getDefaultNotifier().onProblem(ErrorStringUtil.getErrorEventMessageByObject(object));
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, ErrorStringUtil.getErrorDialogMessageByObject(this.env.getLocale(), object), 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                UpdateCustomFullnessTask.this.coffeeContext.getTaskExecutor().execute(new FullnessUpdateTask(UpdateCustomFullnessTask.this.parent, UpdateCustomFullnessTask.this.context, UpdateCustomFullnessTask.this.env));
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }
}

