/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.StatusCM;
import coffee.machine.model.StatusChangeMode;
import coffee.machine.model.code.CMM;
import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.task.Task;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;

public class StatusTask
implements Task {
    private StatusActionListener actionListener;
    private String message;
    private Logger log;
    private Integer switchMode;
    private Locale locale;

    public StatusTask(StatusActionListener actionListener, String message, Integer switchMode, Locale locale) {
        this.actionListener = actionListener;
        this.message = message;
        this.switchMode = switchMode;
        this.locale = locale;
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object execute() {
        this.log.info((Object)"Start coffemat status task");
        try {
            StatusCM status = CoffeeMachine.getDefaultInstance().getStatus();
            if (this.switchMode != null && status != null && status.getMode() != this.switchMode.intValue()) {
                this.log.info((Object)("Set mode " + CMM.getString((int)this.switchMode)));
                StatusChangeMode sm = CoffeeMachine.getDefaultInstance().setMode(this.switchMode.intValue());
                if (!sm.isSuccess() || sm.getMode() != this.switchMode.intValue()) {
                    return B.get((String)"Module.input.coffee.message.error.mode", (Locale)this.locale);
                }
                status = CoffeeMachine.getDefaultInstance().getStatus();
            }
            return status;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)("Recived answer: " + object));
        if (object != null && object instanceof StatusCM) {
            StatusCM statusCM = (StatusCM)object;
            if (statusCM.getMode() == 0 || statusCM.getMode() == -1 || statusCM.getStatus() == 1001) {
                this.log.info((Object)"Status error ");
                this.actionListener.onError(statusCM);
            } else {
                this.log.info((Object)"Status ok ");
                this.actionListener.onSuccess();
            }
        } else {
            this.actionListener.onError(object);
        }
    }
}

