/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.Drink;
import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;
import ru.softlogic.module.input.ntscoffee.StatusTask;
import ru.softlogic.module.processing.ObsoleteProcessingModule;

public class NtsCoffeeProcessingModule
extends ObsoleteProcessingModule {
    private Drink drink;
    public static final String DRINK_KEY = "#coffee.drink";
    private Locale locale;
    private CoffeeContextStub coffeeContext;

    public NtsCoffeeProcessingModule(ApplicationContext context) {
        super(context);
        this.coffeeContext = new CoffeeContextStub(context, "coffee-final");
    }

    @Override
    protected void _process(final Environment env) {
        this.locale = env.getLocale();
        try {
            if (!Session.getInstance().getPack().isCancel() && Session.getInstance().getPack().getPaymentType() == 0) {
                Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                this.drink = (Drink)payment.getData().get(DRINK_KEY);
                StatusActionListener actionListener = new StatusActionListener(){

                    @Override
                    public void onSuccess() {
                        MediaPlayer.getInstance().play("done_thanks.mp3");
                        NtsCoffeeProcessingModule.super._process(env);
                    }

                    @Override
                    public void onError(Object object) {
                        NtsCoffeeProcessingModule.this.cancelPay(object, env);
                    }
                };
                this.coffeeContext.getTaskExecutor().execute(new LocalWait4FinishAction(actionListener, log, B.get((String)"Module.processing.coffee.making.wait", (Locale)env.getLocale())));
            } else {
                log.info((Object)"No need to prepare drink ");
                super._process(env);
            }
        }
        catch (Exception e) {
            this.cancelPay(e, env);
        }
    }

    private void cancelPay(Object object, Environment env) {
        String paymentModuleName = null;
        if (env.getMenuItem() != null && env.getMenuItem().getService() != null && env.getMenuItem().getService().getModules() != null && env.getMenuItem().getService().getModules().getPayment() != null && !env.getMenuItem().getService().getModules().getPayment().isEmpty()) {
            paymentModuleName = env.getMenuItem().getService().getModules().getPayment();
        }
        if ("cashless-auto".equals(paymentModuleName)) {
            DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Custom, B.get((String)"Module.present.coffee.take.error", (Locale)env.getLocale()), 15, DC.cases((int)1, (Locale)env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            Session.getInstance().setCurrentKeeper(null);
            dialog.addListener((DialogListener)new LocalCustomExitDialogListener());
            this.context.showDialog((DialogInterface)dialog);
        } else {
            ModuleHelper.cancelPack(Session.getInstance().getPack());
            ProblemNotifier.notifyProblem((String)("Error in NtsCoffeeProcessingModule: " + object));
            NtsCoffeeProcessingModule.super._process(env);
        }
    }

    private class LocalCustomExitDialogListener
    implements DialogListener {
        private LocalCustomExitDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            log.info((Object)"Goto main menu");
            NtsCoffeeProcessingModule.this.context.toMainMenu();
            Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.finish", (Locale)NtsCoffeeProcessingModule.this.locale));
        }
    }

    private class LocalWait4FinishAction
    extends StatusTask {
        public LocalWait4FinishAction(StatusActionListener actionListener, Logger log, String message) {
            super(actionListener, message, null, NtsCoffeeProcessingModule.this.locale);
        }

        @Override
        public Object execute() {
            Exception object;
            try {
                MediaPlayer.getInstance().play("preparing_drink.mp3");
                CoffeeMachine.getDefaultInstance().prepareDrink(NtsCoffeeProcessingModule.this.drink);
                object = CoffeeMachine.getDefaultInstance().getStatus();
            }
            catch (Exception ex) {
                object = ex;
            }
            return object;
        }
    }
}

