/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.model.Drink;
import i18n.B;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.module.ending.BaseEndingModule;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ntscoffee.NtsCoffeePresentModule;
import ru.softlogic.reference.adv.Promo;

public class NtsCoffeeEndingModule
extends BaseEndingModule {
    private Logger log = Logger.getLogger((String)"pay");
    private Environment env;

    public NtsCoffeeEndingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public void _end(Environment environment) {
        this.env = environment;
        Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
        if (data.get("#coffee.bonus.drink") instanceof Drink) {
            this.log.info((Object)"Skip ending module for bonus");
            environment.getReinitModule().process(environment);
        } else {
            Pack pack = Session.getInstance().getPack();
            String support = environment.getDealer().getSupport();
            String name = environment.getPaymentSystem().getName();
            Locale locale = environment.getLocale();
            String message = null;
            String suffix = "";
            if (((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().get("#coffee.drink") instanceof Drink) {
                suffix = ".coffee";
            }
            if (pack.isCancel()) {
                this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
                message = support != null && !support.isEmpty() ? MessageFormat.format(B.get((String)(Session.getInstance().getPack().getPaybackType() == 1 ? "Provider.payment.cancel" + suffix : "Provider.payment.cancel.service" + suffix), (Locale)locale), support) : B.get((String)(Session.getInstance().getPack().getPaybackType() == 1 ? "Provider.payment.cancel.general" + suffix : "Provider.payment.cancel.service.general" + suffix), (Locale)locale);
            } else if (pack.isUnknownProcessResult()) {
                message = !pack.getSumResult().getChange().isEmpty() ? (support != null && !support.isEmpty() ? MessageFormat.format(B.get((String)("Provider.payment.unknown.change" + suffix), (Locale)locale), support) : B.get((String)("Provider.payment.unknown.change.general" + suffix), (Locale)locale)) : (support != null && !support.isEmpty() ? MessageFormat.format(B.get((String)("Provider.payment.unknown" + suffix), (Locale)locale), support) : B.get((String)("Provider.payment.unknown.general" + suffix), (Locale)locale));
            } else {
                if (this.isGift()) {
                    this.log.info((Object)"Skip ending module for bonus");
                    environment.getReinitModule().process(environment);
                    return;
                }
                message = !pack.getSumResult().getChange().isEmpty() ? (name != null && !name.isEmpty() ? MessageFormat.format(B.get((String)(Session.getInstance().getPack().getPaybackType() == 1 ? "Provider.payment.complete.cbc" + suffix : "Provider.payment.complete.service" + suffix), (Locale)locale), name) : B.get((String)(Session.getInstance().getPack().getPaybackType() == 1 ? "Provider.payment.complete.cbc.general" + suffix : "Provider.payment.complete.service.general" + suffix), (Locale)locale)) : (name != null && !name.isEmpty() ? MessageFormat.format(B.get((String)("Provider.payment.complete" + suffix), (Locale)locale), name) : B.get((String)("Provider.payment.complete.general" + suffix), (Locale)locale));
            }
            EventQueue.invokeLater(new DialogRunner(message));
        }
    }

    private boolean isGift() {
        Sum sum = Session.getInstance().getPack().getSumResult().getOutProv() == null || Session.getInstance().getPack().getSumResult().getOutProv().isEmpty() ? Session.getInstance().getPack().getSumResult().getOut() : Session.getInstance().getPack().getSumResult().getOutProv();
        Date date = new Date();
        for (Promo promo : this.env.getPromos()) {
            if (!NtsCoffeePresentModule.isUsed(promo, sum, date, Session.getInstance().getPack().getService().getId(), Session.getInstance().getPack().getService().getCode(), this.log)) continue;
            return true;
        }
        return false;
    }

    private class DialogRunner
    implements Runnable {
        private String message;

        public DialogRunner(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            NtsCoffeeEndingModule.this.log.info((Object)"Show a grateful dialog");
            Map data = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
            if (data.get("#coffee.drink") instanceof Drink) {
                DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Custom, this.message, 10, DC.cases((int)1, (Locale)NtsCoffeeEndingModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        NtsCoffeeEndingModule.this.log.info((Object)"Dialog closed");
                        NtsCoffeeEndingModule.this.env.getReinitModule().process(NtsCoffeeEndingModule.this.env);
                    }
                });
                NtsCoffeeEndingModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                DialogScreen dialog = ComponentFactory.getInstance().createCompleteDialog(DialogType.Info, this.message, 10, DC.cases((int)1, (Locale)NtsCoffeeEndingModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        NtsCoffeeEndingModule.this.log.info((Object)"Dialog closed");
                        NtsCoffeeEndingModule.this.env.getReinitModule().process(NtsCoffeeEndingModule.this.env);
                    }
                });
                NtsCoffeeEndingModule.this.context.showDialog((DialogInterface)dialog);
            }
        }
    }
}

