/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.Drink;
import coffee.machine.model.Ingredient;
import i18n.B;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdSetVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.DigitalFilter;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.completive.CompletiveModule;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;
import ru.softlogic.module.input.ntscoffee.StatusTask;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.module.payout.PayoutModule;
import ru.softlogic.module.present.PresentModule;
import ru.softlogic.module.print.PrintModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.module.reinit.ReinitModule;
import ru.softlogic.reference.adv.Promo;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.system.util.ErrorStringUtil;

public class NtsCoffeeBonusInputModule
extends BaseInputModule {
    private static final String MENU_ITEM_KEY = "menu-item";
    private Environment environment;
    private Restorable parent;
    private Map<String, Drink> drinks;
    private CommonScreen currentScreen;
    private StatusActionListener statusActionListener;
    private Locale locale;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();
    private Drink currentDrink;
    private CoffeeContextStub coffeeContext;

    public NtsCoffeeBonusInputModule(ApplicationContext context) {
        super(context);
        this.statusActionListener = new LocalStatusListener();
        this.coffeeContext = new CoffeeContextStub(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.log.info((Object)"Start coffee sale");
        this.locale = environment.getLocale();
        this.environment = environment;
        this.parent = parent;
        this.drinks = null;
        List<Promo> promos = this.getCurrentPromos();
        if (promos.isEmpty()) {
            this.showError(B.get((String)"Module.input.coffee.error.no-promos", (Locale)this.locale));
            return;
        }
        this.coffeeContext.getTaskExecutor().execute(new StatusTask(this.statusActionListener, B.get((String)"Module.input.coffee.request.wait", (Locale)this.locale), 2, this.locale));
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.context.showScreen(new ContentScreenAdapter(this.currentScreen));
    }

    @Override
    public void cancel(Intent intent) {
        super.cancel(intent);
    }

    private void toShowBonusInfoScreen() {
        InfoScreenDescription sd = new InfoScreenDescription("info-coffee-bonus");
        sd.setTitle(B.get((String)"Module.input.coffee.promo.title", (Locale)this.locale));
        sd.setDecor("simple");
        sd.setInfo(B.get((String)"Module.input.coffee.promo.text", (Locale)this.locale));
        sd.setButtons(InitModuleHelper.createKeyMap());
        CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
        try {
            cs.init((ScreenDescription)sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
            cs.setListener((ScreenListener)new LocalInfoBonusListener());
            this.context.showScreen(new ContentScreenAdapter(cs));
            this.currentScreen = cs;
        }
        catch (InitException ex) {
            this.log.info((Object)ex, (Throwable)ex);
        }
    }

    private void toShowShelfProducts() {
        this.log.info((Object)"Show select products screen");
        if (this.drinks != null) {
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Drink d : this.drinks.values()) {
                SelectorItem si = new SelectorItem("" + d.getNameDrink(), "" + d.getId());
                HashMap<String, Drink> data = new HashMap<String, Drink>();
                data.put("#coffee.bonus.drink", d);
                si.setCustomData(data);
                si.setData(new Data());
                items.add(si);
            }
            SelectorField sf = new SelectorField();
            sf.setStore((ItemsStore)new StaticStore(items));
            LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
            fields.add(sf);
            ScreenDescription sd = new ScreenDescription("selector-coffee");
            sd.setTitle(B.get((String)"Module.input.coffee.products.title", (Locale)this.locale));
            sd.setDecor("coffee-image");
            sd.setSequence(new FieldSequence(fields));
            sd.setButtons(InitModuleHelper.createKeyMap());
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            try {
                cs.init(sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalSelectProductListener());
                this.context.showScreen(new ContentScreenAdapter(cs));
                this.currentScreen = cs;
                MediaPlayer.getInstance().play("select_drink.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.empty", (Locale)this.locale));
        }
    }

    private void toShowProductPage(Drink drink) {
        if (drink != null) {
            Keyboard kbr = new Keyboard(KeyboardType.Digital);
            NumericField nf = new NumericField();
            nf.setId("sugar");
            nf.setTitle(B.get((String)"Module.input.coffee.sugar.amount", (Locale)this.locale));
            nf.setKeyboard(kbr);
            nf.setFilter((Filter)new DigitalFilter(false));
            nf.setFormatter((Formatter)new VoidFormatter());
            nf.setDataFormatter((Formatter)new VoidFormatter());
            nf.setModificator((Modificator)new VoidModificator());
            nf.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range(0.0f, 6.0f))));
            nf.setUnitCount(1);
            nf.setDecimalCount(1);
            nf.setDefaultValue(drink.isNeedSugar() ? "2" : String.valueOf(drink.getSugar()));
            FieldSequence fs = new FieldSequence();
            fs.setFields(Arrays.asList(nf));
            ScreenDescription sd = new ScreenDescription();
            sd.setTitle(drink.getFullNameDrink());
            sd.setSequence(fs);
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            buttons.put("Prev", new ButtonInit(null));
            buttons.put("Exit", new ButtonInit(null));
            buttons.put("Next", new ButtonInit(null));
            sd.setButtons(buttons);
            CommonScreen cs = CommonScreenStore.getScreen((String)"coffee-info");
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("#sugar", drink.isNeedSugar());
                hashMap.put("#drink-id", String.valueOf(drink.getId()));
                LinkedList<String> ings = new LinkedList<String>();
                if (drink.getIngredients() != null) {
                    for (Ingredient i : drink.getIngredients()) {
                        String[] name = CoffeeHelper.getIngredientName(i.getId());
                        if (name == null) continue;
                        ings.add(name[0] + ": " + i.getAmount() + " " + name[1]);
                    }
                }
                hashMap.put("#ingredients", ings);
                cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, hashMap));
                cs.setListener((ScreenListener)new LocalSelectSugarListener(drink));
                this.context.showScreen(new ContentScreenAdapter(cs));
                this.currentScreen = cs;
                MediaPlayer.getInstance().play("select_sugar.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.notset", (Locale)this.locale));
        }
    }

    private void toShowServicesScreen() {
        List<Promo> promos = this.getCurrentPromos();
        HashSet<Integer> srvs = new HashSet<Integer>();
        String services = AppDefaults.getInstance().getStringValue("Coffee.promo.services", null);
        if (services != null) {
            String[] split;
            for (String service : split = services.split(",")) {
                try {
                    srvs.add(Integer.parseInt(service.trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (Promo p : promos) {
                String[] split;
                for (String service : split = p.getServices().split(",")) {
                    try {
                        srvs.add(Integer.parseInt(service.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        MenuByServiceIdSetVisitor mv = new MenuByServiceIdSetVisitor(srvs);
        MenuUtils.processMenu((MenuVisitor)mv);
        List menuItems = mv.getMenuItem();
        MenuItem[] mis = new MenuItem[menuItems.size()];
        menuItems.toArray(mis);
        Arrays.sort(mis, new LocalComparator());
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (MenuItem mi : mis) {
            SelectorItem si = new SelectorItem(mi.getService().getName(), "" + mi.getService().getId(), "" + mi.getService().getId(), mi.getService().getImage(), true);
            HashMap<String, MenuItem> data = new HashMap<String, MenuItem>();
            data.put(MENU_ITEM_KEY, mi);
            si.setCustomData(data);
            si.setData(new Data());
            items.add(si);
        }
        SelectorField sf = new SelectorField();
        sf.setStore((ItemsStore)new StaticStore(items));
        LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
        fields.add(sf);
        ScreenDescription sd = new ScreenDescription("selector");
        sd.setTitle(B.get((String)"Module.input.coffee.services.title", (Locale)this.locale));
        sd.setDecor("coffee-menu");
        sd.setSequence(new FieldSequence(fields));
        sd.setButtons(InitModuleHelper.createKeyMap());
        CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
        try {
            cs.init(sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
            cs.setListener((ScreenListener)new LocalSelectServiceListener());
            this.context.showScreen(new ContentScreenAdapter(cs));
            this.currentScreen = cs;
        }
        catch (InitException ex) {
            this.log.info((Object)ex, (Throwable)ex);
        }
    }

    private void showError(Object object) {
        ProblemNotifier.getDefaultNotifier().onProblem(ErrorStringUtil.getErrorEventMessageByObject(object));
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, ErrorStringUtil.getErrorDialogMessageByObject(this.locale, object), 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener((DialogListener)new LocalExitDialogListener());
        this.context.showDialog((DialogInterface)dialog);
    }

    private List<Promo> getCurrentPromos() {
        LinkedList<Promo> promos = new LinkedList<Promo>();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (this.environment.getPromos() != null) {
            Date cur = new Date();
            for (Promo p : this.environment.getPromos()) {
                if (p.getBegin() == null || p.getBegin().after(cur) || p.getEnd() != null && p.getEnd().before(cur) || p.getPrizeType() != 1) continue;
                promos.add(p);
            }
        }
        return promos;
    }

    private class LocalComparator
    implements Comparator<MenuItem> {
        private LocalComparator() {
        }

        @Override
        public int compare(MenuItem o1, MenuItem o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1.getSortOrder() == o2.getSortOrder()) {
                return 0;
            }
            if (o1.getSortOrder() < o2.getSortOrder()) {
                return -1;
            }
            return 1;
        }
    }

    private class LocalStatusListener
    implements StatusActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void onSuccess() {
            NtsCoffeeBonusInputModule.this.toShowBonusInfoScreen();
        }

        @Override
        public void onError(Object object) {
            NtsCoffeeBonusInputModule.this.showError(object);
        }
    }

    private class LocalExitDialogListener
    implements DialogListener {
        public void dialogClosed(UserCase userCase) {
            NtsCoffeeBonusInputModule.this.cancel(null);
        }
    }

    private class GetDrinksTask
    implements Task {
        @Override
        public Object execute() {
            Serializable object;
            try {
                object = CoffeeMachine.getDefaultInstance().getDrinks();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NtsCoffeeBonusInputModule.this.log.error((Object)ex, (Throwable)ex);
                object = ex;
            }
            return object;
        }

        @Override
        public void onResult(Object object) {
            NtsCoffeeBonusInputModule.this.log.info((Object)("Recived answer: " + object));
            if (object != null) {
                if (object instanceof Exception) {
                    NtsCoffeeBonusInputModule.this.showError(object);
                } else if (object instanceof Map) {
                    NtsCoffeeBonusInputModule.this.drinks = (Map)object;
                    NtsCoffeeBonusInputModule.this.toShowShelfProducts();
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Module.input.coffee.products.request.wait", (Locale)NtsCoffeeBonusInputModule.this.locale);
        }
    }

    private class LocalSelectSugarListener
    extends ScreenAdapter {
        private Drink drink;

        private LocalSelectSugarListener(Drink drink) {
            this.drink = drink;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            NtsCoffeeBonusInputModule.this.cancelListener = cancelListener;
            NtsCoffeeBonusInputModule.this.log.info((Object)("Selector action: action = " + action + ", data = " + data));
            NtsCoffeeBonusInputModule.this.log.info((Object)("Data: " + data));
            NtsCoffeeBonusInputModule.this.data.putAll(data);
            if (ActionType.isPrev((String)action)) {
                NtsCoffeeBonusInputModule.this.toShowShelfProducts();
            } else if (ActionType.isExit((String)action)) {
                NtsCoffeeBonusInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                NtsCoffeeBonusInputModule.this.data.putAll(data);
                if (this.drink != null) {
                    InputElement inputElement = (InputElement)data.get("sugar");
                    int amountSugar = Integer.parseInt(inputElement.getValue());
                    this.drink.setSugar(amountSugar);
                    NtsCoffeeBonusInputModule.this.toShowServicesScreen();
                }
            }
        }

        public void onLocale(Locale locale) {
            if (NtsCoffeeBonusInputModule.this.environment != null) {
                NtsCoffeeBonusInputModule.this.environment.setLocale(locale);
            }
        }
    }

    private class LocalSelectServiceListener
    extends ScreenAdapter {
        private LocalSelectServiceListener() {
        }

        public final void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            NtsCoffeeBonusInputModule.this.cancelListener = cancelListener;
            NtsCoffeeBonusInputModule.this.log.info((Object)("Selector action: action = " + action));
            NtsCoffeeBonusInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action)) {
                NtsCoffeeBonusInputModule.this.toShowBonusInfoScreen();
            } else if (ActionType.isExit((String)action)) {
                NtsCoffeeBonusInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                MenuItem menuItem = (MenuItem)data.get(NtsCoffeeBonusInputModule.MENU_ITEM_KEY);
                HashMap<String, Object> pd = new HashMap<String, Object>();
                pd.put("#coffee.bonus.drink", NtsCoffeeBonusInputModule.this.currentDrink);
                PaymentModule paymentModule = NtsCoffeeBonusInputModule.this.environment.getPaymentModule();
                PayoutModule payoutModule = NtsCoffeeBonusInputModule.this.environment.getPayoutModule();
                ProcessingModule processingModule = NtsCoffeeBonusInputModule.this.environment.getProcessingModule();
                PrintModule printModule = NtsCoffeeBonusInputModule.this.environment.getPrintModule();
                EndingModule endingModule = NtsCoffeeBonusInputModule.this.environment.getEndingModule();
                ReinitModule reinitModule = NtsCoffeeBonusInputModule.this.environment.getReinitModule();
                PresentModule presentModule = NtsCoffeeBonusInputModule.this.environment.getPresentModule();
                CompletiveModule completiveModule = NtsCoffeeBonusInputModule.this.environment.getCompletiveModule();
                PaymentHelper.run(menuItem, (ApplicationContext)NtsCoffeeBonusInputModule.this.context, NtsCoffeeBonusInputModule.this.environment.getLocale(), (Restorable)NtsCoffeeBonusInputModule.this, paymentModule, payoutModule, processingModule, printModule, endingModule, reinitModule, presentModule, completiveModule, NtsCoffeeBonusInputModule.this.environment.isPrinterError(), pd, null);
                ModuleHelper.invoke(cancelListener);
            }
        }
    }

    private class LocalSelectProductListener
    extends ScreenAdapter {
        private LocalSelectProductListener() {
        }

        public final void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtsCoffeeBonusInputModule.this.cancelListener = cancelListener;
            NtsCoffeeBonusInputModule.this.log.info((Object)("Selector action: action = " + action));
            NtsCoffeeBonusInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action)) {
                NtsCoffeeBonusInputModule.this.toShowBonusInfoScreen();
            } else if (ActionType.isExit((String)action)) {
                NtsCoffeeBonusInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Drink drink = (Drink)data.get("#coffee.bonus.drink");
                NtsCoffeeBonusInputModule.this.currentDrink = drink;
                NtsCoffeeBonusInputModule.this.data.clear();
                if (drink.isAvailable()) {
                    NtsCoffeeBonusInputModule.this.toShowProductPage(drink);
                } else {
                    NtsCoffeeBonusInputModule.this.log.info((Object)"Show warning screen.");
                    NtsCoffeeBonusInputModule.this.log.info((Object)("" + drink.getNameDrink() + " is not available for prepare"));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.drink.available.false", (Locale)NtsCoffeeBonusInputModule.this.locale), 3, DC.cases((int)8, (Locale)NtsCoffeeBonusInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            ModuleHelper.invoke(cancelListener);
                        }
                    });
                    NtsCoffeeBonusInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
            ModuleHelper.invoke(cancelListener);
        }

        public void onLocale(Locale locale) {
            if (NtsCoffeeBonusInputModule.this.environment != null) {
                NtsCoffeeBonusInputModule.this.environment.setLocale(locale);
            }
        }
    }

    private class LocalInfoBonusListener
    extends ScreenAdapter {
        private LocalInfoBonusListener() {
        }

        public final void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            NtsCoffeeBonusInputModule.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
                NtsCoffeeBonusInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                NtsCoffeeBonusInputModule.this.toShowServicesScreen();
            }
        }

        public void onLocale(Locale locale) {
            if (NtsCoffeeBonusInputModule.this.environment != null) {
                NtsCoffeeBonusInputModule.this.environment.setLocale(locale);
            }
        }
    }
}

