/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.StatusCM;
import coffee.machine.model.StatusChangeMode;
import i18n.B;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.ntscoffee.MakeFastDrinkScreenListener;
import ru.softlogic.system.util.ErrorStringUtil;

public class MakeFastDrinkTask
implements Task {
    private Restorable parent;
    private ApplicationContext context;
    private Environment env;
    private String userName;
    private String userLogin;
    private Locale locale;
    private Logger log;

    public MakeFastDrinkTask(Restorable parent, ApplicationContext context, Environment env, String userName, String userLogin) {
        this.parent = parent;
        this.context = context;
        this.env = env;
        this.userName = userName;
        this.userLogin = userLogin;
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public String getMessage() {
        return B.get((String)"Module.input.coffee.request.wait", (Locale)this.locale);
    }

    @Override
    public Object execute() {
        this.log.info((Object)"Start coffemat status task");
        try {
            StatusCM status = CoffeeMachine.getDefaultInstance().getStatus();
            if (status.getMode() != 0 && status.getMode() != -1 && status.getStatus() != 1001) {
                if (status.getMode() != 4) {
                    this.log.info((Object)"Set master mode");
                    StatusChangeMode sm = CoffeeMachine.getDefaultInstance().setMode(4);
                    if (!sm.isSuccess() || sm.getMode() != 4) {
                        return B.get((String)"Module.input.coffee.message.error.master-mode", (Locale)this.locale);
                    }
                }
                HashMap fn = CoffeeMachine.getDefaultInstance().getDrinks();
                return fn;
            }
            return status;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)("Recived answer: " + object));
        if (object instanceof Map) {
            CommonScreen cs = CommonScreenStore.getScreen((String)"letter");
            try {
                ScreenDescription sd = CoffeeHelper.getCoffeeMakeScreenDescription((Map)object, this.env.getLocale());
                cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(this.env, new HashMap<String, Object>()));
            }
            catch (Exception ex) {
                this.showError(ex.getMessage());
            }
            cs.setListener((ScreenListener)new MakeFastDrinkScreenListener(this.parent, this.context, this.env.getLocale(), this.userName, this.userLogin));
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        } else if (object instanceof StatusCM) {
            this.log.info((Object)"Status error ");
            this.showError(object);
        } else {
            this.showError(object);
        }
    }

    private void showError(Object object) {
        ProblemNotifier.getDefaultNotifier().onProblem(ErrorStringUtil.getErrorEventMessageByObject(object));
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, ErrorStringUtil.getErrorDialogMessageByObject(this.locale, object), 10, DC.cases((int)1), UserCase.Ok);
        this.context.showDialog((DialogInterface)dialog);
    }
}

