/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.StatusCM;
import i18n.B;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.system.util.ErrorStringUtil;

public class FullnessStatusTask
implements Task {
    private ApplicationContext context;
    private Locale locale;
    private Logger log;

    public FullnessStatusTask(ApplicationContext context, Locale locale, Logger log) {
        this.context = context;
        this.log = log;
    }

    @Override
    public String getMessage() {
        return B.get((String)"Module.input.coffee.request.wait", (Locale)this.locale);
    }

    @Override
    public Object execute() {
        this.log.info((Object)"Start coffemat status task");
        try {
            StatusCM status = CoffeeMachine.getDefaultInstance().getStatus();
            if (status.getMode() != 0 && status.getMode() != -1 && status.getStatus() != 1001) {
                Map fn = CoffeeMachine.getDefaultInstance().getFullnessContainers();
                HashMap<String, Object> cm = new HashMap<String, Object>();
                int i = 0;
                for (Integer numb : fn.keySet()) {
                    String[] in = CoffeeHelper.getIngredientName(numb.shortValue());
                    if (in == null) continue;
                    cm.put("ing." + i + ".name", in[0]);
                    cm.put("ing." + i + ".value", fn.get(numb));
                    ++i;
                }
                cm.put("count", i - 1);
                CustomData cd = new CustomData();
                cd.setCustomData(cm);
                cd.setTemplate("coffee-fullness");
                this.context.getPrinterQueue().printCustomDocument(cd);
            }
            return status;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)("Recived answer: " + object));
        if (object != null && object instanceof StatusCM) {
            StatusCM statusCM = (StatusCM)object;
            if (statusCM.getMode() == 0 || statusCM.getMode() == -1 || statusCM.getStatus() == 1001) {
                this.log.info((Object)"Status error ");
                this.showError(object);
            } else {
                this.log.info((Object)"Status ok ");
            }
        } else {
            this.showError(object);
        }
    }

    private void showError(Object object) {
        ProblemNotifier.getDefaultNotifier().onProblem(ErrorStringUtil.getErrorEventMessageByObject(object));
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, ErrorStringUtil.getErrorDialogMessageByObject(this.locale, object), 10, DC.cases((int)1), UserCase.Ok);
        this.context.showDialog((DialogInterface)dialog);
    }
}

