/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.StatusCM;
import coffee.machine.model.VersionData;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class CoffeeMachineStatisticSender
implements Runnable {
    private static final long TIMEOUT = 1800000L;
    private ClientInterface clientInterface;
    private Integer lastStatus;
    private Logger log = Logger.getLogger((String)"app");

    public CoffeeMachineStatisticSender(ClientInterface clientInterface) {
        this.log.setAdditivity(false);
        CoffeeMachine.setDefaultInstance((CoffeeMachine)new CoffeeMachine());
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        CoffeeMachine cm = CoffeeMachine.getDefaultInstance();
        DeviceStatus ds = new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 0);
        this.clientInterface.sendStatus(ds);
        DeviceInfo di = new DeviceInfo(DeviceType.SimpleCoffeeMachine);
        di.setPort("127.0.0.1:2080");
        if (cm != null) {
            try {
                VersionData vd = cm.getVersionData();
                if (vd != null) {
                    di.setSerial(vd.getSerialNumber());
                    di.setFirmware(vd.getFirmwareCoffeMachinne());
                    di.setInfo(vd.getSoftwareVersion());
                }
                this.clientInterface.send(di);
            }
            catch (Exception ex) {
                this.clientInterface.send(di);
                this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                HashMap<Integer, Short> divs = new HashMap<Integer, Short>();
                try {
                    SelectorField sf;
                    Form f = FormHelper.parseCustom(new File(PathUtils.getAppHome() + "/resources/utility/coffee-fullness.xml"), Locale.getDefault());
                    if (f.getScreenSequence().getScreens().size() != 1) {
                        throw new Exception("Wrong number of screens");
                    }
                    ScreenDescription sd = (ScreenDescription)f.getScreenSequence().getScreens().get(0);
                    if (!sd.getSequence().getFields().isEmpty() && sd.getSequence().getFields().get(0) instanceof SelectorField && (sf = (SelectorField)sd.getSequence().getFields().get(0)).getItems() != null) {
                        for (SelectorItem si : sf.getItems()) {
                            try {
                                divs.put(Integer.parseInt(si.getValue()) - 1, (short)Math.log10(Integer.parseInt(si.getImage())));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception f) {
                    // empty catch block
                }
                Map fullness = cm.getFullnessContainers();
                for (Integer idx : fullness.keySet()) {
                    BoxInfo bi = new BoxInfo();
                    bi.setBoxNumber(Short.valueOf(idx.shortValue()));
                    bi.setCurrency("");
                    bi.setNominal(new Short("0"));
                    bi.setDeviceClass(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()));
                    bi.setDeviceType(DeviceType.SimpleCoffeeMachine.getName());
                    bi.setDeviceNumber(Short.valueOf((short)0));
                    bi.setTitle(CoffeeHelper.getBoxName(idx));
                    String[] in = CoffeeHelper.getIngredientName(idx);
                    if (in != null && in.length > 1) {
                        bi.setUnit(in[1]);
                    }
                    bi.setDividerDegree((Short)divs.get(idx));
                    this.clientInterface.sendDispenserBoxInfo(bi);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            while (!Thread.currentThread().isInterrupted()) {
                block21: {
                    try {
                        StatusCM status = CoffeeMachine.getDefaultInstance().getStatus();
                        ds = status.getMode() == 0 ? new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 2) : (status.getMode() == -1 ? new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 3) : (status.getMode() == 1001 ? new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 4) : new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 0)));
                        if (this.lastStatus == null || this.lastStatus.intValue() != ds.getStatus()) {
                            this.lastStatus = ds.getStatus();
                            this.clientInterface.sendStatus(ds);
                        }
                        Map fn = cm.getFullnessContainers();
                        for (Integer numb : fn.keySet()) {
                            BoxAmount ba = new BoxAmount();
                            ba.setBoxNumber(Short.valueOf(numb.shortValue()));
                            ba.setAmount(((Double)fn.get(numb)).intValue());
                            ba.setDeviceClass(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()));
                            ba.setDeviceNumber(Short.valueOf((short)0));
                            this.clientInterface.sendDispenserBoxAmount(ba);
                        }
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                        ds = new DeviceStatus(Short.valueOf(DeviceClass.CoffeeDispenser.getCode()), 1);
                        if (this.lastStatus != null && this.lastStatus.intValue() == ds.getStatus()) break block21;
                        this.lastStatus = ds.getStatus();
                        this.clientInterface.sendStatus(ds);
                    }
                }
                ThreadUtil.sleep((long)1800000L);
            }
        } else {
            this.clientInterface.send(di);
            this.log.error((Object)"No instance of CoffeeMachine");
        }
    }
}

