/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.mobile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.module.input.mobile.DefectorsVersion;
import ru.softlogic.system.util.HashUtils;
import ru.softlogic.system.util.PathUtils;

public class MobileDefectorsManager {
    public static final String DEFECTORS_CRC_FILE_NAME = "crc";
    public static final String DEFECTORS_FILE_NAME = "defectors.csv";
    public static final String DEFECTORS_ZIP_FILE_NAME = "defectors.csv.gz";
    public static final String DEFECTORS_PATCH_FILE_NAME = "patch";
    public static final String DEFECTOR_FILES_COUNT = "Defector.files.count";
    private static final String resourcesMobilePath = "/resources/mobile/";
    private static final String utf8 = "utf-8";
    private static MobileDefectorsManager instance = new MobileDefectorsManager();
    private Map<String, SoftReference<Integer>> defectors = new ConcurrentHashMap<String, SoftReference<Integer>>();
    private final Semaphore sm = new Semaphore(1);
    private final Logger log = Logger.getLogger((String)"app");

    public MobileDefectorsManager() {
        this.log.setAdditivity(false);
    }

    public static MobileDefectorsManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDefectors() {
        block20: {
            try {
                this.sm.acquire();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u043f\u0435\u0440\u0435\u0431\u0435\u0436\u0447\u0438\u043a\u043e\u0432");
                File defFile = new File(PathUtils.getAppHome() + resourcesMobilePath + DEFECTORS_FILE_NAME);
                if (defFile.exists()) {
                    DefectorsVersion dv = this.getLocalDefectorsVersion();
                    long fileCRC = HashUtils.calculateCRC32Checksum((File)defFile);
                    boolean flag = dv.getCrc() != fileCRC;
                    Integer suffix = AppDefaults.getInstance().getIntegerValue(DEFECTOR_FILES_COUNT, 50);
                    if (!flag) {
                        File last = new File(PathUtils.getAppHome() + resourcesMobilePath + (suffix - 1) + ".csv");
                        File last1 = new File(PathUtils.getAppHome() + resourcesMobilePath + suffix + ".csv");
                        if (!last.exists() || last1.exists()) {
                            flag = true;
                        }
                    }
                    if (flag) {
                        File[] listFiles;
                        File dir = new File(PathUtils.getAppHome() + resourcesMobilePath);
                        for (File f : listFiles = dir.listFiles((FilenameFilter)new RegexFileFilter("^\\d{1,5}\\.csv$"))) {
                            f.delete();
                        }
                        PrintWriter[] writers = new PrintWriter[suffix.intValue()];
                        BufferedReader br = null;
                        try {
                            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defFile), utf8));
                            for (int i = 0; i < suffix; ++i) {
                                writers[i] = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(PathUtils.getAppHome() + resourcesMobilePath + i + ".csv"), utf8));
                            }
                            String s = null;
                            while ((s = br.readLine()) != null) {
                                String[] split = s.split(":");
                                if (split.length != 3) continue;
                                try {
                                    int suf = (int)(Long.parseLong(split[0]) % (long)suffix.intValue());
                                    writers[suf].println(s);
                                }
                                catch (Exception e) {
                                    this.log.error((Object)e, (Throwable)e);
                                }
                            }
                            dv.setCrc(fileCRC);
                            this.writeLocalDefectorsVersion(dv);
                            this.defectors.clear();
                            this.log.info((Object)"\u0420\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u043f\u0435\u0440\u0435\u0431\u0435\u0436\u0447\u0438\u043a\u043e\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
                            IOUtils.closeQuietly((Reader)br);
                        }
                        catch (Exception e) {
                            this.log.error((Object)e, (Throwable)e);
                        }
                        finally {
                            IOUtils.closeQuietly(br);
                            for (int i = 0; i < suffix; ++i) {
                                IOUtils.closeQuietly((Writer)writers[i]);
                            }
                            break block20;
                        }
                        for (int i = 0; i < suffix; ++i) {
                            IOUtils.closeQuietly((Writer)writers[i]);
                        }
                        break block20;
                    }
                    this.log.info((Object)"\u0420\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u0435 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                    break block20;
                }
                this.log.info((Object)("File not exist: " + defFile.getAbsolutePath()));
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        this.sm.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findDefector(String number) {
        if (number == null) {
            return null;
        }
        SoftReference<Integer> obj = this.defectors.get(number);
        if (obj != null) {
            Integer id = obj.get();
            if (id != null) {
                return id;
            }
            this.defectors.remove(number);
        }
        boolean locked = false;
        try {
            locked = this.sm.tryAcquire(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        if (locked) {
            try {
                long numb = Long.parseLong(number);
                int suffix = (int)(numb % (long)AppDefaults.getInstance().getIntegerValue(DEFECTOR_FILES_COUNT, 50).intValue());
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + resourcesMobilePath + suffix + ".csv"), utf8));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        String[] split = s.split(":");
                        if (split.length != 3 || !number.equals(split[0])) continue;
                        Integer id = Integer.parseInt(split[1]);
                        this.defectors.put(number, new SoftReference<Integer>(id));
                        Integer n = id;
                        IOUtils.closeQuietly((Reader)br);
                        return n;
                    }
                    IOUtils.closeQuietly((Reader)br);
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(br);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            finally {
                this.sm.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefectorsVersion getLocalDefectorsVersion() {
        DefectorsVersion version;
        block5: {
            version = new DefectorsVersion();
            FileInputStream is = null;
            BufferedReader br = null;
            try {
                is = new FileInputStream(new File(PathUtils.getAppHome() + resourcesMobilePath + DEFECTORS_CRC_FILE_NAME));
                br = new BufferedReader(new InputStreamReader((InputStream)is, utf8));
                version.setCrc(Long.parseLong(br.readLine()));
                version.setVersion(Long.parseLong(br.readLine()));
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                break block5;
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(br);
            }
            IOUtils.closeQuietly((Reader)br);
        }
        return version;
    }

    public void writeLocalDefectorsVersion(DefectorsVersion dv) {
        try {
            FileUtils.write((File)new File(PathUtils.getAppHome() + resourcesMobilePath + DEFECTORS_CRC_FILE_NAME), (CharSequence)(dv.getCrc() + "\n" + dv.getVersion()));
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean patchDefectorsFile(File file) {
        BufferedReader br;
        PrintWriter pw;
        boolean res;
        block14: {
            File dtf;
            block15: {
                ArrayList<SoftReference<String>> toRemove = new ArrayList<SoftReference<String>>();
                res = false;
                dtf = new File(PathUtils.getAppHome() + resourcesMobilePath + DEFECTORS_FILE_NAME + ".tmp");
                File df = new File(PathUtils.getAppHome() + resourcesMobilePath + DEFECTORS_FILE_NAME);
                pw = null;
                br = null;
                boolean firstPartSuccess = false;
                try {
                    br = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(file)))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), utf8));
                    pw = new PrintWriter((Writer)new FileWriterWithEncoding(dtf, "UTF-8"));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("-")) {
                            toRemove.add(new SoftReference<String>(line.substring(1)));
                            continue;
                        }
                        pw.println(line);
                    }
                    firstPartSuccess = true;
                    IOUtils.closeQuietly((Reader)br);
                    br = null;
                    line = null;
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(df), utf8));
                    while ((line = br.readLine()) != null) {
                        String prefix = new String(line.substring(0, 10));
                        if (toRemove.contains(new SoftReference<String>(prefix))) continue;
                        pw.println(line);
                    }
                    res = true;
                    toRemove = null;
                    if (!firstPartSuccess) break block14;
                    br = null;
                    if (!res) break block15;
                    df.delete();
                }
                catch (Exception e) {
                    block16: {
                        boolean bl;
                        block17: {
                            block18: {
                                try {
                                    if (firstPartSuccess) {
                                        this.log.error((Object)e, (Throwable)e);
                                        break block16;
                                    }
                                    this.log.error((Object)e, (Throwable)e);
                                    dtf.delete();
                                    bl = false;
                                    if (!firstPartSuccess) break block17;
                                    br = null;
                                    if (!res) break block18;
                                    df.delete();
                                }
                                catch (Throwable throwable) {
                                    if (firstPartSuccess) {
                                        br = null;
                                        if (res) {
                                            df.delete();
                                            dtf.renameTo(df);
                                        } else {
                                            dtf.delete();
                                        }
                                    }
                                    IOUtils.closeQuietly(pw);
                                    IOUtils.closeQuietly(br);
                                    throw throwable;
                                }
                                dtf.renameTo(df);
                                break block17;
                            }
                            dtf.delete();
                        }
                        IOUtils.closeQuietly(pw);
                        IOUtils.closeQuietly((Reader)br);
                        return bl;
                    }
                    if (firstPartSuccess) {
                        br = null;
                        if (res) {
                            df.delete();
                            dtf.renameTo(df);
                        } else {
                            dtf.delete();
                        }
                    }
                    IOUtils.closeQuietly(pw);
                    IOUtils.closeQuietly((Reader)br);
                }
                dtf.renameTo(df);
                break block14;
            }
            dtf.delete();
        }
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Reader)br);
        return res;
    }
}

