/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.mobile;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import ru.softlogic.module.input.mobile.LocalCapacityElement;
import ru.softlogic.system.util.PathUtils;

public class LocalNumberExtractor {
    public static String getLocalMask(String cityCode) {
        if (cityCode == null || cityCode.isEmpty()) {
            return null;
        }
        File file = new File(PathUtils.getAppHome() + File.separator + "capacity-local.xml");
        if (file.exists() && file.canRead()) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(file);
                Node node = document.selectSingleNode("//split/i[@code='" + cityCode + "']");
                if (node != null) {
                    return node.valueOf("@split");
                }
            }
            catch (Exception ex) {
                Logger.getLogger((String)"pay").error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0435\u043c\u043a\u043e\u0441\u0442\u0435\u0439", (Throwable)ex);
            }
        }
        return null;
    }

    public static int getLengthByMask(String mask) {
        if (mask == null || mask.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < mask.length(); ++i) {
            if (mask.charAt(i) != '*') continue;
            ++count;
        }
        return count;
    }

    public static LocalCapacityElement[] getElements(String cityCode) {
        if (cityCode == null || cityCode.isEmpty()) {
            return null;
        }
        File file = new File(PathUtils.getAppHome() + File.separator + "capacity-local.xml");
        if (file.exists() && file.canRead()) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(file);
                List list = document.selectNodes("//rule/i[@code='" + cityCode + "']");
                if (list != null && !list.isEmpty()) {
                    LinkedList<LocalCapacityElement> res = new LinkedList<LocalCapacityElement>();
                    for (Object obj : list) {
                        Element el = (Element)obj;
                        try {
                            res.add(new LocalCapacityElement(Short.parseShort(el.valueOf("@p")), el.valueOf("@regex"), el.valueOf("@replace"), el.valueOf("@value")));
                        }
                        catch (Exception exception) {}
                    }
                    return res.toArray(new LocalCapacityElement[res.size()]);
                }
            }
            catch (Exception ex) {
                Logger.getLogger((String)"pay").error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0435\u043c\u043a\u043e\u0441\u0442\u0435\u0439", (Throwable)ex);
            }
        }
        return null;
    }

    public static String convertNumber(String number, LocalCapacityElement[] lces) {
        if (number == null || number.isEmpty() || lces == null || lces.length == 0) {
            return number;
        }
        for (LocalCapacityElement lce : lces) {
            if (!number.matches(lce.getValidateRegex())) continue;
            String newNumber = number.replaceAll(lce.getReplaceRegex(), lce.getReplaceValue());
            return newNumber;
        }
        return number;
    }
}

