/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.mobile;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import ru.softlogic.input.model.screen.ExtraButton;
import ru.softlogic.module.input.mobile.CapacityElement;

public class CapacityUpdater {
    private File file;
    private Map<Integer, ExtraButton> extraButtons;
    private List<CapacityElement> elements;
    private String mask;
    private Integer numberLenght;
    private Logger log;

    public CapacityUpdater(String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u0443\u0442\u0438 \u0434\u043e \u043c\u0430\u0441\u043e\u043a");
        }
        this.file = new File(path);
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
    }

    public void read() {
        if (this.file.exists()) {
            try {
                this.elements = null;
                this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u0431\u0430\u0437\u044b c \u043d\u043e\u043c\u0435\u0440\u043d\u044b\u043c\u0438 \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c\u0438");
                SAXReader reader = new SAXReader();
                Document document = reader.read(this.file);
                Element root = document.getRootElement();
                this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432");
                Element prv = root.element("providers");
                if (prv != null) {
                    this.extraButtons = new HashMap<Integer, ExtraButton>();
                    Iterator i = prv.elementIterator();
                    while (i.hasNext()) {
                        Element element = (Element)i.next();
                        if (element.attributeValue("extra-button-service") == null) continue;
                        try {
                            int id = Integer.parseInt(element.valueOf("@id"));
                            String srvId = element.attributeValue("extra-button-service");
                            if (srvId == null || srvId.isEmpty()) continue;
                            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u044d\u043a\u0441\u0442\u0440\u0430-\u043a\u043d\u043e\u043f\u043a\u0430: " + id + "->" + srvId));
                            ExtraButton extraButton = new ExtraButton(element.valueOf("@extra-button-name"), element.valueOf("@extra-button-image"), Integer.parseInt(srvId));
                            this.extraButtons.put(id, extraButton);
                        }
                        catch (Throwable ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", ex);
                        }
                    }
                }
                this.log.info((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u0435\u043c\u043a\u043e\u0441\u0442\u0438");
                Element cap = root.element("capacity");
                if (cap == null) {
                    throw new IllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0435\u043c\u043a\u043e\u0441\u0442\u0438");
                }
                this.mask = cap.attributeValue("mask");
                this.log.info((Object)("\u041c\u0430\u0441\u043a\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432: " + this.mask));
                String lenght = cap.attributeValue("lenght");
                if (lenght != null && lenght.matches("^\\d+$")) {
                    this.numberLenght = Integer.parseInt(lenght);
                }
                this.log.info((Object)("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u043e\u0432: " + this.numberLenght));
                this.elements = new LinkedList<CapacityElement>();
                Iterator i = cap.elementIterator();
                while (i.hasNext()) {
                    Element element = (Element)i.next();
                    int p = Integer.parseInt(element.valueOf("@p"));
                    String from = element.valueOf("@f");
                    String to = element.valueOf("@t");
                    this.elements.add(new CapacityElement(from, to, p));
                }
                this.log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + this.elements.size()));
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0431\u0430\u0437\u044b \u0441 \u043d\u043e\u043c\u0435\u0440\u0430\u043c\u0438: ", ex);
            }
        }
    }

    public List<CapacityElement> getElements() {
        return this.elements;
    }

    public Map<Integer, ExtraButton> getExtraButtons() {
        return this.extraButtons;
    }

    public String getMask() {
        return this.mask;
    }

    public Integer getNumberLenght() {
        return this.numberLenght;
    }
}

