/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.cashtonocard;

import i18n.B;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.model.BankModuleError;
import ru.softlogic.cards.v2.module.BankModule;
import ru.softlogic.cards.v2.module.BankModuleResultListener;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.BaseCardInputModule;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.card.proxy.BankDepositListenerProxy;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.PreinitHelper;
import ru.softlogic.module.payment.CashPaymentModule;
import ru.softlogic.module.processing.card.BankCardProcessingModule;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderHelperListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.srv.api.verify.ArgumentType;
import ru.softlogic.srv.api.verify.VerifyDataItem;
import ru.softlogic.srv.api.verify.VerifyResult;

public class CashToNoCardInputModule
extends BaseCardInputModule {
    private final ProviderHelper helper;
    private CommonScreen lastScreen;
    private BankModule bm;
    private Map<String, Object> data;

    public CashToNoCardInputModule(ApplicationContext context) {
        super(context);
        this.helper = new ProviderHelper(context);
    }

    @Override
    protected void _startModule(Environment environment, ApplicationContext context) {
        this.log.info((Object)"Start module: CashToNoCardInputModule");
        environment.setProcessingModule(new BankCardProcessingModule(context));
        environment.setPaymentModule(ModuleFactory.createCashPaymentModule(context, environment.getMenuItem(), new CashPaymentModule(context)));
        CardModuleStore.getInstance().setReference(environment.getPoint());
        this.data = new HashMap<String, Object>();
        this.cm = this.getCardModule(environment, new LocalGuiListener(context, environment, this.log));
        BankModule bankModule = this.bm = this.cm == null ? null : this.cm.getBankModule();
        if (this.bm != null) {
            CardModuleStore.getInstance().getBankDepositProxy().setListener(new LocalDepositResultListener());
            this.invokeOperation = true;
            try {
                int code = environment.getMenuItem().getService().getCode();
                BankDepositListenerProxy bankDepositProxy = CardModuleStore.getInstance().getBankDepositProxy();
                this.bm.deposit(PreinitHelper.getItemsData(code, this.locale), (BankModuleResultListener)bankDepositProxy);
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        } else {
            context.showDialog((DialogInterface)this.createNoCardModuleDialog());
        }
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.context.showScreen(new ContentScreenAdapter(this.lastScreen));
    }

    private void toPreparePayments(AccountInfo ai, HashMap<String, Object> serverData) {
        InputElement ie;
        Object obj;
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("sum");
        ssd.setDecor(AppDefaults.getInstance().getProperty("Module.cashtocard.payment.decor", null));
        this.inputData.putAll(this.data);
        if (serverData != null) {
            this.inputData.putAll(serverData);
        }
        if ((obj = this.inputData.get("PAN")) instanceof InputElement && (ie = (InputElement)obj).getValue() != null) {
            this.inputData.remove("PAN");
            this.inputData.put("id1", new InputElement("id1", B.get((String)"Module.card.pan", (Locale)this.locale), ie.getValue().replaceAll("^(\\d{6}).*(\\d{4})$", "$1*****$2")));
        }
        if (ai != null && this.inputData.get("ACCOUNT") != null) {
            this.inputData.remove("ACCOUNT");
            this.inputData.put("id1", new InputElement("id1", B.get((String)"Module.card.account", (Locale)this.locale), ai.getNumber()));
        }
        this._startPayment(this.environment, ssd, this.inputData);
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void _onClosed() {
            CashToNoCardInputModule.this.baseCancel(null);
        }

        @Override
        public void onCashRequire(boolean isEmitent, AccountInfo ai, CashRequireListener cl) {
            CashToNoCardInputModule.this.log.info((Object)("CardToNoCard.require: isEmitent = " + isEmitent + "; ai = " + ai + "; cl = " + cl));
            CashToNoCardInputModule.this.context.showWait(null);
            CardModuleStore.getInstance().setBankCashRequireListener(cl);
            if (AppDefaults.getInstance().getBooleanProperty("Module.cashtocard.comission.show", false)) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.commission", (Locale)CashToNoCardInputModule.this.locale), 10, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new LocalCommissionDialogListener(ai));
                CashToNoCardInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                HashMap<String, Object> form = new HashMap<String, Object>();
                form.put("id1", new InputElement("id1", "id1", ai == null ? "" : ai.getNumber()));
                form.put("account", new InputElement("account", "account", ai == null ? "" : ai.getNumber()));
                MenuItem mi = CashToNoCardInputModule.this.environment.getMenuItem();
                CashToNoCardInputModule.this.helper.verify(mi.getService(), mi.getCommission(), mi.isVerify(), form, (ProviderHelperListener)new LocalHelperListener(ai), CashToNoCardInputModule.this.locale, mi.isIgnoreMinMaxCommission());
            }
        }

        @Override
        public void onFormData(Map<String, Object> d) {
            CashToNoCardInputModule.this.data.putAll(d);
        }
    }

    private class VerifyConfirmScreenListener
    extends ScreenAdapter {
        private final AccountInfo ai;
        private final HashMap<String, Object> data;

        public VerifyConfirmScreenListener(AccountInfo ai, HashMap<String, Object> data) {
            this.ai = ai;
            this.data = data;
        }

        public void onAction(String action, Map<String, Object> localData, Runnable cancelListener) {
            CashToNoCardInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            CashToNoCardInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                CashToNoCardInputModule.this.toPreparePayments(this.ai, this.data);
            } else if (ActionType.isExit((String)action)) {
                CashToNoCardInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                CashToNoCardInputModule.this.cancel(null);
            }
        }
    }

    private class LocalHelperListener
    implements ProviderHelperListener {
        private final AccountInfo ai;

        public LocalHelperListener(AccountInfo ai) {
            this.ai = ai;
        }

        @Override
        public void onVerifyComplete(VerifyResult result) {
            CashToNoCardInputModule.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043d\u043e\u043c\u0435\u0440\u0430: " + result));
            if (result.getDataItems() != null && result.getDataItems().length > 0) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (VerifyDataItem vdi : result.getDataItems()) {
                    if (!ArgumentType.In.equals((Object)vdi.getType()) && !ArgumentType.InOut.equals((Object)vdi.getType())) continue;
                    data.put(vdi.getKey(), new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), vdi.getFlags() != null ? vdi.getFlags() : 0));
                }
                ConfirmScreenDescription sd = new ConfirmScreenDescription();
                sd.setButtons(InitModuleHelper.createKeyMap());
                sd.setTitle(result.getTitle());
                CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
                CashToNoCardInputModule.this.lastScreen = cs;
                cs.setListener((ScreenListener)new VerifyConfirmScreenListener(this.ai, data));
                try {
                    cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)false, (boolean)true), InitModuleHelper.buildScreenInit(CashToNoCardInputModule.this.environment, data));
                }
                catch (InitException ex) {
                    CashToNoCardInputModule.this.log.error((Object)ex, (Throwable)ex);
                    ModuleHelper.invoke(CashToNoCardInputModule.this.cancelListener);
                }
                CashToNoCardInputModule.this.context.showScreen(new ContentScreenAdapterKbr(cs));
            } else {
                CashToNoCardInputModule.this.toPreparePayments(this.ai, null);
            }
        }

        @Override
        public void toPayment() {
            CashToNoCardInputModule.this.log.debug((Object)"\u041e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f, \u043f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u043e\u043f\u043b\u0430\u0442\u0435");
            CashToNoCardInputModule.this.toPreparePayments(this.ai, null);
        }

        @Override
        public void onVerifyError() {
            CashToNoCardInputModule.this.log.info((Object)"Erron on verify");
            ModuleHelper.invoke(CashToNoCardInputModule.this.cancelListener);
            CashRequireListener bankCashRequireListener = CardModuleStore.getInstance().getBankCashRequireListener();
            if (bankCashRequireListener != null) {
                bankCashRequireListener.onCancel();
            }
        }
    }

    private class LocalCommissionDialogListener
    implements DialogListener {
        private final AccountInfo ai;

        public LocalCommissionDialogListener(AccountInfo ai) {
            this.ai = ai;
        }

        public void dialogClosed(UserCase userCase) {
            HashMap<String, Object> form = new HashMap<String, Object>();
            form.put("id1", new InputElement("id1", "id1", ""));
            form.put("account", new InputElement("account", "account", this.ai == null ? "" : this.ai.getNumber()));
            MenuItem mi = CashToNoCardInputModule.this.environment.getMenuItem();
            CashToNoCardInputModule.this.helper.verify(mi.getService(), mi.getCommission(), mi.isVerify(), form, (ProviderHelperListener)new LocalHelperListener(this.ai), CashToNoCardInputModule.this.locale, mi.isIgnoreMinMaxCommission());
        }
    }

    private class LocalDepositResultListener
    implements BankModuleResultListener<OperationDepositResult> {
        private LocalDepositResultListener() {
        }

        public void onError(BankModuleError bme, String message) {
            CashToNoCardInputModule.this.invokeOperation = false;
            CashToNoCardInputModule.this.log.info((Object)(">>>onError " + bme + ", " + message));
            UserAction.getInstance().update();
            if (bme == BankModuleError.ERROR_USER_CANCEL) {
                CashToNoCardInputModule.this.log.info((Object)"Operation canceled by user, show dialog");
                CashToNoCardInputModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.bank.deposit.error1", (Locale)CashToNoCardInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CashToNoCardInputModule.this));
                CashToNoCardInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                CashToNoCardInputModule.this.context.showWait(null);
                if (message == null || message.isEmpty()) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.bank.deposit.error2", (Locale)CashToNoCardInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CashToNoCardInputModule.this));
                    CashToNoCardInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.card.bank.deposit.error3", (Locale)CashToNoCardInputModule.this.locale), B.get((String)message, (Locale)CashToNoCardInputModule.this.locale, (String)message)), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CashToNoCardInputModule.this));
                    CashToNoCardInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            CashToNoCardInputModule.this.setCardPanHash(ci.getPanHash().getSha1());
        }
    }
}

